#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall-docs
version:              1.0.12
visibility:           public
id:                   dhall-docs-1.0.12-BjM7pPC8YBMEJWMtIyJ3PL
key:                  dhall-docs-1.0.12-BjM7pPC8YBMEJWMtIyJ3PL
license:              BSD-3-Clause
copyright:            2020 Germán Robayo
maintainer:           GenuineGabriella@gmail.com
author:               Germán Robayo
synopsis:             Generate HTML docs from a dhall package
description:
    Use this package if you want to create HTML documentation from your dhall
    packages:

    * See the "Dhall.Docs" module if you want to use this package as a library

    * Use the @dhall-docs@ program from this package if you want an executable

    The "Dhall.Docs" module also contains instructions for how to use this package

category:             Compiler
abi:                  2be5c30192f1eff4df19b0488e0b7db2
exposed:              True
exposed-modules:      Dhall.Docs Dhall.Docs.Core
hidden-modules:
    Dhall.Docs.CodeRenderer Dhall.Docs.Comment Dhall.Docs.Embedded
    Dhall.Docs.Html Dhall.Docs.Markdown Dhall.Docs.Store
    Dhall.Docs.Util Paths_dhall_docs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall-docs
hs-libraries:         HSdhall-docs-1.0.12-BjM7pPC8YBMEJWMtIyJ3PL
depends:
    base-4.17.2.1 base16-bytestring-1.0.2.0-1KBZ5ZZPFeSCnwHUKcc29o
    bytestring-0.11.5.3 containers-0.6.7
    cryptohash-sha256-0.11.102.1-4VBSeQTpF3u5ZDJY8bGL4o
    dhall-1.42.2-IPRf6a3v1vwGda6g7PiufF directory-1.3.7.1
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    lucid-2.11.20230408-GFnSWnOYqwgJAUVVTCh9oL
    megaparsec-9.6.1-EOzDd62z05A746SrHFAgQv
    mmark-0.0.7.6-8Z2gZLRjKaQ5llva6fmqr1 mtl-2.2.2
    optparse-applicative-0.18.1.0-6SU84hJLh447fL9O7dNXXg
    path-0.9.5-CpLa5rTA1sFDkSISiDRSpC
    path-io-1.8.2-LmXmsOStvAqIGqLDeduToz
    prettyprinter-1.7.1-51OmHe2bsb6Aqd2q2orwqG text-2.0.2
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/dhall-docs/html/dhall-docs.haddock
haddock-html:         /usr/share/doc/dhall-docs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

