#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall-docs
version:              1.0.12
visibility:           public
id:                   dhall-docs-1.0.12-7a61AisPnAtDXSmtLUYF32
key:                  dhall-docs-1.0.12-7a61AisPnAtDXSmtLUYF32
license:              BSD-3-Clause
copyright:            2020 Germán Robayo
maintainer:           GenuineGabriella@gmail.com
author:               Germán Robayo
synopsis:             Generate HTML docs from a dhall package
description:
    Use this package if you want to create HTML documentation from your dhall
    packages:

    * See the "Dhall.Docs" module if you want to use this package as a library

    * Use the @dhall-docs@ program from this package if you want an executable

    The "Dhall.Docs" module also contains instructions for how to use this package

category:             Compiler
abi:                  9711a2d60f047cf95ba6b387cc8bd719
exposed:              True
exposed-modules:      Dhall.Docs Dhall.Docs.Core
hidden-modules:
    Dhall.Docs.CodeRenderer Dhall.Docs.Comment Dhall.Docs.Embedded
    Dhall.Docs.Html Dhall.Docs.Markdown Dhall.Docs.Store
    Dhall.Docs.Util Paths_dhall_docs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall-docs
hs-libraries:         HSdhall-docs-1.0.12-7a61AisPnAtDXSmtLUYF32
depends:
    base-4.17.2.1 base16-bytestring-1.0.2.0-8y3SyptL8obHk6RuDrxcpW
    bytestring-0.11.5.3 containers-0.6.7
    cryptohash-sha256-0.11.102.1-B0dHxYRWPrO346e6jKDe9T
    dhall-1.42.2-LORaIJh1k346gKMmcYNc62 directory-1.3.7.1
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    lucid-2.11.20230408-BcudTv2OHEdcS13X6DnrN
    megaparsec-9.6.1-EGAiipKGhRa2zjyQ3XtPp3
    mmark-0.0.7.6-BSRsTaHkGpeJe5HqGW2WnL mtl-2.2.2
    optparse-applicative-0.18.1.0-26u6tT1hMVXIAnAEQGbXYx
    path-0.9.5-idbUMifDlP2bd476U5qs9
    path-io-1.8.2-Ceoc437d1uL6y6KkE8mYSd
    prettyprinter-1.7.1-G37JwSOM6BFGPcFlHNjXb6 text-2.0.2
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/dhall-docs/html/dhall-docs.haddock
haddock-html:         /usr/share/doc/dhall-docs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

