#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-LFal2HNlpSm3KQTmmOBSjz
key:                  dhall-1.42.3-LFal2HNlpSm3KQTmmOBSjz
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  ff3fc67dfadf1ca76adf1c55f4c1c1ad
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-LFal2HNlpSm3KQTmmOBSjz
depends:
    Diff-0.5-E8Q2BRELLWW2rpraq45tI3
    aeson-2.1.2.1-CM1TyKExMgH6p2KQqrdDHD
    aeson-pretty-0.8.10-3WCsO9UEOFd53JyI5jmmw7
    ansi-terminal-1.0.2-7enoCfAnx2SGJDVGgMW6rt
    atomic-write-0.2.1.1-Ii4z741Jf1Bqvnuc1iUcm base-4.17.2.1
    base16-bytestring-1.0.2.0-AZR9Ev6hMd0IJX97hPwFaq
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-9KyZd02Y5otGRG4cekIJFk
    cborg-0.2.10.0-L3698h3izWh8QcKTKu0nPI
    cborg-json-0.2.6.0-ERUuLj0pM5U9mMeSj4Hxwu containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-C48IawiLvGe7HXBcLBraBr
    data-fix-0.3.4-6FcTjA3oiTWIvNFQdixCfS deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-5I6ATpayUCHZDT7SQ31C exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-KeBS20Yjde9LBxM7GjytYo
    hashable-1.4.5.0-DrXzgEMDRcV8gNOMGO5wPZ haskeline-0.8.2
    http-client-0.7.19-9qUcwTVQqbvEShQpYcde6b
    http-client-tls-0.3.6.4-KN3JTiWE2EI1kyisYRtf57
    http-types-0.12.4-9tb655S6p8NAIcFLCK3aeD
    indexed-traversable-0.1.4-CjelN0MuLjgFb4a6UstzaC
    megaparsec-9.7.0-3LaPBNRfEWMD5TdaoQ3jm0
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-FpQrzNLQnEFHV7gxKif8bC
    optparse-applicative-0.18.1.0-EjA2kXCQRKtFyUz1duz30L
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-4Avmhnq4mpdAan7s2Mf6Hi
    pretty-simple-4.1.3.0-LCEmEHDuOawJ8LlOgjGF1K
    prettyprinter-1.7.1-80F1dUtwFWzDp5CT3ZZVKz
    prettyprinter-ansi-terminal-1.1.3-IaiwJGU5h7gDXHX3Nxd5K0
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-BCRNugtxiDS8UMOiZ0ZEsF
    serialise-0.2.6.1-EKZ3M8KXi9bHko0rjno3sQ template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-FLkdy6U7zHpWZQV1LEVVQ
    text-short-0.1.6-AdHnHrpO3sZ2xlsGvlHoPI
    th-lift-instances-0.1.20-29DDNPR5JfQ5pbvkb6utNQ time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-8Y7lpXTSloK7vqVswTol3
    unordered-containers-0.2.20-FLM1pZb3BI5FpyNo5sVXNv
    vector-0.13.2.0-LmFi28PTaN7DJJszRwFTiC

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

