#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-EZMh3BUVdR52oMUj5x1SS5
key:                  dhall-1.42.2-EZMh3BUVdR52oMUj5x1SS5
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  6d215de157c5bf3b99d535aad405c5d1
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-EZMh3BUVdR52oMUj5x1SS5
depends:
    Diff-0.4.1-9HGGTyO9t5E8DUBaQPBda0
    aeson-2.1.2.1-EZ4q40CmD1e6rYIqwxbubT
    aeson-pretty-0.8.10-4gBtzzYmxzULYUKdL0bsM
    ansi-terminal-1.0.2-D46JaHr1BfPBLAK7nuv4I
    atomic-write-0.2.1.1-BrGoG3yJqZdCDV9a69oGt base-4.17.2.1
    base16-bytestring-1.0.2.0-KBep11INWPS4gh3hA0irR7
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-Bc7QIDcajSYD5EyDIDukoT
    cborg-0.2.10.0-8HElF4LsB9oDMQjRgG6Z7W
    cborg-json-0.2.6.0-3NzjFJYbaTVC2WgxmriD6N containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-16wRg0gM8EaDoVyZpUOCza
    data-fix-0.3.4-Hk7ottUiQPP3SSFpayflzz deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-AIl8OufkWDPLA8jVtbiqky exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.2-GmGFc1acUw6YncsN3qIxs
    hashable-1.4.4.0-7zzKXDBa1HP1F6vPi1Tvtg haskeline-0.8.2
    http-client-0.7.18-2ofV5QEO18r5DBx66M5AT0
    http-client-tls-0.3.6.4-6wdDSE7a7MH1UuelJ2W96c
    http-types-0.12.4-DxE0ilwtjMO1bR6EnKEYPH
    indexed-traversable-0.1.4-9Yra3WDK9eE6oqTuJLwCGF
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-6qeEGREH0fMn1gOMY5ab1
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-F1pCk9rgbkv7rdfQWWKihk
    optparse-applicative-0.17.1.0-CKO7Hv5HIMoIThZFruc57S
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-4KzOWEJeX4HzHYqgil1D
    pretty-simple-4.1.3.0-5M4RGQ281lN64WPBL4oGLg
    prettyprinter-1.7.1-K49FGRh0RcS7wKSRgaQVIq
    prettyprinter-ansi-terminal-1.1.3-5ygAz6ImaPm6RZS7bXOXnZ
    profunctors-5.6.3-IrIOzlkE4qyKAowsmKVLhe
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-EaRpQXcrvKCD1LBpAEBJcM
    serialise-0.2.6.1-FXpUTqHXUEw3GqZGUWKUQk template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-90c57sbTt4xFNfqIldCX7D
    text-short-0.1.6-6JESF0ntfWwGBrtTMoZzkY
    th-lift-instances-0.1.20-44S0PgyFzrn3ocnzbt19xG time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.3-iPFBR0zD3CJdfxtA2wtTV
    unordered-containers-0.2.20-Kq2dPHqifzB9n0MYGmTosg
    vector-0.13.2.0-F8322NeNtfL69paM3N9AVt

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

