#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-Hqks8kKyZlTFj0B1XQrOLH
key:                  dhall-1.42.2-Hqks8kKyZlTFj0B1XQrOLH
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  fb94eeda4f1d4aad1c5b386141777700
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-Hqks8kKyZlTFj0B1XQrOLH
depends:
    Diff-0.5-FlMLDRSdJaZJnaSeHoV7FH
    aeson-2.1.2.1-LTS2NYlb1uX1OFFp0jy4wh
    aeson-pretty-0.8.10-2EpQzVfEEmfGtQ3rFWDPYR
    ansi-terminal-1.0.2-22xggRH3qa0GcEZ754vdyz
    atomic-write-0.2.1.1-BZ3RjqQN1HV3uIcBZNcvhN base-4.17.2.1
    base16-bytestring-1.0.2.0-4RSPY9wdSACLYMQREwRCeE
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-FHIyOcPiW8PKDdKhHarL3Z
    cborg-0.2.10.0-KVyZcVfX9we44SWBp7ysu8
    cborg-json-0.2.6.0-Gi56qW4xcqR4lXBOwYdLF3 containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-1C5Jj7LV2TnKZUs8wMmEFu
    data-fix-0.3.4-59PPjdvkGb49zqCFaqVd5N deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-8qNEprCTolwLZajUvJQCJe exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-9VsnZI7XLUj56vcfyJO2bl
    hashable-1.4.4.0-32D8TF68xTpFTCUtV1slOl haskeline-0.8.2
    http-client-0.7.19-68a6qtEv6rj7VpzBTCDGAi
    http-client-tls-0.3.6.4-AAPFMBKckpmB2hdicty3YJ
    http-types-0.12.4-D9QL6TIrURkF1xQ74r64OS
    indexed-traversable-0.1.4-FUUuMGYQ6soDzHvrIh7KUw
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-KvGhsHhDwML9j6n1SsyhuZ
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-64n8drQTzmmFvISVTpacVu
    optparse-applicative-0.18.1.0-Ggqw09Qc75xDddPmwkWqAk
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-FeDsK74ZKVnKzsYPDMhAKA
    pretty-simple-4.1.3.0-BlSUOWtowv76Nsz3Amgda0
    prettyprinter-1.7.1-BBXLTkLEQRl40uOvW3t4pw
    prettyprinter-ansi-terminal-1.1.3-33kZdcwyY5M8HtWIXW1CoT
    profunctors-5.6.3-KX2EIyoit6HH68OSd7rf0q
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-ECM1X4w9aCV1oDTMJMlYIW
    serialise-0.2.6.1-KX1DKpRToVpFmkO3dmqpFn template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-3b7zfpar1207RxIgAg4HzI
    text-short-0.1.6-1dWLpfGGnMp1z92GGSzHhJ
    th-lift-instances-0.1.20-HZifh4rl1QdKQIg6ESdI7W time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-w5z2WDqOPvD7o1WRSdyI9
    unordered-containers-0.2.20-AhSAKQoMQ97FOa03PWrXZ
    vector-0.13.2.0-PKWel9ZBueBULxf3GbwPA

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

