#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-KtXNTs1px5fDAZhIw2O0Z5
key:                  dhall-1.42.2-KtXNTs1px5fDAZhIw2O0Z5
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  b79a2174d831b6e886ee8d86158f0a57
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-KtXNTs1px5fDAZhIw2O0Z5
depends:
    Diff-0.4.1-EczZjINN3WM5dE3JWe9jeU
    aeson-2.1.2.1-wY4CXNP4Ti6TCaMY1tyMf
    aeson-pretty-0.8.10-FF3kbqs1WvtKfkblP58Xcl
    ansi-terminal-1.0.2-JhmKbae07oX7bHm2tOBr0F
    atomic-write-0.2.1.1-4f02AHmNs4fLp9UOFRGi5B base-4.17.2.1
    base16-bytestring-1.0.2.0-KD4dfaPaqyzHzwlio6MK07
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-A6Av13j1PriHVZgHNthY8h
    cborg-0.2.10.0-5l0qrlK9GoO9f01jDwZA5x
    cborg-json-0.2.6.0-5sRVgyNkRUqLKXDwavVtV9 containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-EHgZuatqPpmIr6mw7RrMYx
    data-fix-0.3.4-Ic4RpFALHgTFxDi2KFv1Xo deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-XHTPzGYQ146hY1b6mRqdU exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-AugNo1yuObL3QVjQ7epakw
    hashable-1.4.4.0-ER9qsIVdqB66mmnPytAzi1 haskeline-0.8.2
    http-client-0.7.19-C1MyFeZ6J0U64oNAVz8qWH
    http-client-tls-0.3.6.4-2UCAQd74svUAKy6rR9fBGJ
    http-types-0.12.4-75PPyaYnKWt41SOfuGm1SN
    indexed-traversable-0.1.4-GiogE6maAB3IzBkFbVsEUi
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-6xkhHCmKEAZB1EmG1WiH2F
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-95fWnkSq4twGVejB9ewxKe
    optparse-applicative-0.18.1.0-ImNwmQfwdUdQZElVvxe6u
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-BBCj7Bb5jk88ztzRJGKsZL
    pretty-simple-4.1.3.0-D7LMPn9Xbgc1hYUqBdkbQ8
    prettyprinter-1.7.1-AWOpW71pl8nIJPFNGLPbj
    prettyprinter-ansi-terminal-1.1.3-1QKmxX9Fvnt1H04g2qTpIN
    profunctors-5.6.3-68oxrF8737XCyiY0Ff7GIY
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-DLDr5nembSsHeUMWxBP2Rn
    serialise-0.2.6.1-9qmTF4lCGepER08xQ8pvKY template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-GlJTVBbpUUbDAvrnU9l1Dz
    text-short-0.1.6-KE0J1f4kG7KEBU51g1mFmf
    th-lift-instances-0.1.20-It2hljbRJK921322PJ0Bac time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-KxuMsRfldAv3o1PX9QN6ga
    unordered-containers-0.2.20-BdnqkwZm9bx6ocoMK9HG74
    vector-0.13.2.0-B5pfN7kp2sVHpMWItbJQ58

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

