#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-Dash1cJFx7nJepsSGGt3L1
key:                  dhall-1.42.2-Dash1cJFx7nJepsSGGt3L1
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  68d5b68deee688851448c0b87dcfe96e
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-Dash1cJFx7nJepsSGGt3L1
depends:
    Diff-0.4.1-522VlxpLzPnKEcK3j61f8g
    aeson-2.1.2.1-2383fjET7FWJSHJW4VQuW
    aeson-pretty-0.8.10-55Ky77pX1R47nlIW5qbT4r
    ansi-terminal-1.0.2-5TjUZ7gCnw1CP0OaHljXa6
    atomic-write-0.2.1.1-ErcUM9gnLz4JBPW1qEP9xn base-4.17.2.1
    base16-bytestring-1.0.2.0-KCotoilfKRdKxSfUvCJUpM
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-L5gSnJGPP5IIfg5Ct42zAo
    cborg-0.2.10.0-69LNP0PYs7hEOe6u8rbb9F
    cborg-json-0.2.6.0-5a2DLEznRHRBbqspzEJbf6 containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-Dlz8Sxciknf71FGjuHVr8B
    data-fix-0.3.4-FLnqEc7q25c7LXZKsHVOnh deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-Ff5UFzCu5N6FfWf3LTb21i exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-7EuMeyyMsYRE1yxFdjaoIp
    hashable-1.4.4.0-5SoCNaysfySGuPwu0aljBu haskeline-0.8.2
    http-client-0.7.19-L1utxVEiLaAGw6Jin0pjGQ
    http-client-tls-0.3.6.4-GPXWf86JjcLLjWRBBwYJzj
    http-types-0.12.4-J468GPAKalzFHPyn7Dxh3c
    indexed-traversable-0.1.4-32owkfOBjPeHHjn6v5P4Ru
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-ATLDnW2l6g3Lq6818qHsE4
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-JT5mjmfFxkg6DEC2jAgmZ6
    optparse-applicative-0.18.1.0-2d5KBqGSFxr6w2uOa2AvYP
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-1SQOU8uayYoHImeArjIdoS
    pretty-simple-4.1.3.0-LMd5IB5rW3d4pMdJ74QgSd
    prettyprinter-1.7.1-9QhHPrVd9M8A9sreY2Uj3h
    prettyprinter-ansi-terminal-1.1.3-GWhQt3CM01S5eyYpZ5CutC
    profunctors-5.6.3-54dftqYvfC87HlKhU8lZc
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-IYXDhI1DsbO4omE9hYw4Ya
    serialise-0.2.6.1-3nJZTnRX4IJ4AiHkHeTD8I template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-8M64DBNY4dEKsO8Cl8td9q
    text-short-0.1.6-Kv7P2ZX0BeHFix0EyOc2uN
    th-lift-instances-0.1.20-A4575mZCL983y8sGHoOplu time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-ISYORPhqblp3hlkoU2fe45
    unordered-containers-0.2.20-AeV3HTkHtCc6BQ9fzLSSB8
    vector-0.13.2.0-52P7Ozt5w3I6hi4WvheJB9

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

