#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-Ine8xSr0hS16Y6kg7msV5w
key:                  dhall-1.42.2-Ine8xSr0hS16Y6kg7msV5w
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  8348bfecf10a93a42fd8ba30424a621a
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-Ine8xSr0hS16Y6kg7msV5w
depends:
    Diff-0.4.1-KLr9PfX1xcQ7rTrhHR462U
    aeson-2.1.2.1-6q2KNYwRaL29rPm6MMaiUC
    aeson-pretty-0.8.10-tSS21E5UX6Le9dDEWI2uO
    ansi-terminal-1.0.2-IimOqSN1qRUFeipP6ofJQ
    atomic-write-0.2.1.1-79HlH5Y8ABhBbZwOI8mVkC base-4.17.2.1
    base16-bytestring-1.0.2.0-3kwon8iNzO25udiTa31L4P
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-fOfWi0N5mt64FY3ZUEjlf
    cborg-0.2.10.0-3atZGK2chkCLIelVIL8bCb
    cborg-json-0.2.6.0-D6fxZycMH4p1LCLdaF0yq9 containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-MsUrUv7NriLNXNBCFbibr
    data-fix-0.3.4-3JEzm3j6ClsKmjMXXk9BpH deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-KvoMqZPL24oBBecsypeEJP exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-FOV0FnFXgsXKlRIPN0vFrQ
    hashable-1.4.4.0-AmJtI56ndXc1GvGfBNNgwb haskeline-0.8.2
    http-client-0.7.19-2XRSbtk4hrv80aqsDMrhLG
    http-client-tls-0.3.6.4-JPbMvFYYazPC4HKKOIQQxM
    http-types-0.12.4-DI0pM0gIACkLbu0K6LN6Y6
    indexed-traversable-0.1.4-HasVynAVtv5C4gt3RjLYOy
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-9KX7uZoGWhIHAGHTH7OWSU
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-4guMK9PpDjI4XiQikAf4nE
    optparse-applicative-0.18.1.0-B5S7p3yvcpkHKfw0kuCuBU
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-AbMqtfS88aCIawBScMb3Sn
    pretty-simple-4.1.3.0-8AiFe1KlAsmGrL9Kgh8Tko
    prettyprinter-1.7.1-5xgqmGXqgSr2RPa1NTsZyQ
    prettyprinter-ansi-terminal-1.1.3-BMaxYpGY1hqAqhAfKIKQLq
    profunctors-5.6.3-9oHJRkGqT8UJV4EmomAxQT
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-KXoba1fOMYH676R2WXZfYW
    serialise-0.2.6.1-CCRhDeInvUJHj0l88238bF template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-17n5BdDarfuBd03ARfhCgx
    text-short-0.1.6-LDWYVUWqMStFgr5KPFajNc
    th-lift-instances-0.1.20-75e0bbi0poAC0AylMFebPe time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-F45C0yQb72PB0noYxmBbjG
    unordered-containers-0.2.20-3NcLl7S6t7kAuh7l4Ieeoo
    vector-0.13.2.0-CQ8QMV1t4PN5YFZtNXivGS

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

