#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-2Z89yRfyTyQ3ufnPqGCV4s
key:                  dhall-1.42.2-2Z89yRfyTyQ3ufnPqGCV4s
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  1a21d273ffd2b694d90e17ed10f5f569
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-2Z89yRfyTyQ3ufnPqGCV4s
depends:
    Diff-0.4.1-3XSAUTYqfoXJz3dVFogLZy
    aeson-2.1.2.1-7goQjQKasWuq7oOasot83
    aeson-pretty-0.8.10-De32aII9BKHDuW1D9lF53q
    ansi-terminal-1.0.2-5q6RGAEXM9Iu4g3iI1aX2
    atomic-write-0.2.1.1-AzSzzhFtibK4KJDBXMNifv base-4.17.2.1
    base16-bytestring-1.0.2.0-AruU1abSL9kB4FwSdXdpL1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-K9RqmTXohzcArWLcYT3z8C
    cborg-0.2.10.0-CD7Wm4BWQWP8JKYwvn0r7F
    cborg-json-0.2.6.0-CW782EpOiNj7tZObTxUvyG containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-EUWdCiCcJd4Axh6LBD5ZTc
    data-fix-0.3.4-JRUuGn1EtkV9Aimb3ju7o7 deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-Kx5w7TTJpC6LAET8edNsqP exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-AKjBEqtrZHK9WiXwsDmrQE
    hashable-1.4.4.0-1zcla4qwUGf6ADT5z5m7Nb haskeline-0.8.2
    http-client-0.7.18-CnXCdYMBeS1GdWldzgGjBw
    http-client-tls-0.3.6.4-3zbnWCRdld0FLP53SxzUaK
    http-types-0.12.4-IhtLMXP6VlH4EvGJYn8uz7
    indexed-traversable-0.1.4-1jVJAb9Ott1EiIUD50SH50
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-Bx9HL7OUnKeEbRFabqUOjM
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-5CjZ6bo06zN4C2hTxMZR32
    optparse-applicative-0.18.1.0-GDwWCLBUeEeIARGaJHYM6i
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-GqMDnuggILO27d7nc6UU3m
    pretty-simple-4.1.3.0-BXqeKKclki8L7lVdUFeLTF
    prettyprinter-1.7.1-1debP0Fsl3J1yTjeZdDCQh
    prettyprinter-ansi-terminal-1.1.3-IvvX5ElDgKJ4OQRHTThyNf
    profunctors-5.6.3-L21qmF9iXw2FcRafgVQ9Hj
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-HfCn6ildxXk6zQelWj77aL
    serialise-0.2.6.1-KDLHXfA2x1f9jWp8lwvKO1 template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-4PhRZV1cxhJqUYrFJ05lx
    text-short-0.1.6-2R6TTZgmlE2D0QDVS4Qfvx
    th-lift-instances-0.1.20-Ivz6v01n2Tc8scUfJz24CY time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-3SBsXwUhhAM1AlokChSoJS
    unordered-containers-0.2.20-5ChD9TF8iAH5uLARI0QLMz
    vector-0.13.2.0-GjxrA8HCtQq4MGRlxeWifh

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

