#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-KMY04THIxy77tFNXpglzEq
key:                  dhall-1.42.2-KMY04THIxy77tFNXpglzEq
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  fbe647f250c0d7026c1f382e4dedd21a
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-KMY04THIxy77tFNXpglzEq
depends:
    Diff-0.4.1-6bMg2DCzebKFLXeuvfgV7b
    aeson-2.1.2.1-F9MXb1A8ug6GkYytoGh4jA
    aeson-pretty-0.8.10-3IneY4B7RymIuXlHqWnLhh
    ansi-terminal-1.0.2-8ftyjG1asvZBfIAqqefv8L
    atomic-write-0.2.1.1-D3q3YYO8Z3sAl1u5DgyAtM base-4.17.2.1
    base16-bytestring-1.0.2.0-5vlLRlPqKexCB3C79nTCDd
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-Az6gtf7HlYzJEXK7A4kQ5x
    cborg-0.2.10.0-48LE1Fpbwf32yWny60bjXM
    cborg-json-0.2.6.0-GpTPMFvkeZWGrDcxbvvZiP containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-K0Sj8rGRL4X8jzfuDtSAmy
    data-fix-0.3.4-Gwr5CMj1VygI6U0r5nAxwF deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-IyYh2PSUiRVI34OnkcVMxx exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-AvvNOrgNqEOLnqO4AaPNgu
    hashable-1.4.4.0-FG1b1gw3lrmKPDYe5KupbE haskeline-0.8.2
    http-client-0.7.18-GDC9HFEBSpxLTKz1dfTnFD
    http-client-tls-0.3.6.4-692MveemGYY98CzdRZjDd3
    http-types-0.12.4-1P1R4JUxLuAK31ciTRSGza
    indexed-traversable-0.1.4-sHndVhfz3Y5KGJ22wKiRW
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-62V38K3gknlIcNW2QJXG5P
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-L8nDuI5zE9yEZ3pwnnu7AU
    optparse-applicative-0.18.1.0-8BM84nMNO6C3REk9JaN2lH
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-J6vV8xNzLL92SUgHZUP3VD
    pretty-simple-4.1.3.0-BEIyQmcf9Hd39LQwLbdCef
    prettyprinter-1.7.1-3W0ElPC5NNG6rVoiMzjO1q
    prettyprinter-ansi-terminal-1.1.3-1LtMy41bD0h3EPsVS7zod3
    profunctors-5.6.3-18hFN5Uw6OMIT1lU2anoWQ
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-IuEDgnpy5lN4JI5naZeXd4
    serialise-0.2.6.1-7NFmOR42yxm1dqlHXhClUK template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-50z5aas4BN9Bi7iLxWLiGt
    text-short-0.1.6-71LcX2fy78wGcAWdL5PVyD
    th-lift-instances-0.1.20-L9lFeMq1oic3NYmDk9nmmY time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-6EcuQ5mZqgo5NszRPIcG1
    unordered-containers-0.2.20-Kb1zmdIZFsX5Z4trT8w0xB
    vector-0.13.2.0-3KdUWUHYfVjDmpelwHDbn6

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

