/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerExtensionBase;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;

public class PostgreServerEdb
extends PostgreServerExtensionBase {
    public static final String TYPE_ID = "edb";
    public static final String EDB_OBJECT_CLASS = "com.edb.util.PGobject";
    private Boolean isNspParentColumnExists;

    public PostgreServerEdb(PostgreDataSource dataSource) {
        super(dataSource);
    }

    @Override
    public boolean supportsEntityMetadataInResults() {
        return true;
    }

    @Override
    public boolean supportsCopyFromStdIn() {
        return true;
    }

    @Override
    public String getServerTypeName() {
        return "EnterpriseDB";
    }

    @Override
    public boolean supportsEventTriggers() {
        return this.dataSource.isServerVersionAtLeast(9, 3);
    }

    @Override
    public boolean supportsPGConstraintExpressionColumn() {
        return this.dataSource.isServerVersionAtLeast(8, 0);
    }

    @Override
    public boolean supportsRowLevelSecurity() {
        return this.dataSource.isServerVersionAtLeast(10, 0);
    }

    @Override
    public PostgreDatabase.SchemaCache createSchemaCache(PostgreDatabase database) {
        return new EDBSchemaCache();
    }

    @Override
    public boolean isPGObject(@NotNull Object object) {
        String className = object.getClass().getName();
        return EDB_OBJECT_CLASS.equals(className);
    }

    private class EDBSchemaCache
    extends PostgreDatabase.SchemaCache {
        private EDBSchemaCache() {
        }

        @Override
        protected boolean addExtraCondition(@NotNull JDBCSession session, @NotNull StringBuilder query) {
            if (PostgreServerEdb.this.isNspParentColumnExists == null) {
                PostgreServerEdb.this.isNspParentColumnExists = PostgreUtils.isMetaObjectExists(session, "pg_namespace", "nspparent");
            }
            if (PostgreServerEdb.this.isNspParentColumnExists.booleanValue()) {
                query.append("WHERE n.nspparent = 0 ");
                return true;
            }
            return false;
        }
    }
}

