/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model.plan;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanNode;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class MySQLPlanNodeJSON
extends MySQLPlanNode
implements DBPPropertySource {
    private MySQLPlanNodeJSON parent;
    private String name;
    private JsonObject object;
    private Map<String, Object> nodeProps = new LinkedHashMap<String, Object>();
    private List<MySQLPlanNodeJSON> nested = new ArrayList<MySQLPlanNodeJSON>();

    public MySQLPlanNodeJSON(MySQLPlanNodeJSON parent, String name, JsonObject object) {
        this.parent = parent;
        this.name = name;
        this.object = object;
        this.parseObject(name, object);
    }

    public MySQLPlanNodeJSON(MySQLPlanNodeJSON parent, Map<String, Object> attributes) {
        this.parent = parent;
        this.nodeProps.putAll(attributes);
    }

    public Map<String, Object> getNodeProps() {
        return this.nodeProps;
    }

    private void parseObject(String objName, JsonObject object) {
        for (Map.Entry prop : object.entrySet()) {
            String propName = (String)prop.getKey();
            JsonElement value = (JsonElement)prop.getValue();
            if (value instanceof JsonObject) {
                if ("cost_info".equals(propName)) {
                    this.parseObject(propName, (JsonObject)value);
                    continue;
                }
                if ("query_block".equals(propName)) {
                    this.name = "query_block";
                    this.parseObject(propName, (JsonObject)value);
                    continue;
                }
                if ("table".equals(propName) && "query_block".equals(objName)) {
                    this.name = "table";
                    this.parseObject(propName, (JsonObject)value);
                    continue;
                }
                this.addNested(propName, (JsonObject)value);
                continue;
            }
            if (value instanceof JsonArray) {
                boolean isProp = false;
                int itemIndex = 0;
                for (JsonElement item : (JsonArray)value) {
                    if (item instanceof JsonObject) {
                        this.addNested(propName + "#" + ++itemIndex, (JsonObject)item);
                        continue;
                    }
                    isProp = true;
                    break;
                }
                if (!isProp) continue;
                this.nodeProps.put(propName, value.toString());
                continue;
            }
            this.nodeProps.put(propName, value.getAsString());
        }
    }

    private void addNested(String name, JsonObject value) {
        if (this.nested == null) {
            this.nested = new ArrayList<MySQLPlanNodeJSON>();
        }
        this.nested.add(new MySQLPlanNodeJSON(this, name, value));
    }

    @Property(order=0, viewable=true)
    public String getNodeType() {
        return this.name;
    }

    @Property(order=1, viewable=true)
    public String getNodeName() {
        Object accessType;
        Object nodeName = this.nodeProps.get("table_name");
        if (nodeName != null && (accessType = this.nodeProps.get("access_type")) != null) {
            return String.valueOf(nodeName) + " (" + String.valueOf(accessType) + ")";
        }
        return nodeName == null ? null : String.valueOf(nodeName);
    }

    @Property(order=10, viewable=true)
    public Number getNodeCost() {
        Object readCost = this.nodeProps.get("read_cost");
        if (readCost == null) {
            readCost = this.nodeProps.get("query_cost");
        }
        if (readCost == null) {
            readCost = this.nodeProps.get("cost");
        }
        if (readCost == null) {
            if (this.nested != null) {
                long totalCost = 0L;
                for (MySQLPlanNodeJSON child : this.nested) {
                    Number childCost = child.getNodeCost();
                    if (childCost == null) continue;
                    totalCost += childCost.longValue();
                }
                return totalCost;
            }
            return null;
        }
        return CommonUtils.toDouble((Object)readCost);
    }

    public Number getNodePercent() {
        return null;
    }

    public Number getNodeDuration() {
        return null;
    }

    @Property(order=11, viewable=true)
    public Number getNodeRowCount() {
        Object rowCount = this.nodeProps.get("rows_examined_per_scan");
        if (rowCount == null && (rowCount = this.nodeProps.get("rows")) == null && this.nested != null) {
            long totalRC = 0L;
            for (MySQLPlanNodeJSON child : this.nested) {
                Number childRC = child.getNodeRowCount();
                if (childRC == null) continue;
                totalRC += childRC.longValue();
            }
            return totalRC;
        }
        return rowCount == null ? null : Long.valueOf(CommonUtils.toLong((Object)rowCount));
    }

    public MySQLPlanNodeJSON getParent() {
        return this.parent;
    }

    public Collection<MySQLPlanNodeJSON> getNested() {
        return this.nested;
    }

    public Object getProperty(String name) {
        return this.nodeProps.get(name);
    }

    public String toString() {
        return this.object == null ? this.nodeProps.toString() : this.object.toString();
    }

    public Object getEditableValue() {
        return this;
    }

    public DBPPropertyDescriptor[] getProperties() {
        DBPPropertyDescriptor[] props = new DBPPropertyDescriptor[this.nodeProps.size()];
        int index = 0;
        for (Map.Entry<String, Object> attr : this.nodeProps.entrySet()) {
            props[index++] = new PropertyDescriptor("Details", attr.getKey(), attr.getKey(), null, String.class, false, null, null, false);
        }
        return props;
    }

    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, String id) {
        return this.nodeProps.get(id);
    }

    public boolean isPropertySet(String id) {
        return false;
    }

    public boolean isPropertyResettable(String id) {
        return false;
    }

    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, String id) {
    }

    public void resetPropertyValueToDefault(String id) {
    }

    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, String id, Object value) {
    }
}

