#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cryptol
version:              3.1.0
visibility:           public
id:                   cryptol-3.1.0-6QdI0iSLpzbGJ4Eq4O9Qmf
key:                  cryptol-3.1.0-6QdI0iSLpzbGJ4Eq4O9Qmf
license:              BSD-3-Clause
copyright:            2013-2022 Galois Inc.
maintainer:           cryptol@galois.com
author:               Galois, Inc.
homepage:             http://www.cryptol.net/
synopsis:             Cryptol: The Language of Cryptography
description:
    Cryptol is a domain-specific language for specifying cryptographic algorithms. A Cryptol implementation of an algorithm resembles its mathematical specification more closely than an implementation in a general purpose language. For more, see <http://www.cryptol.net/>.

category:             Language
abi:                  0a8f079368a339666b08c3fa1830602e
exposed:              True
exposed-modules:
    Cryptol.AES Cryptol.Backend Cryptol.Backend.Arch
    Cryptol.Backend.Concrete Cryptol.Backend.FFI
    Cryptol.Backend.FFI.Error Cryptol.Backend.FloatHelpers
    Cryptol.Backend.Monad Cryptol.Backend.SBV Cryptol.Backend.SeqMap
    Cryptol.Backend.What4 Cryptol.Backend.WordValue Cryptol.Eval
    Cryptol.Eval.Concrete Cryptol.Eval.Env Cryptol.Eval.FFI
    Cryptol.Eval.FFI.GenHeader Cryptol.Eval.Generic Cryptol.Eval.Prims
    Cryptol.Eval.Reference Cryptol.Eval.SBV Cryptol.Eval.Type
    Cryptol.Eval.Value Cryptol.Eval.What4 Cryptol.F2
    Cryptol.IR.FreeVars Cryptol.IR.TraverseNames Cryptol.ModuleSystem
    Cryptol.ModuleSystem.Base Cryptol.ModuleSystem.Binds
    Cryptol.ModuleSystem.Env Cryptol.ModuleSystem.Exports
    Cryptol.ModuleSystem.Fingerprint Cryptol.ModuleSystem.Interface
    Cryptol.ModuleSystem.Monad Cryptol.ModuleSystem.Name
    Cryptol.ModuleSystem.Names Cryptol.ModuleSystem.NamingEnv
    Cryptol.ModuleSystem.NamingEnv.Types Cryptol.ModuleSystem.Renamer
    Cryptol.ModuleSystem.Renamer.Error
    Cryptol.ModuleSystem.Renamer.ImplicitImports
    Cryptol.ModuleSystem.Renamer.Imports
    Cryptol.ModuleSystem.Renamer.Monad Cryptol.Parser
    Cryptol.Parser.AST Cryptol.Parser.ExpandPropGuards
    Cryptol.Parser.Layout Cryptol.Parser.Lexer Cryptol.Parser.Name
    Cryptol.Parser.Names Cryptol.Parser.NoInclude Cryptol.Parser.NoPat
    Cryptol.Parser.Position Cryptol.Parser.Selector
    Cryptol.Parser.Token Cryptol.Parser.Unlit Cryptol.Parser.Utils
    Cryptol.PrimeEC Cryptol.REPL.Browse Cryptol.REPL.Command
    Cryptol.REPL.Help Cryptol.REPL.Monad Cryptol.REPL.Trie Cryptol.SHA
    Cryptol.Symbolic Cryptol.Symbolic.SBV Cryptol.Symbolic.What4
    Cryptol.Testing.Random Cryptol.Transform.MonoValues
    Cryptol.Transform.Specialize Cryptol.TypeCheck
    Cryptol.TypeCheck.AST Cryptol.TypeCheck.Default
    Cryptol.TypeCheck.Error Cryptol.TypeCheck.FFI
    Cryptol.TypeCheck.FFI.Error Cryptol.TypeCheck.FFI.FFIType
    Cryptol.TypeCheck.Infer Cryptol.TypeCheck.InferTypes
    Cryptol.TypeCheck.Instantiate Cryptol.TypeCheck.Interface
    Cryptol.TypeCheck.Kind Cryptol.TypeCheck.Module
    Cryptol.TypeCheck.ModuleBacktickInstance
    Cryptol.TypeCheck.ModuleInstance Cryptol.TypeCheck.Monad
    Cryptol.TypeCheck.PP Cryptol.TypeCheck.Parseable
    Cryptol.TypeCheck.Sanity Cryptol.TypeCheck.SimpType
    Cryptol.TypeCheck.SimpleSolver Cryptol.TypeCheck.Solve
    Cryptol.TypeCheck.Solver.Class Cryptol.TypeCheck.Solver.Improve
    Cryptol.TypeCheck.Solver.InfNat Cryptol.TypeCheck.Solver.Numeric
    Cryptol.TypeCheck.Solver.Numeric.Fin
    Cryptol.TypeCheck.Solver.Numeric.Interval
    Cryptol.TypeCheck.Solver.SMT Cryptol.TypeCheck.Solver.Selector
    Cryptol.TypeCheck.Solver.Types Cryptol.TypeCheck.Solver.Utils
    Cryptol.TypeCheck.Subst Cryptol.TypeCheck.TCon
    Cryptol.TypeCheck.Type Cryptol.TypeCheck.TypeMap
    Cryptol.TypeCheck.TypeOf Cryptol.TypeCheck.TypePat
    Cryptol.TypeCheck.Unify Cryptol.Utils.Benchmark Cryptol.Utils.Debug
    Cryptol.Utils.Fixity Cryptol.Utils.Ident Cryptol.Utils.Logger
    Cryptol.Utils.Misc Cryptol.Utils.PP Cryptol.Utils.Panic
    Cryptol.Utils.Patterns Cryptol.Utils.RecordMap Cryptol.Utils.Types
    Cryptol.Version

hidden-modules:
    Cryptol.Parser.LexerUtils Cryptol.Parser.ParserUtils
    Cryptol.Prelude GHC.Num.Compat Paths_cryptol GitRev

import-dirs:          /usr/lib/ghc-9.4.8/site-local/cryptol-3.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cryptol-3.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cryptol-3.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/cryptol
hs-libraries:         HScryptol-3.1.0-6QdI0iSLpzbGJ4Eq4O9Qmf
depends:
    GraphSCC-1.0.4-BvH3gdGqztj6roihacPJAg
    MemoTrie-0.6.11-IybHkrILA4v3lT6X5qkKe3
    arithmoi-0.13.1.0-2yCWgraHfsbDYNuPiMSPzt array-0.5.4.0
    async-2.2.5-EzkSbX3ltwt4GggFt3V8Jv base-4.17.2.1
    base-compat-0.12.3-H9qTMlLoDHsHlMi1O3x7Rp
    bv-sized-1.0.6-3WmQmRHjuaMHVVo1pnVATy bytestring-0.11.5.3
    containers-0.6.7
    criterion-measurement-0.2.2.0-15HWa2eqvr57k3czm7HCtA
    cryptohash-sha1-0.11.101.0-HVVDCm7UDkAKgyLwm38F3m deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2 ghc-bignum-1.3
    ghc-prim-0.9.1 gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    hgmp-0.1.2.1-IhjThxpO4inKeLgzlvbGZC
    language-c99-0.2.0-I2YO1ITQKgi7h1b2QKXgRh
    language-c99-simple-0.3.0-LtsnH0LVnu56Mhd4fxlDo
    libBF-0.6.6-F2rc146yr3s6BdbrTNS5Jq
    libffi-0.2.1-DPsLfzr2gvt1V2FBULxP58
    monad-control-1.0.3.1-KnIKWlFgHOx1OkVVpwK7n0
    monadLib-3.10.3-9u69WCWPr5d93B1By2kxXa mtl-2.2.2
    panic-0.4.0.1-9Mho20XcACeAG1iUCpMASP
    parameterized-utils-2.1.10.0-LSClsJTWFLc2I3zcnJyeie pretty-1.1.3.6
    pretty-show-1.10-Ey6CADemQl3EFi7OIHqHDp
    prettyprinter-1.7.1-7FxwfHkFGwc7hJXAWpcKVm process-1.6.18.0
    sbv-10.2-CCOYSqBozEn1ZM1J6uF8Rh
    simple-smt-0.9.8-GxJMYuz27wdJmfDJ6DG7cL stm-2.5.1.0
    strict-0.5-7FvLOsLrVGMDR1V3QvcHdv text-2.0.2
    tf-random-0.5-E1cnJEeqCMnBSASfE8cEVz time-1.12.2
    transformers-base-0.4.6-IaAP0yksPm7DVsk26sdOdi unix-2.7.3
    vector-0.13.2.0-7SxE3dSPVCM2VxyJW4x4GJ
    what4-1.5.1-1AuwXcch6mD4iLJQA1YPko

haddock-interfaces:   /usr/share/doc/cryptol/html/cryptol.haddock
haddock-html:         /usr/share/doc/cryptol/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

