"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BrokenCircuitError = void 0;
class BrokenCircuitError extends Error {
    /**
     * Exception thrown from {@link CircuitBreakerPolicy.execute} when the
     * circuit breaker is open.
     */
    constructor(message = 'Execution prevented because the circuit breaker is open') {
        super(message);
        this.isBrokenCircuitError = true;
    }
}
exports.BrokenCircuitError = BrokenCircuitError;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/6f17636121051a53c88d3e605c491d22af2ba755/node_modules/cockatiel/dist/errors/BrokenCircuitError.js.map