/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.KeepClassSpecificationVisitorFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AllBootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.AllExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.AllInnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.DebugAttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.attribute.visitor.StackSizeComputer;
import proguard.classfile.constant.visitor.AllBootstrapMethodArgumentVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.constant.visitor.BootstrapMethodHandleTraveler;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.constant.visitor.MethodrefTraveler;
import proguard.classfile.editor.AccessFixer;
import proguard.classfile.editor.ClassReferenceFixer;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InnerClassesAccessFixer;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.editor.MethodInvocationFixer;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionConstantVisitor;
import proguard.classfile.instruction.visitor.InstructionCounter;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllClassVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.BottomClassFilter;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.DotClassClassVisitor;
import proguard.classfile.visitor.DynamicReturnedClassVisitor;
import proguard.classfile.visitor.ExceptionCounter;
import proguard.classfile.visitor.ExceptionHandlerConstantVisitor;
import proguard.classfile.visitor.FunctionalInterfaceFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberAccessFlagCleaner;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberDescriptorReferencedClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiConstantVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.ParallelAllClassVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.ReferencedMemberVisitor;
import proguard.evaluation.AssumeClassSpecificationVisitorFactory;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.DetailedArrayValueFactory;
import proguard.evaluation.value.IdentifiedValueFactory;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.RangeValueFactory;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.optimize.BootstrapMethodArgumentShrinker;
import proguard.optimize.ConstantMemberFilter;
import proguard.optimize.ConstantParameterFilter;
import proguard.optimize.DuplicateInitializerFixer;
import proguard.optimize.DuplicateInitializerInvocationFixer;
import proguard.optimize.KeepMarker;
import proguard.optimize.KeptClassFilter;
import proguard.optimize.KeptMemberFilter;
import proguard.optimize.MethodDescriptorShrinker;
import proguard.optimize.MethodStaticizer;
import proguard.optimize.OptimizationInfoClassFilter;
import proguard.optimize.OptimizationInfoMemberFilter;
import proguard.optimize.ParameterShrinker;
import proguard.optimize.TailRecursionSimplifier;
import proguard.optimize.WriteOnlyFieldFilter;
import proguard.optimize.evaluation.EvaluationShrinker;
import proguard.optimize.evaluation.EvaluationSimplifier;
import proguard.optimize.evaluation.InstructionUsageMarker;
import proguard.optimize.evaluation.LoadingInvocationUnit;
import proguard.optimize.evaluation.ParameterTracingInvocationUnit;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.ReferenceTracingValueFactory;
import proguard.optimize.evaluation.SimpleEnumArrayPropagator;
import proguard.optimize.evaluation.SimpleEnumClassChecker;
import proguard.optimize.evaluation.SimpleEnumClassSimplifier;
import proguard.optimize.evaluation.SimpleEnumDescriptorSimplifier;
import proguard.optimize.evaluation.SimpleEnumUseChecker;
import proguard.optimize.evaluation.SimpleEnumUseSimplifier;
import proguard.optimize.evaluation.StoringInvocationUnit;
import proguard.optimize.evaluation.VariableOptimizer;
import proguard.optimize.info.AccessMethodMarker;
import proguard.optimize.info.BackwardBranchMarker;
import proguard.optimize.info.CatchExceptionMarker;
import proguard.optimize.info.CaughtClassMarker;
import proguard.optimize.info.DotClassMarker;
import proguard.optimize.info.DynamicInvocationMarker;
import proguard.optimize.info.EscapingClassFilter;
import proguard.optimize.info.EscapingClassMarker;
import proguard.optimize.info.FinalFieldAssignmentMarker;
import proguard.optimize.info.InstanceofClassMarker;
import proguard.optimize.info.InstantiationClassMarker;
import proguard.optimize.info.MethodInvocationMarker;
import proguard.optimize.info.MutableBoolean;
import proguard.optimize.info.NoEscapingParametersMethodMarker;
import proguard.optimize.info.NoExternalReturnValuesMethodMarker;
import proguard.optimize.info.NoExternalSideEffectMethodMarker;
import proguard.optimize.info.NoSideEffectClassMarker;
import proguard.optimize.info.NoSideEffectMethodMarker;
import proguard.optimize.info.NonEmptyStackReturnMarker;
import proguard.optimize.info.NonPrivateMemberMarker;
import proguard.optimize.info.OptimizationCodeAttributeFilter;
import proguard.optimize.info.PackageVisibleMemberContainingClassMarker;
import proguard.optimize.info.PackageVisibleMemberInvokingClassMarker;
import proguard.optimize.info.ParameterEscapeMarker;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.ProgramClassOptimizationInfoSetter;
import proguard.optimize.info.ProgramMemberOptimizationInfoSetter;
import proguard.optimize.info.ReadWriteFieldMarker;
import proguard.optimize.info.RepeatedClassPoolVisitor;
import proguard.optimize.info.SideEffectMethodMarker;
import proguard.optimize.info.SimpleEnumFilter;
import proguard.optimize.info.SimpleEnumMarker;
import proguard.optimize.info.SuperInvocationMarker;
import proguard.optimize.info.SynchronizedBlockMethodMarker;
import proguard.optimize.info.UnusedParameterMethodFilter;
import proguard.optimize.info.UnusedParameterOptimizationInfoUpdater;
import proguard.optimize.info.WrapperClassMarker;
import proguard.optimize.peephole.BranchTargetFinder;
import proguard.optimize.peephole.ClassFinalizer;
import proguard.optimize.peephole.GotoCommonCodeReplacer;
import proguard.optimize.peephole.GotoGotoReplacer;
import proguard.optimize.peephole.GotoReturnReplacer;
import proguard.optimize.peephole.HorizontalClassMerger;
import proguard.optimize.peephole.InstructionSequenceConstants;
import proguard.optimize.peephole.InstructionSequencesReplacer;
import proguard.optimize.peephole.MemberPrivatizer;
import proguard.optimize.peephole.MethodFinalizer;
import proguard.optimize.peephole.MethodInliner;
import proguard.optimize.peephole.PeepholeOptimizer;
import proguard.optimize.peephole.RetargetedClassFilter;
import proguard.optimize.peephole.RetargetedInnerClassAttributeRemover;
import proguard.optimize.peephole.TargetClassChanger;
import proguard.optimize.peephole.UnreachableCodeRemover;
import proguard.optimize.peephole.UnreachableExceptionRemover;
import proguard.optimize.peephole.VariableShrinker;
import proguard.optimize.peephole.VerticalClassMerger;
import proguard.optimize.peephole.WrapperClassMerger;
import proguard.optimize.peephole.WrapperClassUseSimplifier;
import proguard.util.CollectionMatcher;
import proguard.util.ConstantMatcher;
import proguard.util.ListParser;
import proguard.util.MultiValueMap;
import proguard.util.NameParser;
import proguard.util.NotMatcher;

public class Optimizer {
    public static final boolean DETAILS = System.getProperty("optd") != null;
    public static final String LIBRARY_GSON = "library/gson";
    private static final String CLASS_MARKING_FINAL = "class/marking/final";
    private static final String CLASS_UNBOXING_ENUM = "class/unboxing/enum";
    private static final String CLASS_MERGING_VERTICAL = "class/merging/vertical";
    private static final String CLASS_MERGING_HORIZONTAL = "class/merging/horizontal";
    private static final String CLASS_MERGING_WRAPPER = "class/merging/wrapper";
    private static final String FIELD_REMOVAL_WRITEONLY = "field/removal/writeonly";
    private static final String FIELD_MARKING_PRIVATE = "field/marking/private";
    private static final String FIELD_PROPAGATION_VALUE = "field/propagation/value";
    private static final String METHOD_MARKING_PRIVATE = "method/marking/private";
    private static final String METHOD_MARKING_STATIC = "method/marking/static";
    private static final String METHOD_MARKING_FINAL = "method/marking/final";
    private static final String METHOD_MARKING_SYNCHRONIZED = "method/marking/synchronized";
    private static final String METHOD_REMOVAL_PARAMETER = "method/removal/parameter";
    private static final String METHOD_PROPAGATION_PARAMETER = "method/propagation/parameter";
    private static final String METHOD_PROPAGATION_RETURNVALUE = "method/propagation/returnvalue";
    private static final String METHOD_INLINING_SHORT = "method/inlining/short";
    private static final String METHOD_INLINING_UNIQUE = "method/inlining/unique";
    private static final String METHOD_INLINING_TAILRECURSION = "method/inlining/tailrecursion";
    private static final String CODE_MERGING = "code/merging";
    private static final String CODE_SIMPLIFICATION_VARIABLE = "code/simplification/variable";
    private static final String CODE_SIMPLIFICATION_ARITHMETIC = "code/simplification/arithmetic";
    private static final String CODE_SIMPLIFICATION_CAST = "code/simplification/cast";
    private static final String CODE_SIMPLIFICATION_FIELD = "code/simplification/field";
    private static final String CODE_SIMPLIFICATION_BRANCH = "code/simplification/branch";
    private static final String CODE_SIMPLIFICATION_OBJECT = "code/simplification/object";
    private static final String CODE_SIMPLIFICATION_STRING = "code/simplification/string";
    private static final String CODE_SIMPLIFICATION_MATH = "code/simplification/math";
    private static final String CODE_SIMPLIFICATION_ADVANCED = "code/simplification/advanced";
    private static final String CODE_REMOVAL_ADVANCED = "code/removal/advanced";
    private static final String CODE_REMOVAL_SIMPLE = "code/removal/simple";
    private static final String CODE_REMOVAL_VARIABLE = "code/removal/variable";
    private static final String CODE_REMOVAL_EXCEPTION = "code/removal/exception";
    private static final String CODE_ALLOCATION_VARIABLE = "code/allocation/variable";
    public static final String[] OPTIMIZATION_NAMES = new String[]{"library/gson", "class/marking/final", "class/merging/vertical", "class/merging/horizontal", "field/removal/writeonly", "field/marking/private", "field/propagation/value", "method/marking/private", "method/marking/static", "method/marking/final", "method/marking/synchronized", "method/removal/parameter", "method/propagation/parameter", "method/propagation/returnvalue", "method/inlining/short", "method/inlining/unique", "method/inlining/tailrecursion", "code/merging", "code/simplification/variable", "code/simplification/arithmetic", "code/simplification/cast", "code/simplification/field", "code/simplification/branch", "code/simplification/string", "code/simplification/math", "code/simplification/advanced", "code/removal/advanced", "code/removal/simple", "code/removal/variable", "code/removal/exception", "code/allocation/variable"};
    private final Configuration configuration;
    private final boolean libraryGson;
    private final boolean classMarkingFinal;
    private final boolean classUnboxingEnum;
    private final boolean classMergingVertical;
    private final boolean classMergingHorizontal;
    private final boolean classMergingWrapper;
    private final boolean fieldRemovalWriteonly;
    private final boolean fieldMarkingPrivate;
    private final boolean fieldPropagationValue;
    private final boolean methodMarkingPrivate;
    private final boolean methodMarkingStatic;
    private final boolean methodMarkingFinal;
    private final boolean methodMarkingSynchronized;
    private final boolean methodRemovalParameter;
    private final boolean methodPropagationParameter;
    private final boolean methodPropagationReturnvalue;
    private final boolean methodInliningShort;
    private final boolean methodInliningUnique;
    private final boolean methodInliningTailrecursion;
    private final boolean codeMerging;
    private final boolean codeSimplificationVariable;
    private final boolean codeSimplificationArithmetic;
    private final boolean codeSimplificationCast;
    private final boolean codeSimplificationField;
    private final boolean codeSimplificationBranch;
    private final boolean codeSimplificationObject;
    private final boolean codeSimplificationString;
    private final boolean codeSimplificationMath;
    private final boolean codeSimplificationPeephole;
    private boolean codeSimplificationAdvanced;
    private boolean codeRemovalAdvanced;
    private boolean codeRemovalSimple;
    private final boolean codeRemovalVariable;
    private boolean codeRemovalException;
    private final boolean codeAllocationVariable;

    public Optimizer(Configuration configuration) {
        this.configuration = configuration;
        ConstantMatcher filter = configuration.optimizations != null ? new ListParser(new NameParser()).parse(configuration.optimizations) : new ConstantMatcher(true);
        this.libraryGson = filter.matches(LIBRARY_GSON);
        this.classMarkingFinal = filter.matches(CLASS_MARKING_FINAL);
        this.classUnboxingEnum = filter.matches(CLASS_UNBOXING_ENUM);
        this.classMergingVertical = filter.matches(CLASS_MERGING_VERTICAL);
        this.classMergingHorizontal = filter.matches(CLASS_MERGING_HORIZONTAL);
        this.classMergingWrapper = filter.matches(CLASS_MERGING_WRAPPER);
        this.fieldRemovalWriteonly = filter.matches(FIELD_REMOVAL_WRITEONLY);
        this.fieldMarkingPrivate = filter.matches(FIELD_MARKING_PRIVATE);
        this.fieldPropagationValue = filter.matches(FIELD_PROPAGATION_VALUE);
        this.methodMarkingPrivate = filter.matches(METHOD_MARKING_PRIVATE);
        this.methodMarkingStatic = filter.matches(METHOD_MARKING_STATIC);
        this.methodMarkingFinal = filter.matches(METHOD_MARKING_FINAL);
        this.methodMarkingSynchronized = filter.matches(METHOD_MARKING_SYNCHRONIZED);
        this.methodRemovalParameter = filter.matches(METHOD_REMOVAL_PARAMETER);
        this.methodPropagationParameter = filter.matches(METHOD_PROPAGATION_PARAMETER);
        this.methodPropagationReturnvalue = filter.matches(METHOD_PROPAGATION_RETURNVALUE);
        this.methodInliningShort = filter.matches(METHOD_INLINING_SHORT);
        this.methodInliningUnique = filter.matches(METHOD_INLINING_UNIQUE);
        this.methodInliningTailrecursion = filter.matches(METHOD_INLINING_TAILRECURSION);
        this.codeMerging = filter.matches(CODE_MERGING);
        this.codeSimplificationVariable = filter.matches(CODE_SIMPLIFICATION_VARIABLE);
        this.codeSimplificationArithmetic = filter.matches(CODE_SIMPLIFICATION_ARITHMETIC);
        this.codeSimplificationCast = filter.matches(CODE_SIMPLIFICATION_CAST);
        this.codeSimplificationField = filter.matches(CODE_SIMPLIFICATION_FIELD);
        this.codeSimplificationBranch = filter.matches(CODE_SIMPLIFICATION_BRANCH);
        this.codeSimplificationObject = filter.matches(CODE_SIMPLIFICATION_OBJECT);
        this.codeSimplificationString = filter.matches(CODE_SIMPLIFICATION_STRING);
        this.codeSimplificationMath = filter.matches(CODE_SIMPLIFICATION_MATH);
        this.codeSimplificationAdvanced = filter.matches(CODE_SIMPLIFICATION_ADVANCED);
        this.codeRemovalAdvanced = filter.matches(CODE_REMOVAL_ADVANCED);
        this.codeRemovalSimple = filter.matches(CODE_REMOVAL_SIMPLE);
        this.codeRemovalVariable = filter.matches(CODE_REMOVAL_VARIABLE);
        this.codeRemovalException = filter.matches(CODE_REMOVAL_EXCEPTION);
        this.codeAllocationVariable = filter.matches(CODE_ALLOCATION_VARIABLE);
        this.codeSimplificationAdvanced = this.codeSimplificationAdvanced || this.fieldPropagationValue || this.methodPropagationParameter || this.methodPropagationReturnvalue;
        this.codeRemovalAdvanced = this.codeRemovalAdvanced || this.fieldRemovalWriteonly || this.methodMarkingStatic || this.methodRemovalParameter;
        this.codeRemovalSimple = this.codeRemovalSimple || this.codeSimplificationBranch;
        this.codeRemovalException = this.codeRemovalException || this.codeRemovalAdvanced || this.codeRemovalSimple;
        this.codeSimplificationPeephole = this.codeSimplificationVariable || this.codeSimplificationArithmetic || this.codeSimplificationCast || this.codeSimplificationField || this.codeSimplificationBranch || this.codeSimplificationObject || this.codeSimplificationString || this.codeSimplificationMath;
    }

    public boolean execute(final ClassPool programClassPool, final ClassPool libraryClassPool, MultiValueMap<String, String> injectedClassNameMap) throws IOException {
        ClassPoolVisitor classPoolVisitor;
        ClassPoolVisitor classPoolVisitor2;
        SimplifiedVisitor noSideEffectMethodMarker;
        NoSideEffectClassMarker noSideEffectClassMarker;
        if (this.configuration.keep == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the optimization step.");
        }
        ClassCounter classMarkingFinalCounter = new ClassCounter();
        ClassCounter classUnboxingEnumCounter = new ClassCounter();
        ClassCounter classMergingVerticalCounter = new ClassCounter();
        ClassCounter classMergingHorizontalCounter = new ClassCounter();
        ClassCounter classMergingWrapperCounter = new ClassCounter();
        MemberCounter fieldRemovalWriteonlyCounter = new MemberCounter();
        MemberCounter fieldMarkingPrivateCounter = new MemberCounter();
        MemberCounter fieldPropagationValueCounter = new MemberCounter();
        MemberCounter methodMarkingPrivateCounter = new MemberCounter();
        MemberCounter methodMarkingStaticCounter = new MemberCounter();
        MemberCounter methodMarkingFinalCounter = new MemberCounter();
        MemberCounter methodMarkingSynchronizedCounter = new MemberCounter();
        MemberCounter methodRemovalParameterCounter1 = new MemberCounter();
        MemberCounter methodRemovalParameterCounter2 = new MemberCounter();
        MemberCounter methodPropagationParameterCounter = new MemberCounter();
        MemberCounter methodPropagationReturnvalueCounter = new MemberCounter();
        InstructionCounter methodInliningShortCounter = new InstructionCounter();
        InstructionCounter methodInliningUniqueCounter = new InstructionCounter();
        InstructionCounter methodInliningTailrecursionCounter = new InstructionCounter();
        InstructionCounter codeMergingCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationVariableCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationArithmeticCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationCastCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationFieldCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationBranchCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationObjectCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationStringCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationMathCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationAndroidMathCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationAdvancedCounter = new InstructionCounter();
        final InstructionCounter deletedCounter = new InstructionCounter();
        final InstructionCounter addedCounter = new InstructionCounter();
        MemberCounter codeRemovalVariableCounter = new MemberCounter();
        ExceptionCounter codeRemovalExceptionCounter = new ExceptionCounter();
        final MemberCounter codeAllocationVariableCounter = new MemberCounter();
        MemberCounter initializerFixCounter1 = new MemberCounter();
        MemberCounter initializerFixCounter2 = new MemberCounter();
        programClassPool.classesAccept(new ClassCleaner());
        libraryClassPool.classesAccept(new ClassCleaner());
        programClassPool.classesAccept(new BottomClassFilter(new MethodLinker()));
        libraryClassPool.classesAccept(new BottomClassFilter(new MethodLinker()));
        KeepMarker keepMarker = new KeepMarker();
        ClassPoolVisitor classPoolvisitor = new KeepClassSpecificationVisitorFactory(false, true, false).createClassPoolVisitor(this.configuration.keep, (ClassVisitor)keepMarker, (MemberVisitor)keepMarker, (MemberVisitor)keepMarker, (AttributeVisitor)keepMarker);
        programClassPool.accept(classPoolvisitor);
        libraryClassPool.accept(classPoolvisitor);
        libraryClassPool.classesAccept(keepMarker);
        libraryClassPool.classesAccept(new AllMemberVisitor(keepMarker));
        programClassPool.classesAccept(new ClassAccessFilter(0, 16384, new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DotClassClassVisitor(keepMarker))))));
        programClassPool.classesAccept(new AllConstantVisitor(new ConstantTagFilter(8, (ConstantVisitor)new ReferencedClassVisitor(keepMarker))));
        programClassPool.classesAccept(new AllConstantVisitor(new ConstantTagFilter(8, (ConstantVisitor)new ReferencedMemberVisitor(keepMarker))));
        programClassPool.classesAccept(new ClassVersionFilter(0x330000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AllBootstrapMethodInfoVisitor(new BootstrapMethodHandleTraveler(new MethodrefTraveler(new ReferencedMemberVisitor(keepMarker))))))));
        programClassPool.classesAccept(new ClassVersionFilter(0x330000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AllBootstrapMethodInfoVisitor(new AllBootstrapMethodArgumentVisitor(new MultiConstantVisitor(new ConstantTagFilter(7, (ConstantVisitor)new ReferencedClassVisitor(new FunctionalInterfaceFilter(new ClassHierarchyTraveler(true, false, true, false, new MultiClassVisitor(keepMarker, new AllMethodVisitor(new MemberAccessFilter(1024, 0, keepMarker))))))), new MethodrefTraveler(new ReferencedMemberVisitor(keepMarker)))))))));
        programClassPool.classesAccept(new ClassVersionFilter(0x330000, new AllConstantVisitor(new DynamicReturnedClassVisitor(new FunctionalInterfaceFilter(new ClassHierarchyTraveler(true, false, true, false, new MultiClassVisitor(keepMarker, new AllMethodVisitor(new MemberAccessFilter(1024, 0, keepMarker)))))))));
        programClassPool.classesAccept(new ProgramClassOptimizationInfoSetter());
        programClassPool.classesAccept(new AllMemberVisitor(new ProgramMemberOptimizationInfoSetter()));
        if (this.configuration.assumeNoSideEffects != null) {
            noSideEffectClassMarker = new NoSideEffectClassMarker();
            noSideEffectMethodMarker = new NoSideEffectMethodMarker();
            classPoolVisitor2 = new ClassSpecificationVisitorFactory().createClassPoolVisitor(this.configuration.assumeNoSideEffects, noSideEffectClassMarker, (MemberVisitor)((Object)noSideEffectMethodMarker));
            programClassPool.accept(classPoolVisitor2);
            libraryClassPool.accept(classPoolVisitor2);
        }
        if (this.configuration.assumeNoExternalSideEffects != null) {
            noSideEffectClassMarker = new NoSideEffectClassMarker();
            noSideEffectMethodMarker = new NoExternalSideEffectMethodMarker();
            classPoolVisitor2 = new ClassSpecificationVisitorFactory().createClassPoolVisitor(this.configuration.assumeNoExternalSideEffects, noSideEffectClassMarker, (MemberVisitor)((Object)noSideEffectMethodMarker));
            programClassPool.accept(classPoolVisitor2);
            libraryClassPool.accept(classPoolVisitor2);
        }
        if (this.configuration.assumeNoEscapingParameters != null) {
            NoEscapingParametersMethodMarker noEscapingParametersMethodMarker = new NoEscapingParametersMethodMarker();
            classPoolVisitor = new ClassSpecificationVisitorFactory().createClassPoolVisitor(this.configuration.assumeNoEscapingParameters, null, noEscapingParametersMethodMarker);
            programClassPool.accept(classPoolVisitor);
            libraryClassPool.accept(classPoolVisitor);
        }
        if (this.configuration.assumeNoExternalReturnValues != null) {
            NoExternalReturnValuesMethodMarker noExternalReturnValuesMethodMarker = new NoExternalReturnValuesMethodMarker();
            classPoolVisitor = new ClassSpecificationVisitorFactory().createClassPoolVisitor(this.configuration.assumeNoExternalReturnValues, null, noExternalReturnValuesMethodMarker);
            programClassPool.accept(classPoolVisitor);
            libraryClassPool.accept(classPoolVisitor);
        }
        if (this.classMarkingFinal) {
            programClassPool.classesAccept(new ClassFinalizer(classMarkingFinalCounter));
        }
        if (this.methodMarkingFinal) {
            programClassPool.classesAccept(new ClassAccessFilter(0, 512, new AllMethodVisitor(new MethodFinalizer(methodMarkingFinalCounter))));
        }
        MutableBoolean mutableBoolean = new MutableBoolean();
        if (this.fieldRemovalWriteonly) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new ReadWriteFieldMarker(mutableBoolean)))));
        } else {
            programClassPool.classesAccept(new AllFieldVisitor(new ReadWriteFieldMarker(mutableBoolean)));
        }
        programClassPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new MultiMemberVisitor(new SideEffectMethodMarker(mutableBoolean), new ParameterEscapeMarker(mutableBoolean)))));
        final MutableBoolean repeatTrigger = new MutableBoolean();
        programClassPool.accept(new RepeatedClassPoolVisitor(repeatTrigger, new TimedClassPoolVisitor("Marking fields, methods, and parameters", new ParallelAllClassVisitor(new ParallelAllClassVisitor.ClassVisitorFactory(){

            @Override
            public ClassVisitor createClassVisitor() {
                ReferenceTracingValueFactory referenceTracingValueFactory1 = new ReferenceTracingValueFactory(new TypedReferenceValueFactory());
                PartialEvaluator partialEvaluator = new PartialEvaluator(referenceTracingValueFactory1, new ParameterTracingInvocationUnit(new BasicInvocationUnit(referenceTracingValueFactory1)), false, referenceTracingValueFactory1);
                InstructionUsageMarker instructionUsageMarker = new InstructionUsageMarker(partialEvaluator, false);
                SideEffectMethodMarker sideEffectMethodMarker = new SideEffectMethodMarker(repeatTrigger);
                ParameterEscapeMarker parameterEscapeMarker = new ParameterEscapeMarker(repeatTrigger, partialEvaluator, false);
                return new AllMethodVisitor(new OptimizationInfoMemberFilter(new AllAttributeVisitor(new DebugAttributeVisitor("Marking fields, methods, and parameters", new MultiAttributeVisitor(partialEvaluator, parameterEscapeMarker, instructionUsageMarker, new AllInstructionVisitor(instructionUsageMarker.necessaryInstructionFilter(new MultiInstructionVisitor(sideEffectMethodMarker, parameterEscapeMarker))))))));
            }
        }))));
        if (this.methodMarkingSynchronized) {
            programClassPool.classesAccept(new EscapingClassFilter(new ClassHierarchyTraveler(false, true, true, false, new EscapingClassMarker())));
            ParallelAllClassVisitor.ClassVisitorFactory markingEscapingClassVisitor = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    return new AllMethodVisitor(new AllAttributeVisitor(new EscapingClassMarker()));
                }
            };
            programClassPool.accept(new TimedClassPoolVisitor("Marking escaping classes", new ParallelAllClassVisitor(markingEscapingClassVisitor)));
            programClassPool.classesAccept(new EscapingClassFilter(null, new AllMethodVisitor(new OptimizationInfoMemberFilter(new MemberAccessFilter(32, 8, new MultiMemberVisitor(new MemberAccessFlagCleaner(32), methodMarkingSynchronizedCounter))))));
        }
        if (this.fieldRemovalWriteonly) {
            programClassPool.classesAccept(new AllFieldVisitor(new WriteOnlyFieldFilter(fieldRemovalWriteonlyCounter)));
        }
        if (this.classUnboxingEnum) {
            ClassCounter counter = new ClassCounter();
            programClassPool.classesAccept(new ClassAccessFilter(16400, 0, new OptimizationInfoClassFilter(new SimpleEnumClassChecker())));
            programClassPool.classesAccept(new SimpleEnumFilter(counter));
            if (counter.getCount() > 0) {
                programClassPool.classesAccept(new SimpleEnumUseChecker());
                programClassPool.classesAccept(new SimpleEnumFilter(null, new AllMemberVisitor(new KeptMemberFilter(new MemberDescriptorReferencedClassVisitor(new OptimizationInfoClassFilter(new SimpleEnumMarker(false)))))));
                programClassPool.classesAccept(new SimpleEnumFilter(classUnboxingEnumCounter));
                if (classUnboxingEnumCounter.getCount() > 0) {
                    programClassPool.accept(new TimedClassPoolVisitor("Simplify use of simple enums", new AllMethodVisitor(new AllAttributeVisitor(new SimpleEnumUseSimplifier()))));
                    programClassPool.classesAccept(new SimpleEnumFilter(new SimpleEnumClassSimplifier()));
                    programClassPool.classesAccept(new SimpleEnumDescriptorSimplifier());
                    programClassPool.classesAccept(new MemberReferenceFixer(this.configuration.android));
                }
            }
        }
        ParallelAllClassVisitor.ClassVisitorFactory markingUsedParametersClassVisitor = new ParallelAllClassVisitor.ClassVisitorFactory(){

            @Override
            public ClassVisitor createClassVisitor() {
                return new AllMethodVisitor(new OptimizationInfoMemberFilter(new ParameterUsageMarker(!Optimizer.this.methodMarkingStatic, !Optimizer.this.methodRemovalParameter)));
            }
        };
        programClassPool.accept(new TimedClassPoolVisitor("Marking used parameters", new ParallelAllClassVisitor(markingUsedParametersClassVisitor)));
        programClassPool.accept(new TimedClassPoolVisitor("Marking used parameters in kept code attributes", new AllClassVisitor(new AllMethodVisitor(new OptimizationInfoMemberFilter(null, new AllAttributeVisitor(new OptimizationCodeAttributeFilter(null, new AllInstructionVisitor(new InstructionConstantVisitor(new ConstantTagFilter(new int[]{10, 11}, (ConstantVisitor)new ReferencedMemberVisitor(new OptimizationInfoMemberFilter(new ParameterUsageMarker(true, true, false)))))))))))));
        if (this.fieldPropagationValue || this.methodPropagationParameter || this.methodPropagationReturnvalue || this.classMergingWrapper) {
            RangeValueFactory valueFactory = new RangeValueFactory();
            DetailedArrayValueFactory detailedValueFactory = new DetailedArrayValueFactory();
            StoringInvocationUnit storingInvocationUnit = new StoringInvocationUnit(valueFactory, this.fieldPropagationValue, this.methodPropagationParameter || this.classMergingWrapper, this.methodPropagationReturnvalue);
            programClassPool.classesAccept(new ClassAccessFilter(4096, 0, new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Filling out fields, method parameters, and return values in synthetic classes", new PartialEvaluator(detailedValueFactory, storingInvocationUnit, false))))));
            ParallelAllClassVisitor.ClassVisitorFactory fillingOutValuesClassVisitor = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    ParticularValueFactory valueFactory = new ParticularValueFactory();
                    StoringInvocationUnit storingInvocationUnit = new StoringInvocationUnit(valueFactory, Optimizer.this.fieldPropagationValue, Optimizer.this.methodPropagationParameter || Optimizer.this.classMergingWrapper, Optimizer.this.methodPropagationReturnvalue);
                    return new ClassAccessFilter(0, 4096, new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Filling out fields, method parameters, and return values", new PartialEvaluator(valueFactory, storingInvocationUnit, false)))));
                }
            };
            programClassPool.accept(new TimedClassPoolVisitor("Filling out values in non-synthetic classes", new ParallelAllClassVisitor(fillingOutValuesClassVisitor)));
            if (this.configuration.assumeValues != null) {
                ClassPoolVisitor classPoolVisitor3 = new AssumeClassSpecificationVisitorFactory(valueFactory).createClassPoolVisitor(this.configuration.assumeValues, null, new MultiMemberVisitor());
                programClassPool.accept(classPoolVisitor3);
                libraryClassPool.accept(classPoolVisitor3);
            }
            if (this.fieldPropagationValue) {
                programClassPool.classesAccept(new AllFieldVisitor(new ConstantMemberFilter(fieldPropagationValueCounter)));
            }
            if (this.methodPropagationParameter) {
                programClassPool.classesAccept(new AllMethodVisitor(new ConstantParameterFilter(methodPropagationParameterCounter)));
            }
            if (this.methodPropagationReturnvalue) {
                programClassPool.classesAccept(new AllMethodVisitor(new ConstantMemberFilter(methodPropagationReturnvalueCounter)));
            }
            if (classUnboxingEnumCounter.getCount() > 0) {
                programClassPool.classesAccept(new SimpleEnumFilter(new SimpleEnumArrayPropagator()));
            }
            if (this.codeSimplificationAdvanced) {
                LoadingInvocationUnit loadingInvocationUnit = new LoadingInvocationUnit(valueFactory, this.fieldPropagationValue, this.methodPropagationParameter, this.methodPropagationReturnvalue);
                programClassPool.classesAccept(new ClassAccessFilter(4096, 0, new AllMethodVisitor(new AllAttributeVisitor(new PartialEvaluator(valueFactory, loadingInvocationUnit, false)))));
            }
        }
        if (this.codeSimplificationAdvanced) {
            ParallelAllClassVisitor.ClassVisitorFactory simplifyingCodeVisitor = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    IdentifiedValueFactory valueFactory = new IdentifiedValueFactory();
                    LoadingInvocationUnit loadingInvocationUnit = new LoadingInvocationUnit(valueFactory, Optimizer.this.fieldPropagationValue, Optimizer.this.methodPropagationParameter, Optimizer.this.methodPropagationReturnvalue);
                    return new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Simplifying code", new OptimizationCodeAttributeFilter(new EvaluationSimplifier(new PartialEvaluator(valueFactory, loadingInvocationUnit, false), codeSimplificationAdvancedCounter)))));
                }
            };
            programClassPool.accept(new TimedClassPoolVisitor("Simplifying code", new ParallelAllClassVisitor(simplifyingCodeVisitor)));
        }
        if (this.codeRemovalAdvanced) {
            ParallelAllClassVisitor.ClassVisitorFactory shrinkingCodeVisitor = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    IdentifiedValueFactory valueFactory = new IdentifiedValueFactory();
                    LoadingInvocationUnit loadingInvocationUnit = new LoadingInvocationUnit(valueFactory, Optimizer.this.fieldPropagationValue, Optimizer.this.methodPropagationParameter, Optimizer.this.methodPropagationReturnvalue);
                    ReferenceTracingValueFactory referenceTracingValueFactory = new ReferenceTracingValueFactory(valueFactory);
                    return new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Shrinking code", new OptimizationCodeAttributeFilter(new EvaluationShrinker(new InstructionUsageMarker(new PartialEvaluator(referenceTracingValueFactory, new ParameterTracingInvocationUnit(loadingInvocationUnit), !Optimizer.this.codeSimplificationAdvanced, referenceTracingValueFactory), true), true, (InstructionVisitor)deletedCounter, (InstructionVisitor)addedCounter)))));
                }
            };
            programClassPool.accept(new TimedClassPoolVisitor("Shrinking code", new ParallelAllClassVisitor(shrinkingCodeVisitor)));
        }
        if (this.methodRemovalParameter) {
            programClassPool.classesAccept(new AllMethodVisitor(new UnusedParameterMethodFilter(new OptimizationInfoMemberFilter(new MethodDescriptorShrinker(methodRemovalParameterCounter1)))));
        }
        if (this.methodMarkingStatic) {
            programClassPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new MemberAccessFilter(0, 8, new MethodStaticizer(methodMarkingStaticCounter)))));
        }
        if (methodRemovalParameterCounter1.getCount() > 0) {
            programClassPool.classesAccept(new MemberReferenceFixer(this.configuration.android));
            programClassPool.classesAccept(new AllAttributeVisitor(new AllBootstrapMethodInfoVisitor(new BootstrapMethodArgumentShrinker())));
        }
        if (methodRemovalParameterCounter1.getCount() > 0 || this.methodMarkingPrivate || methodMarkingStaticCounter.getCount() > 0) {
            programClassPool.classesAccept(new AllMethodVisitor(new UnusedParameterMethodFilter(new AllAttributeVisitor(new ParameterShrinker(methodRemovalParameterCounter2)))));
            programClassPool.classesAccept(new AllMethodVisitor(new UnusedParameterMethodFilter(new AllAttributeVisitor(new UnusedParameterOptimizationInfoUpdater()))));
        } else if (this.codeRemovalAdvanced) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new OptimizationCodeAttributeFilter(new StackSizeUpdater()))));
        }
        if (this.methodRemovalParameter && methodRemovalParameterCounter2.getCount() > 0) {
            programClassPool.classesAccept(new AllMethodVisitor(new DuplicateInitializerFixer(initializerFixCounter1)));
            if (initializerFixCounter1.getCount() > 0) {
                programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new DuplicateInitializerInvocationFixer(addedCounter))));
                programClassPool.classesAccept(new MemberReferenceFixer(this.configuration.android));
            }
        }
        StackSizeComputer stackSizeComputer = new StackSizeComputer();
        programClassPool.accept(new TimedClassPoolVisitor("Marking method and referenced class properties", new MultiClassVisitor(new OptimizationInfoClassFilter(new MultiClassVisitor(new PackageVisibleMemberContainingClassMarker(), new WrapperClassMarker(), new AllConstantVisitor(new PackageVisibleMemberInvokingClassMarker()))), new AllMethodVisitor(new OptimizationInfoMemberFilter(new AllAttributeVisitor(new DebugAttributeVisitor("Marking method properties", new MultiAttributeVisitor(stackSizeComputer, new CatchExceptionMarker(), new AllInstructionVisitor(new MultiInstructionVisitor(new SuperInvocationMarker(), new DynamicInvocationMarker(), new BackwardBranchMarker(), new AccessMethodMarker(), new SynchronizedBlockMethodMarker(), new FinalFieldAssignmentMarker(), new NonEmptyStackReturnMarker(stackSizeComputer)))))))), new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Marking referenced class properties", new MultiAttributeVisitor(new AllExceptionInfoVisitor(new ExceptionHandlerConstantVisitor(new ReferencedClassVisitor(new OptimizationInfoClassFilter(new CaughtClassMarker())))), new AllInstructionVisitor(new MultiInstructionVisitor(new InstantiationClassMarker(), new InstanceofClassMarker(), new DotClassMarker(), new MethodInvocationMarker())))))))));
        if (this.classMergingWrapper) {
            programClassPool.accept(new TimedClassPoolVisitor("Merging wrapper classes", new WrapperClassMerger(this.configuration.allowAccessModification, classMergingWrapperCounter)));
            if (classMergingWrapperCounter.getCount() > 0) {
                programClassPool.classesAccept(new RetargetedClassFilter(null, new AllMethodVisitor(new AllAttributeVisitor(new WrapperClassUseSimplifier()))));
            }
        }
        if (this.classMergingVertical) {
            programClassPool.accept(new TimedClassPoolVisitor("Merging classes vertically", new VerticalClassMerger(this.configuration.allowAccessModification, this.configuration.mergeInterfacesAggressively, classMergingVerticalCounter)));
        }
        if (this.classMergingHorizontal) {
            programClassPool.accept(new TimedClassPoolVisitor("Merging classes horizontally", new ClassNameFilter(new NotMatcher(new CollectionMatcher(injectedClassNameMap.getValues())), (ClassVisitor)new HorizontalClassMerger(this.configuration.allowAccessModification, this.configuration.mergeInterfacesAggressively, classMergingHorizontalCounter))));
        }
        if (classMergingVerticalCounter.getCount() > 0 || classMergingHorizontalCounter.getCount() > 0 || classMergingWrapperCounter.getCount() > 0) {
            programClassPool.classesAccept(new RetargetedInnerClassAttributeRemover());
            programClassPool.classesAccept(new RetargetedClassFilter(null, new TargetClassChanger()));
            programClassPool.classesAccept(new RetargetedClassFilter(null, new ClassReferenceFixer(true)));
            programClassPool.classesAccept(new RetargetedClassFilter(null, new MemberReferenceFixer(this.configuration.android)));
            if (this.configuration.allowAccessModification) {
                programClassPool.classesAccept(new AccessFixer());
            }
            programClassPool.classesAccept(new KeptClassFilter(null, new AllAttributeVisitor(new AllInnerClassesInfoVisitor(new InnerClassesAccessFixer()))));
            programClassPool.classesAccept(new AllMethodVisitor(new DuplicateInitializerFixer(initializerFixCounter2)));
            if (initializerFixCounter2.getCount() > 0) {
                programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new DuplicateInitializerInvocationFixer(addedCounter))));
                programClassPool.classesAccept(new MemberReferenceFixer(this.configuration.android));
            }
        }
        if (this.methodInliningUnique) {
            programClassPool.accept(new TimedClassPoolVisitor("Inlining single methods", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Inlining single methods", new OptimizationCodeAttributeFilter(new MethodInliner(this.configuration.microEdition, this.configuration.android, this.configuration.allowAccessModification, true, methodInliningUniqueCounter)))))));
        }
        if (this.methodInliningShort) {
            programClassPool.accept(new TimedClassPoolVisitor("Inlining short methods", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Inlining short methods", new OptimizationCodeAttributeFilter(new MethodInliner(this.configuration.microEdition, this.configuration.android, this.configuration.allowAccessModification, false, methodInliningShortCounter)))))));
        }
        if (this.methodInliningTailrecursion) {
            programClassPool.accept(new TimedClassPoolVisitor("Simplifying tail recursion", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Simplifying tail recursion", new OptimizationCodeAttributeFilter(new TailRecursionSimplifier(methodInliningTailrecursionCounter)))))));
        }
        if (this.fieldMarkingPrivate || this.methodMarkingPrivate) {
            programClassPool.classesAccept(new NonPrivateMemberMarker());
        }
        if (this.fieldMarkingPrivate) {
            programClassPool.classesAccept(new ClassAccessFilter(0, 512, new AllFieldVisitor(new MemberAccessFilter(0, 2, new MemberPrivatizer(fieldMarkingPrivateCounter)))));
        }
        if (this.methodMarkingPrivate) {
            programClassPool.classesAccept(new ClassAccessFilter(0, 512, new AllMethodVisitor(new MemberAccessFilter(0, 2, new MemberPrivatizer(methodMarkingPrivateCounter)))));
        }
        if ((methodInliningUniqueCounter.getCount() > 0 || methodInliningShortCounter.getCount() > 0 || methodInliningTailrecursionCounter.getCount() > 0) && this.configuration.allowAccessModification) {
            programClassPool.classesAccept(new AccessFixer());
        }
        if (methodRemovalParameterCounter2.getCount() > 0 || classMergingVerticalCounter.getCount() > 0 || classMergingHorizontalCounter.getCount() > 0 || classMergingWrapperCounter.getCount() > 0 || methodMarkingPrivateCounter.getCount() > 0 || (methodInliningUniqueCounter.getCount() > 0 || methodInliningShortCounter.getCount() > 0 || methodInliningTailrecursionCounter.getCount() > 0) && this.configuration.allowAccessModification) {
            programClassPool.classesAccept(new AllMemberVisitor(new AllAttributeVisitor(new MethodInvocationFixer())));
        }
        if (this.codeMerging) {
            programClassPool.accept(new TimedClassPoolVisitor("Sharing common code", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Sharing common code", new OptimizationCodeAttributeFilter(new GotoCommonCodeReplacer(codeMergingCounter)))))));
        }
        if (this.codeSimplificationPeephole) {
            ParallelAllClassVisitor.ClassVisitorFactory peepHoleOptimizer = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
                    CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
                    InstructionSequenceConstants sequences = new InstructionSequenceConstants(programClassPool, libraryClassPool);
                    List peepholeOptimizations = Optimizer.this.createPeepholeOptimizations(sequences, branchTargetFinder, codeAttributeEditor, codeSimplificationVariableCounter, codeSimplificationArithmeticCounter, codeSimplificationCastCounter, codeSimplificationFieldCounter, codeSimplificationBranchCounter, codeSimplificationObjectCounter, codeSimplificationStringCounter, codeSimplificationMathCounter, codeSimplificationAndroidMathCounter);
                    InstructionVisitor[] peepholeOptimizationsArray = new InstructionVisitor[peepholeOptimizations.size()];
                    peepholeOptimizations.toArray(peepholeOptimizationsArray);
                    return new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Peephole optimizations", new OptimizationCodeAttributeFilter(new PeepholeOptimizer(branchTargetFinder, codeAttributeEditor, new MultiInstructionVisitor(peepholeOptimizationsArray))))));
                }
            };
            programClassPool.accept(new TimedClassPoolVisitor("Peephole optimizations", new ParallelAllClassVisitor(peepHoleOptimizer)));
        }
        if (this.codeRemovalException) {
            programClassPool.accept(new TimedClassPoolVisitor("Unreachable exception removal", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Unreachable exception removal", new OptimizationCodeAttributeFilter(new UnreachableExceptionRemover(codeRemovalExceptionCounter)))))));
        }
        if (this.codeRemovalSimple) {
            programClassPool.accept(new TimedClassPoolVisitor("Unreachable code removal", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Unreachable code removal", new OptimizationCodeAttributeFilter(new UnreachableCodeRemover(deletedCounter)))))));
        }
        if (this.codeRemovalVariable) {
            programClassPool.accept(new TimedClassPoolVisitor("Variable shrinking", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Variable shrinking", new OptimizationCodeAttributeFilter(new VariableShrinker(codeRemovalVariableCounter)))))));
        }
        if (this.codeAllocationVariable) {
            ParallelAllClassVisitor.ClassVisitorFactory optimizingVariablesVisitor = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    return new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Variable optimizations", new OptimizationCodeAttributeFilter(new VariableOptimizer(false, codeAllocationVariableCounter)))));
                }
            };
            programClassPool.accept(new TimedClassPoolVisitor("Variable optimizations", new ParallelAllClassVisitor(optimizingVariablesVisitor)));
        }
        programClassPool.accept(new TimedClassPoolVisitor("Shrinking constant pool", new ConstantPoolShrinker()));
        int classMarkingFinalCount = classMarkingFinalCounter.getCount();
        int classUnboxingEnumCount = classUnboxingEnumCounter.getCount();
        int classMergingVerticalCount = classMergingVerticalCounter.getCount();
        int classMergingHorizontalCount = classMergingHorizontalCounter.getCount();
        int classMergingWrapperCount = classMergingWrapperCounter.getCount();
        int fieldRemovalWriteonlyCount = fieldRemovalWriteonlyCounter.getCount();
        int fieldMarkingPrivateCount = fieldMarkingPrivateCounter.getCount();
        int fieldPropagationValueCount = fieldPropagationValueCounter.getCount();
        int methodMarkingPrivateCount = methodMarkingPrivateCounter.getCount();
        int methodMarkingStaticCount = methodMarkingStaticCounter.getCount();
        int methodMarkingFinalCount = methodMarkingFinalCounter.getCount();
        int methodMarkingSynchronizedCount = methodMarkingSynchronizedCounter.getCount();
        int methodRemovalParameterCount1 = methodRemovalParameterCounter1.getCount() - initializerFixCounter1.getCount() - initializerFixCounter2.getCount();
        int methodRemovalParameterCount2 = methodRemovalParameterCounter2.getCount() - methodMarkingStaticCounter.getCount() - initializerFixCounter1.getCount() - initializerFixCounter2.getCount();
        int methodPropagationParameterCount = methodPropagationParameterCounter.getCount();
        int methodPropagationReturnvalueCount = methodPropagationReturnvalueCounter.getCount();
        int methodInliningShortCount = methodInliningShortCounter.getCount();
        int methodInliningUniqueCount = methodInliningUniqueCounter.getCount();
        int methodInliningTailrecursionCount = methodInliningTailrecursionCounter.getCount();
        int codeMergingCount = codeMergingCounter.getCount();
        int codeSimplificationVariableCount = codeSimplificationVariableCounter.getCount();
        int codeSimplificationArithmeticCount = codeSimplificationArithmeticCounter.getCount();
        int codeSimplificationCastCount = codeSimplificationCastCounter.getCount();
        int codeSimplificationFieldCount = codeSimplificationFieldCounter.getCount();
        int codeSimplificationBranchCount = codeSimplificationBranchCounter.getCount();
        int codeSimplificationObjectCount = codeSimplificationObjectCounter.getCount();
        int codeSimplificationStringCount = codeSimplificationStringCounter.getCount();
        int codeSimplificationMathCount = codeSimplificationMathCounter.getCount();
        int codeSimplificationAndroidMathCount = codeSimplificationAndroidMathCounter.getCount();
        int codeSimplificationAdvancedCount = codeSimplificationAdvancedCounter.getCount();
        int codeRemovalCount = deletedCounter.getCount() - addedCounter.getCount();
        int codeRemovalVariableCount = codeRemovalVariableCounter.getCount();
        int codeRemovalExceptionCount = codeRemovalExceptionCounter.getCount();
        int codeAllocationVariableCount = codeAllocationVariableCounter.getCount();
        if (codeSimplificationAdvancedCount == 0) {
            fieldPropagationValueCount = 0;
            methodPropagationParameterCount = 0;
            methodPropagationReturnvalueCount = 0;
        }
        if (this.configuration.verbose) {
            System.out.println("  Number of finalized classes:                   " + classMarkingFinalCount + this.disabled(this.classMarkingFinal));
            System.out.println("  Number of unboxed enum classes:                " + classUnboxingEnumCount + this.disabled(this.classUnboxingEnum));
            System.out.println("  Number of vertically merged classes:           " + classMergingVerticalCount + this.disabled(this.classMergingVertical));
            System.out.println("  Number of horizontally merged classes:         " + classMergingHorizontalCount + this.disabled(this.classMergingHorizontal));
            System.out.println("  Number of merged wrapper classes:              " + classMergingWrapperCount + this.disabled(this.classMergingWrapper));
            System.out.println("  Number of removed write-only fields:           " + fieldRemovalWriteonlyCount + this.disabled(this.fieldRemovalWriteonly));
            System.out.println("  Number of privatized fields:                   " + fieldMarkingPrivateCount + this.disabled(this.fieldMarkingPrivate));
            System.out.println("  Number of inlined constant fields:             " + fieldPropagationValueCount + this.disabled(this.fieldPropagationValue));
            System.out.println("  Number of privatized methods:                  " + methodMarkingPrivateCount + this.disabled(this.methodMarkingPrivate));
            System.out.println("  Number of staticized methods:                  " + methodMarkingStaticCount + this.disabled(this.methodMarkingStatic));
            System.out.println("  Number of finalized methods:                   " + methodMarkingFinalCount + this.disabled(this.methodMarkingFinal));
            System.out.println("  Number of desynchronized methods:              " + methodMarkingSynchronizedCount + this.disabled(this.methodMarkingSynchronized));
            System.out.println("  Number of simplified method signatures:        " + methodRemovalParameterCount1 + this.disabled(this.methodRemovalParameter));
            System.out.println("  Number of removed method parameters:           " + methodRemovalParameterCount2 + this.disabled(this.methodRemovalParameter));
            System.out.println("  Number of inlined constant parameters:         " + methodPropagationParameterCount + this.disabled(this.methodPropagationParameter));
            System.out.println("  Number of inlined constant return values:      " + methodPropagationReturnvalueCount + this.disabled(this.methodPropagationReturnvalue));
            System.out.println("  Number of inlined short method calls:          " + methodInliningShortCount + this.disabled(this.methodInliningShort));
            System.out.println("  Number of inlined unique method calls:         " + methodInliningUniqueCount + this.disabled(this.methodInliningUnique));
            System.out.println("  Number of inlined tail recursion calls:        " + methodInliningTailrecursionCount + this.disabled(this.methodInliningTailrecursion));
            System.out.println("  Number of merged code blocks:                  " + codeMergingCount + this.disabled(this.codeMerging));
            System.out.println("  Number of variable peephole optimizations:     " + codeSimplificationVariableCount + this.disabled(this.codeSimplificationVariable));
            System.out.println("  Number of arithmetic peephole optimizations:   " + codeSimplificationArithmeticCount + this.disabled(this.codeSimplificationArithmetic));
            System.out.println("  Number of cast peephole optimizations:         " + codeSimplificationCastCount + this.disabled(this.codeSimplificationCast));
            System.out.println("  Number of field peephole optimizations:        " + codeSimplificationFieldCount + this.disabled(this.codeSimplificationField));
            System.out.println("  Number of branch peephole optimizations:       " + codeSimplificationBranchCount + this.disabled(this.codeSimplificationBranch));
            System.out.println("  Number of object peephole optimizations:       " + codeSimplificationObjectCount + this.disabled(this.codeSimplificationObject));
            System.out.println("  Number of string peephole optimizations:       " + codeSimplificationStringCount + this.disabled(this.codeSimplificationString));
            System.out.println("  Number of math peephole optimizations:         " + codeSimplificationMathCount + this.disabled(this.codeSimplificationMath));
            if (this.configuration.android) {
                System.out.println("  Number of Android math peephole optimizations: " + codeSimplificationAndroidMathCount + this.disabled(this.codeSimplificationMath));
            }
            System.out.println("  Number of simplified instructions:             " + codeSimplificationAdvancedCount + this.disabled(this.codeSimplificationAdvanced));
            System.out.println("  Number of removed instructions:                " + codeRemovalCount + this.disabled(this.codeRemovalAdvanced));
            System.out.println("  Number of removed local variables:             " + codeRemovalVariableCount + this.disabled(this.codeRemovalVariable));
            System.out.println("  Number of removed exception blocks:            " + codeRemovalExceptionCount + this.disabled(this.codeRemovalException));
            System.out.println("  Number of optimized local variable frames:     " + codeAllocationVariableCount + this.disabled(this.codeAllocationVariable));
        }
        return classMarkingFinalCount > 0 || classUnboxingEnumCount > 0 || classMergingVerticalCount > 0 || classMergingHorizontalCount > 0 || classMergingWrapperCount > 0 || fieldRemovalWriteonlyCount > 0 || fieldMarkingPrivateCount > 0 || methodMarkingPrivateCount > 0 || methodMarkingStaticCount > 0 || methodMarkingFinalCount > 0 || fieldPropagationValueCount > 0 || methodRemovalParameterCount1 > 0 || methodRemovalParameterCount2 > 0 || methodPropagationParameterCount > 0 || methodPropagationReturnvalueCount > 0 || methodInliningShortCount > 0 || methodInliningUniqueCount > 0 || methodInliningTailrecursionCount > 0 || codeMergingCount > 0 || codeSimplificationVariableCount > 0 || codeSimplificationArithmeticCount > 0 || codeSimplificationCastCount > 0 || codeSimplificationFieldCount > 0 || codeSimplificationBranchCount > 0 || codeSimplificationObjectCount > 0 || codeSimplificationStringCount > 0 || codeSimplificationMathCount > 0 || codeSimplificationAndroidMathCount > 0 || codeSimplificationAdvancedCount > 0 || codeRemovalCount > 0 || codeRemovalVariableCount > 0 || codeRemovalExceptionCount > 0 || codeAllocationVariableCount > 0;
    }

    private List createPeepholeOptimizations(InstructionSequenceConstants sequences, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionCounter codeSimplificationVariableCounter, InstructionCounter codeSimplificationArithmeticCounter, InstructionCounter codeSimplificationCastCounter, InstructionCounter codeSimplificationFieldCounter, InstructionCounter codeSimplificationBranchCounter, InstructionCounter codeSimplificationObjectCounter, InstructionCounter codeSimplificationStringCounter, InstructionCounter codeSimplificationMathCounter, InstructionCounter codeSimplificationAndroidMathCounter) {
        ArrayList<InstructionVisitor> peepholeOptimizations = new ArrayList<InstructionVisitor>();
        if (this.codeSimplificationVariable) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.VARIABLE_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationVariableCounter));
        }
        if (this.codeSimplificationArithmetic) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.ARITHMETIC_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationArithmeticCounter));
        }
        if (this.codeSimplificationCast) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.CAST_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationCastCounter));
        }
        if (this.codeSimplificationField) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.FIELD_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationFieldCounter));
        }
        if (this.codeSimplificationBranch) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.BRANCH_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationBranchCounter));
            peepholeOptimizations.add(new GotoGotoReplacer(codeAttributeEditor, codeSimplificationBranchCounter));
            peepholeOptimizations.add(new GotoReturnReplacer(codeAttributeEditor, codeSimplificationBranchCounter));
        }
        if (this.codeSimplificationObject) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.OBJECT_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationObjectCounter));
        }
        if (this.codeSimplificationString) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.STRING_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationStringCounter));
        }
        if (this.codeSimplificationMath) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.MATH_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationMathCounter));
            if (this.configuration.android) {
                peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.MATH_ANDROID_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationAndroidMathCounter));
            }
        }
        return peepholeOptimizations;
    }

    private String disabled(boolean flag) {
        return flag ? "" : "   (disabled)";
    }

    private String disabled(boolean flag1, boolean flag2) {
        return flag1 && flag2 ? "" : (flag1 || flag2 ? "   (partially disabled)" : "   (disabled)");
    }

    private class TimedClassPoolVisitor
    implements ClassPoolVisitor {
        private final String message;
        private final ClassPoolVisitor classPoolVisitor;

        public TimedClassPoolVisitor(String message, ClassVisitor classVisitor) {
            this(message, new AllClassVisitor(classVisitor));
        }

        public TimedClassPoolVisitor(String message, ClassPoolVisitor classPoolVisitor) {
            this.message = message;
            this.classPoolVisitor = classPoolVisitor;
        }

        @Override
        public void visitClassPool(ClassPool classPool) {
            long start = 0L;
            if (DETAILS) {
                System.out.print(this.message);
                System.out.print(this.getPadding(this.message.length(), 48));
                start = System.currentTimeMillis();
            }
            classPool.accept(this.classPoolVisitor);
            if (DETAILS) {
                long end = System.currentTimeMillis();
                System.out.println(String.format(" took: %6d ms", end - start));
            }
        }

        private String getPadding(int pos, int size) {
            StringBuilder sb = new StringBuilder();
            for (int i = pos; i < size; ++i) {
                sb.append('.');
            }
            return sb.toString();
        }
    }
}

