#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-6NopiXcOt026rS0033XALn
key:                  arch-hs-0.12.1-6NopiXcOt026rS0033XALn
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  6d2c0cb2e02b19c9a1540a83536e307c
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-6NopiXcOt026rS0033XALn
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.8.1.0 Diff-0.5-HZiJH1oQgrHCiSmIfGIBYM
    aeson-2.1.2.1-6h5MFvBT17H5yplsTy4ABm
    algebraic-graphs-0.7-6L6RsXnvYjMAqZ2KIUyKOv
    arch-web-0.3.2-7FgqeoU0zu76DHPP1hOz85 base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-I3Yz95F3VB23prC9ONLqsR
    conduit-extra-1.3.8-L5aEVN7ERPaAM0AjK09rWN containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-Cokyyj7KoZxLvxcNc1Crid
    http-client-0.7.19-1818a0SJLwXE4QrSYiVT7V
    http-client-tls-0.3.6.4-26jJPqfpxqfJih66sxENJC
    megaparsec-9.7.0-FpJKK1G9cbN77HLJbKTZuE
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-BZ3iZKGMGglGCuWAUbHdn7
    optparse-simple-0.1.1.4-4Wx8n9PBas468CmzGTaF5o
    polysemy-1.9.2.0-AnoOURiOHvgKsLcIcYXwqF
    prettyprinter-1.7.1-HSfe9r3toGeG5iYKvTbBEv
    prettyprinter-ansi-terminal-1.1.3-HBd0HlPB5W983yTXobQ0Tw
    servant-client-0.20.3.0-1EFWLWbpXfTEmum4dtrx4C
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tar-conduit-0.4.1-10VnQs10IOtJDQTTwt6UuR template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

