#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.4
visibility:           public
id:                   arch-hs-0.12.0.4-Ghuite8fNks4osfpcxsPzP
key:                  arch-hs-0.12.0.4-Ghuite8fNks4osfpcxsPzP
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  d266d13650a48edbd5e12fc556298bf7
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.4-Ghuite8fNks4osfpcxsPzP
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4/include
depends:
    Cabal-3.8.1.0 Diff-0.5-FlMLDRSdJaZJnaSeHoV7FH
    aeson-2.1.2.1-LTS2NYlb1uX1OFFp0jy4wh
    algebraic-graphs-0.7-2HQGjP8NLkTEQr5O42ABD2
    arch-web-0.3.1-1cQvIeaaxiwL3wO4B18IlS base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-H4k4i0iLyOvIn1EDVVZRrE
    conduit-extra-1.3.8-Aw1O2RO6EaUslyjUoI9bS containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-5gp8E20DrSD3NTj0XogJTR
    http-client-0.7.19-68a6qtEv6rj7VpzBTCDGAi
    http-client-tls-0.3.6.4-AAPFMBKckpmB2hdicty3YJ
    megaparsec-9.7.0-KvGhsHhDwML9j6n1SsyhuZ
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-F5uGhM8tnYK1W55sYneNCM
    optparse-simple-0.1.1.4-EZQWVivLKIgA0OxPesRoqd
    polysemy-1.9.2.0-KAFulWAULGRHMxPHm8ZpY0
    prettyprinter-1.7.1-BBXLTkLEQRl40uOvW3t4pw
    prettyprinter-ansi-terminal-1.1.3-33kZdcwyY5M8HtWIXW1CoT
    servant-client-0.20.3.0-JmrNLjp9QBY4xsJUyfkGVk
    split-0.2.5-42FGdeEiiUOLLQR1FNYPlK
    tar-conduit-0.4.1-HPWu1lIV7Cn7sZ3x9depXC template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

