#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.4
visibility:           public
id:                   arch-hs-0.12.0.4-1vy2HALdhws4nVlpF42LUH
key:                  arch-hs-0.12.0.4-1vy2HALdhws4nVlpF42LUH
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  44617eb981170a70eb01728bf4dc2549
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.4-1vy2HALdhws4nVlpF42LUH
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-1z8203Zj7CQKOl3UA5hzTf
    aeson-2.1.2.1-Eu0ZMA1fvZJ7acphaZ1YUp
    algebraic-graphs-0.7-Hw5AU2Uvdfx2OwrlkFsBZW
    arch-web-0.3.1-EsThNuSHu1m4XbwJLGi0JL base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-4zipxoOtaf58vXmKwQLSFK
    conduit-extra-1.3.8-CuMCo9UX0Yv2h7Df5xkGn7 containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-GH6JlJfubmnC3i6t2sKtBL
    http-client-0.7.19-3rmvGvyaabxFxCJ9oJ0aDx
    http-client-tls-0.3.6.4-8TCMitZJevE8PRVlviJUoX
    megaparsec-9.7.0-L9yzYQswnVIEfh0e6mQmZ2
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-4IGwqd5FNkx7nulOp1dLHT
    optparse-simple-0.1.1.4-G1WLBrf7dKzAr6Rr2w80Wr
    polysemy-1.9.2.0-L6qhwiMAXSl3w38DybYnsS
    prettyprinter-1.7.1-CsTpPkPqzgLjuO06MZsX5
    prettyprinter-ansi-terminal-1.1.3-H6b8xRSUd7E1Hz5nUxGJlx
    servant-client-0.20.3.0-3cSKCNc4AY71kmho20NOrF
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    tar-conduit-0.4.1-3USxZmasTVcILAsK0Cd0zj template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

