#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.3
visibility:           public
id:                   arch-hs-0.12.0.3-D8LtWLWWENf5imh6hE2f5C
key:                  arch-hs-0.12.0.3-D8LtWLWWENf5imh6hE2f5C
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  db4eb3723e1f33f27870e5037f2eb3bb
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.3-D8LtWLWWENf5imh6hE2f5C
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-BX7ePMXM8kOEj0lpdSYnwr
    aeson-2.1.2.1-HdmwuFbnNgF6PqutsUaf6Y
    algebraic-graphs-0.7-J5T2KgnAaXrJVx1FFQhgjP
    arch-web-0.3.1-1M5Spq6IMVmCS7ZXZLbMbc base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-8TTHoZfFEcNByedkE9Rv7V
    conduit-extra-1.3.8-5tATRySgxkKGEeqgx2l5Qz containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-IPwhuDZPStC1pGPbk61RS7
    http-client-0.7.18-K1IvRTF7D2SE2xldIkW1tD
    http-client-tls-0.3.6.4-9bvTIKuCxU6Eviq8WtS8lH
    megaparsec-9.6.1-5wqMRZqTk6B8Hn3YAbESf9
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-mdGvrhMGbr3ni6gDTrWaQ
    optparse-simple-0.1.1.4-8WMyW5egkcG4Bgshdyrp5Q
    polysemy-1.9.2.0-2u1Y1D56mKV7lR6Sb3zEYN
    prettyprinter-1.7.1-KiZcPWXJVNZ6oHVA0qVcfd
    prettyprinter-ansi-terminal-1.1.3-1ng9uWt2kiaHr5skgX5vwF
    servant-client-0.20-2btVSxDZe7CF0Z0NqcKPhv
    split-0.2.5-JeJxVdKJRKMda8iubaxqh
    tar-conduit-0.4.1-A94SCGxyzuWJn8UhUxjkJ1 template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

