#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.3
visibility:           public
id:                   arch-hs-0.12.0.3-KUcxNHuP1PGJ51pDH9Co72
key:                  arch-hs-0.12.0.3-KUcxNHuP1PGJ51pDH9Co72
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  5e7401b4bae680515daea054ef441a05
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.3-KUcxNHuP1PGJ51pDH9Co72
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-CBiY4eyeiRQG8RHG96uHG4
    aeson-2.1.2.1-2ooOAwlErgbHj6Tyvuh2I5
    algebraic-graphs-0.7-C6OnyP97kzgBmu3ELEWGRl
    arch-web-0.3.1-HlHwH3SWUocGZfWBdr2I2Q base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-IWWL48tOiUMKLUHQSWumck
    conduit-extra-1.3.8-BYn4ndKCbWC3YxWBUq3JmF containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-7jrWptTByTzDq4MUFjMWkk
    http-client-0.7.18-LbIjfqgkVH6EQZrPuBb65p
    http-client-tls-0.3.6.4-AoW9RXZ494d6jfm3w17fZv
    megaparsec-9.6.1-5RuoB8ePxKF1XTFOu32khO
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-6eowvWOd4tCDmnA5goIhI3
    optparse-simple-0.1.1.4-6Aygds8vkvFB5RPke3Ikyv
    polysemy-1.9.2.0-EsetZiv5zrrA3tKt8R5yIn
    prettyprinter-1.7.1-EqfzrdoXeXwBZWVdz9UKUZ
    prettyprinter-ansi-terminal-1.1.3-2kAqCIFmqyI2b54jwtSYDP
    servant-client-0.20.2-JM34bTnbRELB0qdYyB0mui
    split-0.2.5-JeJxVdKJRKMda8iubaxqh
    tar-conduit-0.4.1-vgrF0LlgAWKofnSsuXlgj template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

