#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.2
visibility:           public
id:                   arch-hs-0.12.0.2-8ymxEHRt60nIywB0bYz6Du
key:                  arch-hs-0.12.0.2-8ymxEHRt60nIywB0bYz6Du
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  1e20881a76453f015c9dfacf48d03bc7
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.2-8ymxEHRt60nIywB0bYz6Du
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-FxeNHFTYxDKIg5IYEwDazL
    aeson-2.1.2.1-BB6MQBhtmtsAO1zPoxRUji
    algebraic-graphs-0.7-17FbVdYeM4bJXABds8EJmw
    arch-web-0.3.1-AldJRN9NkIP9IcJ0fy4JGU base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-3HCiRDq9zR1CEucMNc2WMC
    conduit-extra-1.3.7-A67PcDSNX9x2HECfgTvqua containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-6lQnuoOG74DD1AXijFRRwb
    http-client-0.7.18-AuMHjB7Pc554n43to09X7i
    http-client-tls-0.3.6.4-EW3ab21P2ZFHOb6SfgYztf
    megaparsec-9.6.1-3pvQMUNVcr66BLLEBIDI4Y
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-th-0.4.3.17-Vfga0HXPTS6SXD3NuXqZ3
    neat-interpolation-0.5.1.4-3yV2ppFTeCp4ygwToBjfN2
    optparse-simple-0.1.1.4-4nDfo32PBIi4sXVQsyfUP4
    polysemy-1.9.2.0-5XM5naGgyQNIQr4HH5Ylde
    prettyprinter-1.7.1-7FxwfHkFGwc7hJXAWpcKVm
    prettyprinter-ansi-terminal-1.1.3-Hr0nD63w4DMF62mQlb80ld
    servant-client-0.20-2oym0xBEof79olBx1Opc5d
    split-0.2.5-ExnTDD87zWd4kH23akKUK6
    tar-conduit-0.4.1-gVRBdmDUId1m8x9L6oQzk template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

