#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.2
visibility:           public
id:                   arch-hs-0.12.0.2-85TrvOosSRKJzcY9xYR0mZ
key:                  arch-hs-0.12.0.2-85TrvOosSRKJzcY9xYR0mZ
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  2b1a81b915f8d59751f276045eb44db6
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.2-85TrvOosSRKJzcY9xYR0mZ
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-FxeNHFTYxDKIg5IYEwDazL
    aeson-2.1.2.1-1sit77W6SL3BciMFQH0A5E
    algebraic-graphs-0.7-5xdI49GYYYG2K3bzy5Cydc
    arch-web-0.3.1-14vU4bAaiom9Z4zeYjXbm8 base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-2ALTHKVWE9PHUS8ksnDgpr
    conduit-extra-1.3.7-8SvbBd5t3V7KSlP9Oy8qXQ containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-IeanGNarsuD6OxSQv3UzyP
    http-client-0.7.18-AuMHjB7Pc554n43to09X7i
    http-client-tls-0.3.6.4-EW3ab21P2ZFHOb6SfgYztf
    megaparsec-9.6.1-3pvQMUNVcr66BLLEBIDI4Y
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-th-0.4.3.17-Vfga0HXPTS6SXD3NuXqZ3
    neat-interpolation-0.5.1.4-F9yzVRizsXE3uVnqFjKmQe
    optparse-simple-0.1.1.4-4nDfo32PBIi4sXVQsyfUP4
    polysemy-1.9.2.0-JoVOw18m0ceKM6Ozyq4f0v
    prettyprinter-1.7.1-7FxwfHkFGwc7hJXAWpcKVm
    prettyprinter-ansi-terminal-1.1.3-Hr0nD63w4DMF62mQlb80ld
    servant-client-0.20-l64gwvW1IyHXc4L4k4CgZ
    split-0.2.5-ExnTDD87zWd4kH23akKUK6
    tar-conduit-0.4.1-FYL48vb1c8pAlCwqfrNVM3 template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

