#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.2
visibility:           public
id:                   arch-hs-0.12.0.2-va7CqEFZArKmfKjJY0NHV
key:                  arch-hs-0.12.0.2-va7CqEFZArKmfKjJY0NHV
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  8770601634c2565efd289eb7d8ba9b45
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.2-va7CqEFZArKmfKjJY0NHV
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-L8DOUuNGxiiH0X79lq9Zn6
    aeson-2.1.2.1-Gng3eoGBP2Sj2fbUBsnWH
    algebraic-graphs-0.7-4YGj7d4NPxE4IUx2amJd56
    arch-web-0.3.1-GKpq8HBvcvHExv9uGSl12I base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-CTNxTBwbo3PGCTtXLpLpH4
    conduit-extra-1.3.7-J2dsol3NH8o2F5R2VKU1oH containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-4KmzF42mXYp3qxTFbb9pJm
    http-client-0.7.18-459exqS5txS1OoId3JMPZk
    http-client-tls-0.3.6.4-7S2cUrl1lPP9SbVvzQv2U1
    megaparsec-9.6.1-EGAiipKGhRa2zjyQ3XtPp3
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-HQ7XpNvbmQbCS9yDkwGYPM
    optparse-simple-0.1.1.4-Ii42PXNEjJG6go3slZtUir
    polysemy-1.9.2.0-KP7TI2KL867Budvsnce4Ke
    prettyprinter-1.7.1-G37JwSOM6BFGPcFlHNjXb6
    prettyprinter-ansi-terminal-1.1.3-BtkpNj27yDz2ET1Er4fc8d
    servant-client-0.20-A5MoObTnrG2JhUQ8VQbDkF
    split-0.2.5-KlKHd5o1KWaBkefamTdKTk
    tar-conduit-0.4.1-KhgwkrkXAzQDMP7QmkBTr5 template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

