#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 Allure
version:              0.11.0.0
visibility:           public
id:                   Allure-0.11.0.0-Bkem2OcVOHv7zelU1U6vld
key:                  Allure-0.11.0.0-Bkem2OcVOHv7zelU1U6vld
license:              AGPL-3.0-or-later
maintainer:           Mikolaj Konarski <mikolaj.konarski@funktory.com>
author:               Andres Loeh, Mikolaj Konarski and others
homepage:             http://allureofthestars.com
synopsis:             Near-future Sci-Fi roguelike and tactical squad combat game
description:
    Allure of the Stars is a near-future Sci-Fi roguelike
    and tactical squad combat game. Binaries and the game manual
    are available at the homepage. You can also try the game out
    in the browser at <http://allureofthestars.com/play>.

    Not a single image in this game. You have to imagine everything
    yourself, like with a book (a grown-up book, without pictures).
    Once you learn to imagine things, though, you can keep exploring
    and mastering the world and making up stories for a long time.

    The game is written in Haskell using the LambdaHack roguelike
    game engine <http://hackage.haskell.org/package/LambdaHack>.
    Please see the changelog file for recent improvements
    and the issue tracker for short-term plans. Long term goals
    are high replayability and auto-balancing through procedural
    content generation and persistent content modification
    based on player behaviour. Contributions are welcome.

    This is a workaround .cabal file, flattened to eliminate
    internal libraries until generating haddocks for them
    is fixed. The original .cabal file is in .cabal.bkp file.

category:             Game
abi:                  235b060a47fa5539d6c863d69349aecd
exposed:              True
exposed-modules:
    Client.UI.Content.Input Client.UI.Content.Screen Content.CaveKind
    Content.FactionKind Content.ItemKind Content.ItemKindActor
    Content.ItemKindBlast Content.ItemKindEmbed Content.ItemKindOrgan
    Content.ItemKindTemporary Content.ModeKind Content.PlaceKind
    Content.RuleKind Content.TileKind
    Implementation.MonadClientImplementation
    Implementation.MonadServerImplementation TieKnot

hidden-modules:       Paths_Allure
import-dirs:          /usr/lib/ghc-9.4.8/site-local/Allure-0.11.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/Allure-0.11.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/Allure-0.11.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/allure
hs-libraries:         HSAllure-0.11.0.0-Bkem2OcVOHv7zelU1U6vld
depends:
    LambdaHack-0.11.0.1-D5cxb8QFd0G3ez7drlkrq9
    async-2.2.5-6I3Om2iOc9KLV2rb6dASmz base-4.17.2.1
    enummapset-0.7.3.0-AEHhEh2B2Tn5GaREn2RomK
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    ghc-compact-0.1.0.0 hsini-0.5.2.2-KmnnmVWmRylBKIuaYexOzn
    optparse-applicative-0.18.1.0-6vzfjdGcscpK23HoS6KcvN
    primitive-0.9.1.0-1qcn44iT2KcGW7CVhBZc50
    splitmix-0.1.2-BPXbQkwTmbEHuTj8vXXGVm template-haskell-2.19.0.0
    text-2.0.2 th-lift-instances-0.1.20-GfwOcACPir1FmwKUeoNubI
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/allure/html/Allure.haddock
haddock-html:         /usr/share/doc/allure/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

