/*******************************************************************************
 * Copyright 2005 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *******************************************************************************/

#ifndef BMPREADER_H__
#define BMPREADER_H__

#include <ipp.h>

enum ReturnStatus {
    STS_ERR_FAILED = -999,
    STS_ERR_NOT_INITIALIZED = -998,
    STS_ERR_NOT_ENOUGH_DATA = -996,
    STS_ERR_NULL_PTR = -995,
    STS_ERR_INIT = -899,
    STS_ERR_END_OF_STREAM = -895,
    STS_ERR_ALLOC = -883,
    STS_ERR_UNSUPPORTED = -879,
    STS_ERR_INVALID_PARAMS = -876,
    STS_ERR_FILE_OPEN = -875,
    STS_ERR_FORMAT = -874,
    STS_OK = 0,
};

typedef int Status;

Status ReadFile(const char *pFileName, Ipp8u **pImg, IppiSize &imgSize, int &imgStep, int &numChannels);

#define MAX_WIDTH  4096
#define MAX_HEIGHT 2160

#endif /* BMPREADER_H__ */
