/*******************************************************************************
 * Copyright 2015 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *******************************************************************************/

/*
//   Description:
//       Intel(R) Integrated Performance Primitives (Intel(R) IPP) Resize Functions Wrappers for Threading Layer redefinitions:
//       functions with _L API call their _LT versions
//
//   Content:
//
//
//
*/

#if defined(IPP_ENABLED_THREADING_LAYER_REDEFINITIONS)
  #error \
      "This file is not intended to be compiled with -DIPP_ENABLED_THREADING_LAYER_REDEFINITIONS option. Use this option in your application instead."
#endif

#include "owndefs_tl.h"
#include "ippi_tl.h"

/* //////////////////////////////////////////////////////////// */

IPPFUN(IppStatus, ipprFilterBorderInit_16s_LT_Proxy,
       (const Ipp16s *pKernel, IpprVolumeL kernelVolume, int divisor, IppDataType dataType, int numChannels, IpprFilterBorderSpec *pSpec))
{
    return ipprFilterBorderInit_16s_LT(pKernel, kernelVolume, divisor, dataType, numChannels, (IpprFilterBorderSpec_LT *)pSpec);
}
IPPFUN(IppStatus, ipprFilterBorderInit_32f_LT_Proxy,
       (const Ipp32f *pKernel, IpprVolumeL kernelVolume, IppDataType dataType, int numChannels, IpprFilterBorderSpec *pSpec))
{
    return ipprFilterBorderInit_32f_LT(pKernel, kernelVolume, dataType, numChannels, (IpprFilterBorderSpec_LT *)pSpec);
}
IPPFUN(IppStatus, ipprFilterBorderInit_64f_LT_Proxy,
       (const Ipp64f *pKernel, IpprVolumeL kernelVolume, IppDataType dataType, int numChannels, IpprFilterBorderSpec *pSpec))
{
    return ipprFilterBorderInit_64f_LT(pKernel, kernelVolume, dataType, numChannels, (IpprFilterBorderSpec_LT *)pSpec);
}

#define ipprFilterBorder_LT_Proxy(type, depth, chan)                                                                                            \
    IPPFUN(IppStatus, ipprFilterBorder_##depth##_C##chan##V_LT_Proxy,                                                                           \
           (const type *pSrc, IppSizeL srcPlaneStep, IppSizeL srcStep, type *pDst, IppSizeL dstPlaneStep, IppSizeL dstStep,                     \
            IpprVolumeL dstRoiVolume, IpprBorderType borderType, const type borderValue[1], const IpprFilterBorderSpec *pSpec, Ipp8u *pBuffer)) \
    {                                                                                                                                           \
        return ipprFilterBorder_##depth##_C##chan##V_LT(pSrc, srcPlaneStep, srcStep, pDst, dstPlaneStep, dstStep, dstRoiVolume, borderType,     \
                                                        borderValue, (IpprFilterBorderSpec_LT *)pSpec, pBuffer);                                \
    }

ipprFilterBorder_LT_Proxy(Ipp8u, 8u, 1);
ipprFilterBorder_LT_Proxy(Ipp16s, 16s, 1);
ipprFilterBorder_LT_Proxy(Ipp16u, 16u, 1);
ipprFilterBorder_LT_Proxy(Ipp32f, 32f, 1);
ipprFilterBorder_LT_Proxy(Ipp64f, 64f, 1);

/* //////////////////////////////////////////////////////////// */
