#
# Copyright (C) 2021 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to read an options set passed to specified collection.
# For example, the expected input might look like:
#
#-r
#/prj/CRs/006perf_projection_instr_mix/test/e000/dp000
#-quiet
#--tool=tcwicore
#--no-defer-memory-check
#--
#/prj/CRs/006perf_projection_instr_mix/main/main
#
#The expected output might look like:
#
#r : /prj/CRs/006perf_projection_instr_mix/test/e000/dp000
#quiet : True
#tool : tcwicore
#defer-memory-check : False
#executable : /prj/CRs/006perf_projection_instr_mix/main/main
# ------------------------------------------------------------------------------

import sys
try:
    import advisor
except ImportError:
    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

proj_pth = sys.argv[1]
proj = advisor.open_project(proj_pth)
data = proj.load(advisor.SURVEY)

configs = data.get_runtool_cfg(advisor.ResultType.TripCounts)

for k, v in configs.items():
    print(k, ':', v)

