from apm_helpers.messages import Messages as msg
from debug import myprint
import math
import re
class Collection:
 def get_collection_options(self):
  pass
class TrafficProvider(Collection):
 def use_cachesim_config(self,*args,**kwargs):
  self.config=self.get_cachesim_config(*args,**kwargs)
class FlexCacheSimulator(TrafficProvider):
 unit_prefix=['b','k','m','g']
 granularity=8192
 def __init__(self):
  self.config=None
 def get_collection_options(self):
  cache_config=self.config or 'auto'
  return{'tripcounts':['--cache-simulation=multi',f'--cache-config={cache_config}',],}
 @staticmethod
 def has_data(oa_proj):
  return get_cache_simulation_memory_config(oa_proj).get('flex_cachesim')
 @staticmethod
 def get_cachesim_config(sizes_by_device):
  dev_str=[]
  for sizes in sizes_by_device:
   lvl_str=[]
   for lvl_size in sizes:
    lvl_size=math.ceil(lvl_size/FlexCacheSimulator.granularity)*FlexCacheSimulator.granularity
    for unit in FlexCacheSimulator.unit_prefix:
     if lvl_size%1024==0:
      lvl_size//=1024
     else:
      break
    lvl_str.append(f'{lvl_size}{unit}')
   dev_str.append(':'.join(lvl_str))
  return '/'.join(dev_str)
class RegularCacheSimulator(TrafficProvider):
 unit_prefix=['b','k','m','g']
 cache_bank_size=4096
 ways_limit=512
 def __init__(self):
  self.config=None
 def get_collection_options(self):
  return{'tripcounts':['--cache-simulation=single',f'--cache-config={self.config}',],}
 @staticmethod
 def get_cachesim_config(levels):
  lvl_str=[]
  for lvl_idx,lvl in enumerate(levels):
   count,size,ways=lvl
   count=math.ceil(count)
   old_ways=ways
   if not ways:
    ways=math.ceil(size/RegularCacheSimulator.cache_bank_size)
    way_size=RegularCacheSimulator.cache_bank_size
   else:
    way_size=math.ceil(size/ways)
   while ways>RegularCacheSimulator.ways_limit:
    ways//=2
    way_size*=2
   size,old_size=way_size*ways,size
   if size!=old_size:
    myprint(msg.DEBUG_CACHE_SIZE_N_ASSOCIATIVITY_UPDATED.format(lvl_idx+1,old_size,size,old_ways,ways))
   size=way_size*ways
   for unit in RegularCacheSimulator.unit_prefix:
    if size%1024==0:
     size//=1024
    else:
     break
   lvl_str.append(f'{count}:{ways}w:{size}{unit}')
  return '/'.join(lvl_str)
 @staticmethod
 def has_data(oa_proj):
  cachesim_config=get_cache_simulation_memory_config(oa_proj)
  return cachesim_config['regular_cachesim']
 @staticmethod
 def get_simulated_cache_sizes(oa_proj):
  cachesim_config=get_cache_simulation_memory_config(oa_proj)
  if cachesim_config['regular_cachesim']and not cachesim_config['flex_cachesim']:
   if not cachesim_config['cache_config']and not cachesim_config['target_device']:
    myprint(msg.WARNING_UNEXPECTED_CACHESIM_STR.format(cachesim_config['cache_config']),severity=3)
   res=[]
   cachesim_levels=cachesim_config['cache_config'].split('/')
   for cachesim_lvl in cachesim_levels:
    lvl_params=RegularCacheSimulator.cachesim_fmt_re.match(cachesim_lvl)
    if lvl_params:
     try:
      count,cl_size,size,size_units,ways=lvl_params.group('count','cl_size','size','size_units','ways')
      multiplier=1
      for prefix in RegularCacheSimulator.unit_prefix:
       if size_units==prefix:
        break
       else:
        multiplier*=1024
      res.append(int(count or 1)*int(size)*multiplier)
     except(KeyError,ValueError):
      raise
      myprint(msg.WARNING_UNEXPECTED_CACHESIM_STR.format(cachesim_config['cache_config']),severity=3)
      break
   return{'global':res,}
  return{}
 cachesim_fmt=''.join(['^',r'(?:(?P<count>\d+):)?',r'(?:(?P<cl_size>\d+)l:)?',r'(?P<ways>\d+)w:',r'(?P<size>\d+)(?P<size_units>[bkmg])','$',])
 cachesim_fmt_re=re.compile(cachesim_fmt)
def get_cache_simulation_memory_config(oa_proj):
 if cache_simulation_memory_config:
  return cache_simulation_memory_config
 try:
  trc_cfg_info=oa_proj.trc_cfg_info
 except IOError as e:
  myprint(msg.ERROR_NO_RESULT_TYPE_CONTEXT_VARIABLES.format(advisor.ResultType.TripCounts),severity=1)
  trc_cfg_info={}
 for ctx_var_key,cfg_info_key,handler in(('enable_cache_simulation','enable_cache_simulation',lambda x:True if str(x).lower()=='true' else False),('regular_cachesim','cache_simulation',lambda x:True if str(x).lower()=='single' else False),('flex_cachesim','cache_simulation',lambda x:True if str(x).lower()=='multi' else False),('cacheConfiguration','cacheConfiguration',str),('cache_config','cache_config',str),('target_device','target_device',str),):
  try:
   cache_simulation_memory_config[ctx_var_key]=handler(trc_cfg_info.get(cfg_info_key))
  except TypeError:
   myprint(msg.ERROR_NO_VALUE_IN_CONTEXT_VARIABLE.format(cfg_info_key),severity=1)
   cache_simulation_memory_config[ctx_var_key]=None
 cache_simulation_memory_config['regular_cachesim']|=cache_simulation_memory_config['enable_cache_simulation']
 return cache_simulation_memory_config
cache_simulation_memory_config={}
def get_cacheconfig_target(oa_proj):
 return get_cache_simulation_memory_config(oa_proj)['target_device']
