class Messages:
 markup_example="""
    Example:
        "collect.py proj_dir -m <markup_type>" just makes markup on existing project
        "collect.py proj_dir --collect basic -m <markup_type>" creates new project, makes markup and collects data"""
 MARKUP_NEW_PROJ_ERR=("Advisor project directory does not exist. Markup requires at least "+"Survey to be collected. Specify either --collect basic or -collect full alongside with -m to "+"collect data."+markup_example)
 MARKUP_NO_DATA_ERR=("Advisor project directory has no data. Markup requires at least "+"Survey to be collected. Specify either --collect basic or -collect full alongside with -m to "+"collect data."+markup_example)
 SHARED_ARCH_DESC=("Specify architecture for the performance estimation model.")
 SHARED_VERBOSE_DESC=("Specify output verbosity level:\n 1 - Show only error messages. "+"The least verbose level.\n2 - Show warning and error messages.\n"+"3 (default) - Show information, warning and error messages.\n"+"4 - Show debug, information, warning, and error messages. "+"The most verbose level.\n This option affects the console "+"output but does not affect logs and report results.")
 SHARED_PROJECT_DIR_DESC=("Specify the path to the Advisor project directory.")
 SHARED_NO_CACHESIM_DESC=("Disable cache simulation during collection. The model will assume "+"100%% hit rate for cache. Usage decreases collection overhead.")
 SHARED_CONFIG_DESC=("Specify a configuration file by absolute path or name. If you choose "+"the latter, the current directory will be searched for "+"the file first, then the model configuration directory. "+"You can specify additional configurations using this option more than once.")
 SHARED_OUT_DIR_DESC=("Specify the directory to put all generated files into. By default, "+"results are saved in <advisor_project>/perf_models/mNNNN directory. "+"If you specify an existing directory or absolute path, results will "+"be saved in the directory. The directory will be created if it doesn't "+"exist. If you only specify the directory <name>, results will be "+"stored in <advisor_project>/perf_models/<name>.")
 SHARED_OUT_PREFIX_DESC=("Specify a string to be prepended to output result filenames.")
 SHARED_NO_STACKS_MODE_DESC=("Enable low overhead collection and analysis mode. Reduce collection "+"overhead and may reduce analysis accuracy.")
 COLLECT_PY_USAGE=("Depending on options, collect basic data, do markup, "+"and collect refinement data. By default, "+"executes all steps. Application argument is required "+"for any option except --markup.")
 COLLECT_BASIC_DESC=("Deprecated; use '--collect basic' instead.")
 COLLECT_REFINEMENT_DESC=("Deprecated; use '--collect refinement' instead.")
 COLLECT_FULL_DESC=("Deprecated; use '--collect full' instead.")
 COLLECT_COLLECT_DESC=("Specify the type of data to collect. Possible options: basic - "+"Collect basic data (Hotspots and FLOPs) for the application.\n"+"refinement - Collect refined data for marked loops.\n"+"full (default) - Collect basic data for the application and "+"refined data for marked loops.")
 COLLECT_EXE_OF_INTEREST_DESC=("Specify the executable process name to profile, if not the same "+"as application to run. Use this option if you run your application "+"via script or other binary. Specify the name only, not the full path!")
 COLLECT_APP_AND_ARGS_DESC=("Specify an application for either basic or refinement collections. "+"Everything after the double dash is considered as an application with "+"arguments for data collections.")
 COLLECT_MPI_RANK_DESC=("Use results for the specified MPI rank for pre-collection markup.")
 ANALYZE_ASSUME_PARALLEL_DESC=("Assume that a loop is parallel if the loop type is not known.")
 ANALYZE_NO_ASSUME_PARALLEL_DESC=("Assume that a loop has a dependency if the loop type is not known (default).")
 ANALYZE_ASSUME_DEPENDENCIES_DESC=("Assume that a loop has a dependency if the loop type is not known (default).")
 ANALYZE_NO_ASSUME_DEPENDENCIES_DESC=("Assume that a loop does not have dependencies if the loop dependency type is unknown.")
 ANALYZE_SET_PARDEP_METAVAR="<IDs/source_locations>"
 ANALYZE_SET_PARALLEL_DESC=("Assume loops are parallel if they have IDs or source locations from a "+"specified comma-separated list. If the list is empty, assume all loops "+"are parallel.\nNote: --set-dependency option takes precendence over "+"--set-parallel, so if the loop is listed in both, it will be "+"considered as having a dependency.")
 ANALYZE_SET_DEPENDENCY_DESC=("Assume loops have a dependency if they have IDs or source locations "+"from a specified comma-separated list.  If the list is empty, assume "+"all loops have a dependency.\nNote: --set-dependency option takes precendence over "+"--set-parallel, so if the loop is listed in both, it will be "+"considered as having a dependency.")
 ANALYZE_NON_ACCEL_TIME_BREAKDOWN_DESC=("Provide a detailed breakdown of non-offloaded parts of offloaded region.")
 ANALYZE_SELECT_LOOPS_METAVAR="[<file_name>:<line_number>|<LoopID>]"
 ANALYZE_SELECT_LOOPS_DESC=("Limit the analysis to specified loopnests determined by passing a "+"topmost loop. The parameter must be a comma-separated list of Loop IDs or source "+"locations in the following format: <file_name>:<line_number>.")
 ANALYZE_VERSION_DESC=("Display Intel Advisor version information.")
 ANALYZE_LOOP_FILTER_THRESHOLD_DESC=("Specify the loop filter threshold in seconds. The default is {}. "+"Loopnests with total time less than the threshold will be ignored.")
 ANALYZE_SMALL_NODE_FILTER_DESC=("Specify the total time threshold, in seconds, to filter out nodes in "+"the program_tree.dot that fall below this value. "+"The default is {}s.")
 ANALYZE_EVALUATE_MIN_SPEEDUP_DESC=("Enable offload fraction estimation that reaches minimum speedup "+"defined in configuration file. Disabled by default.")
 ANALYZE_MPI_RANK_DESC=("Use results for the specified MPI rank if multiple ranks were analyzed.")
 ANALYZE_MODEL_CHILDREN_DESC=("Analyze child loops of the region head to find if some of "+"the child loops provide more profitable offload.")
 ANALYZE_NO_MODEL_CHILDREN_DESC=("Do not analyze child loops of the region head.")
 ANALYZE_CHECK_PROFITABILITY_DESC=("Check the profitability of offloading regions (default). Only regions "+"that can benefit from the increased speed are added to the report.")
 ANALYZE_NO_CHECK_PROFITABILITY_DESC=("Add all evaluated regions to the report, regardless of the profitability "+"of offloading specific regions.")
 ANALYZE_USE_COLLECT_CONFIGS=("""Use configuration files gathered from collection phase (in addition to
        default and user specified configuration files).""" )
 ANALYZE_NOT_USE_COLLECT_CONFIGS=("""Ignore configuration files gathered from collection phase. Only
        default and user specified configuration files will be used.""" )
 ANALYZE_CPU_SCALE_DESC=("Approximates a host CPU that is cpu_scale_factor times faster than the original CPU "+"where collection was run. Divides all original CPU times by cpu_scale_factor.")
 ANALYZE_IGNORE_DESC=("Ignores time spent in regions from given runtimes or libraries when calculating "+"per-program speedup. Individual offloads are not affected.")
 ANALYZE_EXCLUDE_FROM_REPORT=("Specify items to exclude from a report. Available items: {}.")
 ANALYZE_INCLUDE_TO_REPORT=("Specify items to include to a report. Available items: {}.")
 ANALYZE_CLI_CONFIG=("Specify a single-line configuration parameter to modify in a format "+"\"<group>.<parameter>=<new-value>\". Examples: "+"\"min_required_speed_up=0\""+", \"scale.Tiles_per_process=0.5\""+". You can use this option more than once to modify several parameters.")
 SETTINGS_ACCELERATOR_MISSING=("""Unable to generate settings file for the {} accelerator.""")
 SETTINGS_FILE_EXISTS=("""Settings file at '{}' exists.""")
 SETTINGS_FILE_DOES_NOT_EXIST=("""Settings file at '{}' does not exist.""")
 SETTINGS_CONFIG_USE=("""Loading the following configuration files gathered during collection: {}""")
 SETTINGS_CONFIG_NOT_USE=("""Excluding loading of configuration files gathered during collection.""")
 INTERNAL_ERR_PARENT_NOT_FOUND_FOR_INLINED_FUNC="Internal error: could not find parent loop for inlined function '{}'"
 INTERNAL_ERR_PARENT_NOT_FOUND_FOR_VECTOR_FUNC="Internal error: could not find parent loop for vector function '{}'"
 ERROR_NO_ACCELERATOR_MODEL_FOUND="No accelerator models found in '{}'."
 ERROR_NO_ACCELERATOR_MODEL_SPECIFIED="No accelerator/architecture model specified."
 ERROR_CANT_CREATE_FOLDER="Cannot create results folder at '{}': {}."
 ERROR_DIR_DOESNT_EXIST="Specified Intel Advisor results directory '{}' doesn't exist."
 ERROR_MUST_HAVE_BUILD_NUMBER="Intel Advisor must have a build number of at least {}.\nMake sure you are using the correct Advisor version."
 ERROR_MISSING_REQUIRED_PARAMETER="Parameter '{}' is required but missing from configuration file."
 ERROR_INVALID_TOML="The configuration file '{}' contains invalid TOML.\n{}"
 ERROR_CONFIG_NOT_FOUND="Specified '{}' config file not found in \n  > {}"
 ERROR_DUPLICATE_CONFIGS="Cannot load the same configuration file twice: {}"
 ERROR_UNEXPECTED_PYTHON_VERSION="Attempting to use an unexpected version of Python {}."
 ERROR_SNAPSHOT_CANNOT_BE_USED=("Intel Advisor snapshot '{}' cannot be used to collect new data.\n"+"Either specify project directory or use analyze.py to analyze data in snapshot.")
 ERROR_IMPORT_FAIL=("Python could not resolve path to Advisor's Python API directory. To fix, "+"either manually add path to the Python API directory into PYTHONPATH "+"environment variable, or use advixe-vars.* scripts to set up product "+"environment variables automatically.")
 ERROR_APP_AND_ARGS_NOT_EMPTY="The -- flag should only be used in run_oa.py and collect.py"
 ERROR_NO_DATA_IN_SURVEY=("No data in survey. "+"Make sure profiled application is running longer than several seconds.")
 ERROR_NO_DATA_IN_OPEN_PROJECT="No data in open project."
 ERROR_NO_SOURCE_IN_INSTRUCTION_MIX='Internal error: Instruction counters "{}" are not available.'
 ERROR_PYTHON2_USED="Python* 2 is no longer supported. Please, use Python 3.6 or higher."
 ERROR_PYTHON35_USED="Python* 3.5 and lower is not supported. Please, use Python 3.6 or higher."
 ERROR_ADVISOR_OLDER_THAN="Intel Advisor version in PATH is older than {}; {}."
 ERROR_PACKED_SNAPSHOT_AS_OUT_DIR=("There is no way to save new information to the Intel Advisor packed snapshot.\n"+"Please consider using the --out-dir|-o option.")
 ERROR_NO_VALUE_IN_CONTEXT_VARIABLE="Required context variable {} is empty or has an invalid value."
 ERROR_NO_RESULT_TYPE_CONTEXT_VARIABLES="Cannot get context values of the {} collection."
 ERROR_NO_DEVICE_LIST="A list of supported devices to generate a default parameter for the flexible cache simulation couldn't be found."
 ERROR_COLUMN_FORMAT="Invalid configuration format at the column {}."
 WARNING_DEPRECATED_FLAG="The '{}' flag is deprecated. {}"
 WARNING_CANNOT_DETECT_VERSION="Cannot detect version of Intel Advisor."
 WARNING_PYTHON2_USED=("Python* 2 support is deprecated and will be removed in a future release. "+"Consider using Python 3.6 or higher.")
 WARNING_WRONG_OFFLOAD_COMBINATION_ESTIMATION=("Internal error: Incorrect estimation for the offload combination {}. Data reuse for this combination cannot be found.")
 WARNING_UNKNOWN_MEMORY_LEVEL="Unknown memory level '{}'."
 WARNING_NO_LOOPS_SELECTED=("No loops were selected during markup.")
 WARNING_SELECTING_LOOP_INSIDE_SELECTED_REGION=("Loop '{}' with ID '{}' is inside already selected region. Only most external "+"loop will be selected. Use CLI Loop IDs to disambiguate selection.")
 WARNING_NO_USER_SELECTION_FOUND=("None of arguments of --select-loops were found in call tree. "+"All data will be analyzed. Use CLI Loop IDs for precise selection.")
 WARNING_NO_MEMORY_MODEL="No appropriate memory model found for row with type '{}'. Performance projection result may be inadequate. Please, report the issue to developers."
 WARNING_INVAILD_REPORT_PART="Invalid report items to be included or excluded: {}"
 WARNING_NO_REUSE_DATA="Data reuse analysis was enabled, but no data reuse is detected. Make sure you run the Trip Counts collection with the data reuse analysis enabled using the --data-transfer=full option."
 WARNING_NO_REPEAT_DATA_TRANSFER="Repeat data transfer analysis was enabled, but no data reuse data is detected. Make sure you run the Trip Counts collection with the data reuse analysis enabled using the --data-transfer=full option."
 WARNING_UNEXPECTED_CACHESIM_STR="Unexpected cache simulator configuration string \'{}\'. Estimated traffic may be inaccurate."
 WARNING_GPU_NO_INSTRUCTION_COUNTERS="Some of GPU rows does not contain instruction counters. Estimation may be inaccurate."
 INFO_CONFIG_FOUND="Found '{}'"
 INFO_CONFIG_FOUND_AT="Found '{}' at '{}'."
 INFO_DEFAULT_OUT_DIR=("Results will be stored at '{}'. See interactive HTML report in '{}'.\n"+"      You can use the Advisor GUI to see the performance modeling result based on the data saved along this path.\n"+"      NOTE: running performance modeling from the Advisor GUI will remove all previous results from the Advisor project.\n")
 INFO_OUT_DIR="Results will be stored at '{}'. See interactive HTML report in '{}'"
 INFO_SELECTED_ACCELERATOR="Selected accelerator to analyze: {}."
 INFO_FOUND_APM_LIBRARY_CONFIG="Found {} in apm_config library."
 INFO_LOOP_SELECTION_OPTIONS=("Add following options to collection to select fitting loops:\n{}")
 INFO_LOOP_DEFAULT_SELECTION=("Run collection without additional options to get default coverage.")
 INFO_ADD_OPTIONS=("Add following options to collection to select fitting loops:\n{}")
 INFO_LOOP_SELECTED=("Selected: {}, ID: {}")
 INFO_MARKUP_COMPLETE=("Selected loops are stored in the project. You could run collection "+"without specifying loop selection options.")
 INFO_CPU_SCALE_FACTOR_APPLIED=("Applied CPU scale factor '{}'.")
 INFO_BASELINE="Baseline {}."
 INFO_BINARY_NAME="Binary Name: {}."
 INFO_CHANGE_GPU_SAMPLING_INTERVAL=("Average execution time for some GPU kernels is too small. "+"To increase modeling accuracy, change GPU sampling interval with the command line option "+"'--gpu-sampling-interval={expected_t_sample}' "+"(in milliseconds, current value: {t_sample} ms).")
 INFO_FLEX_CACHESIM_CONFIG="Flex cachesim cache config: '{}'."
 INFO_CACHESIM_CONFIG_MISMATCH="Cache simulation data for the target device '{}' was not collected. Please rerun collection with required target device."
 DEBUG_INCLUSIONS_FOUND="Inclusions found in {}.toml. Description: {}"
 DEBUG_INCLUDE_CONFIG_FILE="Including configuration file '{}'"
 DEBUG_NO_LOOPS_SELECTED=("No loops were selected during markup.")
 DEBUG_COLLECTION_WITH_FLAGS=("Collection will proceed with additional flags: '{}'.")
 DEBUG_COLLECTION_WITH_DEFAULTS=("Collection will proceed with default selections.")
 DEBUG_ALL_FINISHED=("All finished [{}].")
 DEBUG_STARTING_MARKUP=("Starting Markup [{}].")
 DEBUG_TOP_LEVEL_OFFLOAD_INSTEAD_OF_CHILDREN_OFFLOADS=("Selected single top-level offload over combination of children offloads")
 DEBUG_CHILDREN_OFFLOADS_INSTEAD_OF_TOP_LEVEL_OFFLOAD=("Selected combination of children offloads over single top-level offload")
 DEBUG_OFFLOAD_IS_PROFITABLE=("Offload at ({}) is profitable\n")
 DEBUG_OFFLOAD_IS_NOT_PROFITABLE_OR_NOT_POSSIBLE=("Offload at ({}) level is not profitable or not possible\n")
 DEBUG_CHECKING_INTERNAL_OFFLOAD=("Checking internal offload at: {} (id: {}, key: {})")
 DEBUG_CONSTRUCT_LOOP_NESTS=("construct_loop_nests: does_this_fit({} {{key={}}}) returns {}")
 DEBUG_NOT_AN_OFFLOAD__NOT_IN_BOTTOMUP_TABLE=("key={} is not an offload candidate, reason: Internal Error: not in a bottom-up table")
 DEBUG_NOT_AN_OFFLOAD__NO_INSTRUCTION_MIX=("key={} (bu_key={}) is not an offload candidate, reason: Internal Error: no instruction mix data")
 DEBUG_NOT_AN_OFFLOAD__SYSTEM_MODULE=("key={} is not offload candidate, reason: system module")
 DEBUG_NOT_AN_OFFLOAD__NOT_EXECUTED=("key={} is not offload candidate, reason: row was not executed")
 DEBUG_NOT_AN_OFFLOAD__NO_EXECUTION_COUNT=("key={} (bu_key={}) is not offload candidate, reason: no call_count/trip_count metrics")
 DEBUG_NOT_AN_OFFLOAD__ZERO_EXECUTION_COUNT=("key={} (bu_key={}) is not offload candidate, reason: call_count/trip_count metrics are zero")
 DEBUG_BW_USAGE=("memory level: {}, loaded_bytes: {}, stored bytes: {}")
 DEBUG_ESTIMATED_FOOTPRINT=("row name: {}, key: {}, estimated footprint size: {}")
 DEBUG_DETAILED_INSTRUCTION_MIX_NOT_FOUND=("Detailed instruction counters '{}' are zeroes or not found for the row '{}'.")
 DEBUG_UNKNOWN_BOUNDED_BY_REASON=("Unknown Bounded-by Reason: '{}' for row '{}'")
 DEBUG_DECREASE_SAMPLING_INTERVAL=("Kernel '{kernel}' Average Time is {time} ms. "+"The time is too small and might cause incorrect estimation. "+"To improve estimation accuracy, decrease the GPU sampling interval to "+"{expected_t_sample} ms.")
 DEBUG_N_GPU_SAMPLES_REQUIRED=("Kernel '{kernel}' Average Time is {time} ms. "+"The time is too small and might cause incorrect estimation. "+"To improve estimation accuracy, decrease the GPU sampling interval to "+"{expected_t_sample} ms "+"and increase the workload size to at least {expected_time} ms per kernel "+"(at least {min_samples} GPU samples per kernel are recommended). ")
 DEBUG_CACHE_SIZE_N_ASSOCIATIVITY_UPDATED=("For cache level '{}' updated size and associativity. "+"Size: {}->{}. Associativity: {}->{}.")
 DEBUG_GPU_ROW_NO_INSTRUCTION_MIX=("{} does not contain instruction mix info.")
 class NonOffload:
  class Reasons:
   NOT_EXECUTED="Not Executed"
   SYSTEM_MODULE="System Module"
   NO_EXEC_COUNT="No Execution Count"
   INTERNAL_ERROR="Internal Error"
   AGGREGATED="Aggregated"
   SOURCE_TASK="Source compute task"
  OUTSIDE_OF_MARKED_REGION=("Outside of Marked Region")
  CANNOT_BE_MODELLED_BECAUSE_OF=("Cannot be modelled: {}")
  TOO_SMALL_TOTAL_TIME=("""Total time is too small for
                reliable modelling. Use --loop-filter-threshold=0 to model such
                small offloads."""  )
  NOT_PROFITABLE_BECAUSE_OF=("Not profitable: {}")
  NOT_PROFITABLE_BECAUSE_OF_TAXES=("Not profitable because of offload overhead (taxes)")
  LESS_PROFITABLE_THAN_CHILDREN=("Less or equally profitable than children offloads")
  LESS_PROFITABLE_THAN_PARENT=("Less or equally profitable than potential parent offload")
  PART_OF_OFFLOAD=("n/a - part of offload")
 class BoundedBy:
  DEPENDENCY="Parallel execution efficiency is limited due to Dependencies"
  TRIP_COUNT="The Number of Loop Iterations is not enough to fully utilize Target Device capabilities"
  DATA_TRANSFER="Data Transfer Tax is greater than Compute Time and Memory Bandwidth Time"
  COMPUTE="Compute Time is high despite the full use of Target Device capabilities"
  MEMORY_BW="{} Bandwidth Time is greater than other execution time components on a Target Device"
  INVOKE_TAX="Invocation Tax is greater than Kernel Execution time and Data Transfer Time"
  TRANSFER_TAX="Kernel Transfer Tax is greater than Kernel Execution Time and Data Transfer Time"
  LAUNCH_TAX="Kernel Launch Tax is greater than Kernel Execution Time and Data Transfer Time"
  GLOBAL_ATOMIC="Atomic Throughput Time is greater than other execution time components on a Target Device"
  LOCAL_ATOMIC="Local Atomic Throughput Time is greater than other execution time components on a Target Device"
  LATENCIES="Instruction Latency is greater than Compute Time and Memory Bandwidth Time"
 class Diagnostics:
  AGGREGATED_EXECUTION_COUNT="Aggregated execution count was used"
  ASSEMBLY_UNAVAILABLE="Assembly code is unavailable"
  NO_EXECUTED_BASIC_BLOCK="No basic blocks executed"
  NO_CACHE_MEMORY_DATA="No cache/memory traffic data"
  DETAILED_STATIC_INSTR_MIX_USED="Detailed static instruction mix was used"
  TOPDOWN_DYNAMIC_INSTR_MIX_USED="Top-down dynamic instruction mix was used"
  BOTTOMUP_STATIC_INSTR_MIX_USED="Bottom-up static instruction mix was used"
  BOTTOMUP_DYNAMIC_INSTR_MIX_USED="Bottom-up dynamic instruction mix was used"
  DYNAMIC_OP_COUNT_USED="Dynamic operation count was used"
