import copy
from apm_helpers.config import ConfigurationLoader
from accelerators.gen import deviceconfig
import oa_wrapper.collection as collection
def get_cache_config(memory_config,first,getter):
 if first:
  res=[first]
 else:
  res=[]
 local_mem_levels=memory_config.levels.get('local')
 if local_mem_levels:
  mem_lvl=local_mem_levels[-1]
  if mem_lvl.size_total:
   res.append(getter(mem_lvl))
 for mem_lvl in memory_config.levels['global']:
  if mem_lvl.is_cache:
   res.append(getter(mem_lvl))
 return res
def get_combined_flex_config(config_list,scalers=None):
 combined_config=[]
 if not scalers:
  scalers=[1]
 for device_config in config_list:
  for scaler in scalers:
   for enable_slm in(True,False):
    try:
     device_config['Tiles_per_process']=scaler
     try:
      device_config['memory']['SLM']['disabled']=not enable_slm
      device_config['memory']['cache']['eDRAM']['disabled']=False
     except KeyError:
      pass
     cfg=deviceconfig.load_device_config(device_config)
     combined_config.append(get_cache_config(cfg.memory,8192,lambda lvl:lvl.size_total))
    except Exception as e:
     raise
 return collection.FlexCacheSimulator.get_cachesim_config(combined_config)
def get_regular_cachesim_config(device_config,scaler,enable_slm=False):
 if not scaler:
  scaler=1
 try:
  device_config['Tiles_per_process']=scaler
  try:
   device_config['memory']['SLM']['disabled']=not enable_slm
   device_config['memory']['cache']['eDRAM']['disabled']=False
  except KeyError:
   pass
  cfg=deviceconfig.load_device_config(device_config)
  cache_config=get_cache_config(cfg.memory,(cfg.structure.subslice_count,4096,64),lambda lvl:(lvl.count,lvl.size_1,lvl.associativity))
  return collection.RegularCacheSimulator.get_cachesim_config(cache_config)
 except Exception as e:
  raise
accelerator_list=['gen']
scalers=[2,4,6,8,12,16,24,32,48,64]
class DeviceListMissed(Exception):
 pass
def get_cachesim_config_strings(scaled,root_path):
 config_dict={}
 for accelerator in accelerator_list:
  cfg_loader=ConfigurationLoader(accelerator,root_path,enable_obfuscated=False,enable_search_in_cwd=False)
  config_file=cfg_loader.resolve_configuration_file('supported_devices',fail_not_found=False)
  if not config_file:
   raise DeviceListMissed(config_file)
  config=config_file.load(fail_during_exception=True)
  if not config or not 'supported_devices' in config:
   raise DeviceListMissed(config_file)
  supported_devices=config['supported_devices']
  config_file=cfg_loader.resolve_configuration_file('performance_model',fail_not_found=False)
  if config_file:
   perf_model=config_file.load(fail_during_exception=True)
  for device in supported_devices:
   config_file=cfg_loader.resolve_configuration_file(device,fail_not_found=False)
   if config_file:
    device_config=copy.deepcopy(perf_model)
    all_files=cfg_loader.resolve_inclusions([config_file])
    device_config.update(cfg_loader.load_aggregate_config(all_files))
    config_dict[device]=device_config
 flex_cachesim_config=get_combined_flex_config(config_dict.values(),scalers if scaled else None)
 regular_cachesim_configs={}
 for device_id,device_config in config_dict.items():
  for enable_slm in(True,False):
   scalers_=scalers if scaled else[1]
   for scaler in scalers_:
    config=get_regular_cachesim_config(device_config,scaler,enable_slm)
    regular_cachesim_configs[(device_id,enable_slm,scaler)]=config
 return flex_cachesim_config,regular_cachesim_configs
