!
! Copyright Intel Corporation.
! 
! This software and the related documents are Intel copyrighted materials, and
! your use of them is governed by the express license under which they were
! provided to you (License). Unless the License provides otherwise, you may
! not use, modify, copy, publish, distribute, disclose or transmit this
! software or the related documents without Intel's prior written permission.
! 
! This software and the related documents are provided as is, with no express
! or implied warranties, other than those that are expressly stated in the
! License.
!
! Copyright (C) by Argonne National Laboratory
! 
! 				  COPYRIGHT
! 
! The following is a notice of limited availability of the code, and disclaimer
! which must be included in the prologue of the code and in all source listings
! of the code.
! 
! Copyright Notice
! 1998--2020, Argonne National Laboratory
! 
! Permission is hereby granted to use, reproduce, prepare derivative works, and
! to redistribute to others.  This software was authored by:
! 
! Mathematics and Computer Science Division
! Argonne National Laboratory, Argonne IL 60439
! 
! (and)
! 
! Department of Computer Science
! University of Illinois at Urbana-Champaign
! 
! 
! 			      GOVERNMENT LICENSE
! 
! Portions of this material resulted from work developed under a U.S.
! Government Contract and are subject to the following license: the Government
! is granted for itself and others acting on its behalf a paid-up, nonexclusive,
! irrevocable worldwide license in this computer software to reproduce, prepare
! derivative works, and perform publicly and display publicly.
! 
! 				  DISCLAIMER
! 
! This computer code material was prepared, in part, as an account of work
! sponsored by an agency of the United States Government.  Neither the United
! States, nor the University of Chicago, nor any of their employees, makes any
! warranty express or implied, or assumes any legal liability or responsibility
! for the accuracy, completeness, or usefulness of any information, apparatus,
! product, or process disclosed, or represents that its use would not infringe
! privately owned rights.
! 
! 			   EXTERNAL CONTRIBUTIONS
! 
! Portions of this code have been contributed under the above license by:
! 
!  * Intel Corporation
!  * Cray
!  * IBM Corporation
!  * Microsoft Corporation
!  * Mellanox Technologies Ltd.
!  * DataDirect Networks.
!  * Oak Ridge National Laboratory
!  * Sun Microsystems, Lustre group
!  * Dolphin Interconnect Solutions Inc.
!  * Institut Polytechnique de Bordeaux
!
!     
!

module mpi_f08_link_constants
use, intrinsic :: iso_c_binding, only: c_ptr, c_int, c_char, c_loc
use :: mpi_f08_types, only : MPI_Status
use :: mpi_c_interface_types, only : c_Status

implicit none

! Named link time constants

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! MPI_STATUS_IGNORE, MPI_STATUSES_IGNORE
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

! In MPICH C code, MPI_STATUS_IGNORE, MPI_STATUSES_IGNORE are pointers of bad address

! Fortran programmers use these MPI_Status variables for INOUT status arguments
type(MPI_Status), bind(C, name="MPIR_F08_MPI_STATUS_IGNORE_OBJ"), target :: MPI_STATUS_IGNORE
type(MPI_Status), dimension(1), bind(C, name="MPIR_F08_MPI_STATUSES_IGNORE_OBJ"), target :: MPI_STATUSES_IGNORE

type(c_ptr), bind(C, name="MPIR_C_MPI_STATUS_IGNORE") :: MPIR_C_MPI_STATUS_IGNORE
type(c_ptr), bind(C, name="MPIR_C_MPI_STATUSES_IGNORE") :: MPIR_C_MPI_STATUSES_IGNORE

! Though these two variables are required by MPI-3 Standard, they are not used in MPICH
type(c_ptr), bind(C, name="MPI_F08_STATUS_IGNORE")   :: MPI_F08_STATUS_IGNORE   ! Point to MPI_STATUS_IGNORE
type(c_ptr), bind(C, name="MPI_F08_STATUSES_IGNORE") :: MPI_F08_STATUSES_IGNORE ! Point to MPI_STATUSES_IGNORE


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!  MPI_ARGV_NULL, MPI_ARGVS_NULL
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! In MPICH C code, MPI_ARGV_NULL and MPI_ARGVS_NULL are NULL pointers
character(len=1), dimension(1), target :: MPI_ARGV_NULL
character(len=1), dimension(1,1), target :: MPI_ARGVS_NULL

type(c_ptr), bind(C, name="MPIR_C_MPI_ARGV_NULL") :: MPIR_C_MPI_ARGV_NULL
type(c_ptr), bind(C, name="MPIR_C_MPI_ARGVS_NULL") :: MPIR_C_MPI_ARGVS_NULL


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!  MPI_ERRCODES_IGNORE
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
integer, dimension(1), target :: MPI_ERRCODES_IGNORE
type(c_ptr), bind(C, name="MPIR_C_MPI_ERRCODES_IGNORE") :: MPIR_C_MPI_ERRCODES_IGNORE


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!  MPI_UNWEIGHTED, MPI_WEIGHTS_EMPTY
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Type of MPI_UNWEIGHTED and MPI_WEIGHTS_EMPTY is not integer(c_int) since we only care their address

integer, dimension(1), target :: MPI_UNWEIGHTED
integer, dimension(1), target :: MPI_WEIGHTS_EMPTY

type(c_ptr), protected, bind(C, name="MPIR_C_MPI_UNWEIGHTED")    :: MPIR_C_MPI_UNWEIGHTED
type(c_ptr), protected, bind(C, name="MPIR_C_MPI_WEIGHTS_EMPTY") :: MPIR_C_MPI_WEIGHTS_EMPTY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!  MPI_IN_PLACE
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
integer(c_int), bind(C, name="MPIR_F08_MPI_IN_PLACE"), target :: MPI_IN_PLACE

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!  MPI_BOTTOM
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Buffer Address Constants
! A.1.1 p. 663
integer(c_int), bind(C, name="MPIR_F08_MPI_BOTTOM"), target :: MPI_BOTTOM

INTERFACE

FUNCTION MPIR_F08_get_MPI_STATUS_IGNORE_c() &
    bind (C, name="MPIR_F08_get_MPI_STATUS_IGNORE") result(p)
    USE, intrinsic :: iso_c_binding, ONLY : c_ptr
    IMPLICIT NONE
    TYPE(c_ptr) :: p
END FUNCTION

FUNCTION MPIR_F08_get_MPI_STATUSES_IGNORE_c() &
    bind (C, name="MPIR_F08_get_MPI_STATUSES_IGNORE") result(p)
    USE, intrinsic :: iso_c_binding, ONLY : c_ptr
    IMPLICIT NONE
    TYPE(c_ptr) :: p
END FUNCTION

END INTERFACE

end module mpi_f08_link_constants
