/*******************************************************************************
* Copyright (C) 2001 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!    vmlSetErrStatus/vmlGetErrStatus/vmlClearErrStatus example program  Example
!    Program Text
!******************************************************************************/

#include <stdio.h>

#include "mkl.h"

/**
 * @brief Print VM error status name
 *
 * Printing of VM error status name
 *
 * @param[in] errst  VM error status
 *
 */
void PrintTextVmlErrStatus(int errst)
{
  switch(errst) {
    case VML_STATUS_OK: {
                fprintf(stdout, "VML_STATUS_OK");
                break;
    }
    case VML_STATUS_BADSIZE: {
                fprintf(stdout, "VML_STATUS_BADSIZE");
                break;
    }
    case VML_STATUS_BADMEM: {
                fprintf(stdout, "VML_STATUS_BADMEM");
                break;
    }
    case VML_STATUS_ERRDOM: {
                fprintf(stdout, "VML_STATUS_ERRDOM");
                break;
    }
    case VML_STATUS_SING: {
                fprintf(stdout, "VML_STATUS_SING");
                break;
    }
    case VML_STATUS_OVERFLOW: {
                fprintf(stdout, "VML_STATUS_OVERFLOW");
                break;
    }
    case VML_STATUS_UNDERFLOW: {
                fprintf(stdout, "VML_STATUS_UNDERFLOW");
                break;
    }
  }
}

/**
 * @brief Main function for ErrStatus test
 *
 * Main performs simple test of ErrStatus function
 *
 * @param[in] argc         Number of arguments
 * @param[in] argv         Pointer to argument strings
 * @return                 -1 for FAIL or 0 for PASS
 *
 */
int main (int argc, char **argv)
{
  int ret = VML_STATUS_OK;
  MKL_INT errst;

  fprintf (stdout, "classic c vm_errstatus: started...\n"); fflush (stdout);

  errst=(MKL_INT)vmlGetErrStatus();

  fprintf(stdout, "\tInitial value of vmlErrStatus: ");
  PrintTextVmlErrStatus((int)errst);
  fprintf(stdout, "\t (0x%x)\n",(int)errst);

  errst=(MKL_INT)(VML_STATUS_BADMEM);
  vmlSetErrStatus(errst);
  errst=(int)vmlGetErrStatus();
  fprintf(stdout, "\tValue of vmlErrStatus after using vmlSetErrStatus: ");
  PrintTextVmlErrStatus((int)errst);
  fprintf(stdout, "\t (0x%x)\n",(int)errst);

  vmlClearErrStatus();
  errst=(MKL_INT)vmlGetErrStatus();
  fprintf(stdout, "\tValue of vmlErrStatus after using vmlClearErrStatus: ");
  PrintTextVmlErrStatus((int)errst);
  fprintf(stdout, "\t (0x%x)\n",(int)errst);

  ret = (vmlGetErrStatus() < VML_STATUS_OK)?-1:0;

  fprintf (stdout, "classic c vm_errstatus: %s\n\n", (ret)?"FAIL":"PASS");

  return ret;
}
