/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Allocable;
import mpi.AllocablePool;
import mpi.Group;
import mpi.MPIException;

public class Comm
implements Allocable {
    public static final Comm WORLD = new Comm(1);
    public static final Comm SELF = new Comm(2);
    public static final int MPI_UNDEFINED = -32766;
    private long handle;

    public Comm() {
        this.init();
        AllocablePool.add(this);
    }

    public Comm(int n) {
        this.handle = n;
    }

    private native void init();

    public long getHandle() {
        return this.handle;
    }

    protected final void setType(int n) {
    }

    public int getSize() throws MPIException {
        return this.MPI_Comm_size(this.getHandle());
    }

    public int getRank() throws MPIException {
        return this.MPI_Comm_rank(this.handle);
    }

    private native int MPI_Comm_size(long var1) throws MPIException;

    private native int MPI_Comm_rank(long var1) throws MPIException;

    @Override
    public void free() {
        AllocablePool.remove(this);
        this.jniFree();
    }

    private native void jniFree();

    public Comm create(Group group) {
        Comm comm = new Comm();
        Comm.MPI_Comm_create(this.getHandle(), group.getHandle(), comm.getHandle());
        return comm;
    }

    public static Comm create(Comm comm, Group group) {
        Comm comm2 = new Comm();
        Comm.MPI_Comm_create(comm.getHandle(), group.getHandle(), comm2.getHandle());
        return comm2;
    }

    private static native void MPI_Comm_create(long var0, long var2, long var4);

    public Comm dup() {
        Comm comm = new Comm();
        this.MPI_Comm_dup(this.getHandle(), comm.getHandle());
        return comm;
    }

    private native void MPI_Comm_dup(long var1, long var3);

    public Comm split(int n, int n2) {
        Comm comm = new Comm();
        this.MPI_Comm_split(this.getHandle(), n, n2, comm.getHandle());
        return comm;
    }

    private native void MPI_Comm_split(long var1, int var3, int var4, long var5);
}

