/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.provider.AbstractCollectionProperty;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.jspecify.annotations.Nullable;

public class DefaultListProperty<T>
extends AbstractCollectionProperty<T, List<T>>
implements ListProperty<T> {
    private static final SerializableLambdas.SerializableSupplier<ImmutableCollection.Builder<Object>> FACTORY = ImmutableList::builder;

    public DefaultListProperty(PropertyHost host, Class<T> elementType) {
        super(host, List.class, elementType, (Supplier)Cast.uncheckedNonnullCast(FACTORY));
    }

    @Override
    public Class<?> publicType() {
        return ListProperty.class;
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.ListPropertyManagedFactory.FACTORY_ID;
    }

    @Override
    protected ImmutableList<T> emptyCollection() {
        return ImmutableList.of();
    }

    @Override
    public ListProperty<T> empty() {
        super.empty();
        return this;
    }

    @Override
    public ListProperty<T> value(@Nullable Iterable<? extends T> elements) {
        super.value(elements);
        return this;
    }

    @Override
    public ListProperty<T> value(Provider<? extends Iterable<? extends T>> provider) {
        super.value(provider);
        return this;
    }

    @Override
    public ListProperty<T> convention(@Nullable Iterable<? extends T> elements) {
        super.convention(elements);
        return this;
    }

    @Override
    public ListProperty<T> convention(Provider<? extends Iterable<? extends T>> provider) {
        super.convention(provider);
        return this;
    }

    public ListProperty<T> unset() {
        return (ListProperty)Cast.uncheckedNonnullCast((Object)super.unset());
    }

    public ListProperty<T> unsetConvention() {
        return (ListProperty)Cast.uncheckedNonnullCast((Object)super.unsetConvention());
    }
}

