/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.ds;

import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.core.stream.DocumentElementExtractingFilterHandler;
import org.apache.axiom.core.stream.NamespaceRepairingFilterHandler;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlHandlerWrapper;
import org.apache.axiom.core.stream.serializer.Serializer;
import org.apache.axiom.core.stream.stax.push.input.XmlHandlerStreamWriter;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.stream.XmlDeclarationRewriterHandler;
import org.apache.axiom.om.impl.stream.XsiTypeFilterHandler;
import org.apache.axiom.om.impl.stream.ds.PushOMDataSourceStreamWriter;
import org.apache.axiom.om.impl.stream.xop.XOPEncodingFilterHandler;
import org.apache.axiom.om.impl.stream.xop.XOPHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class MTOMXMLStreamWriterImpl
extends MTOMXMLStreamWriter {
    private static final Log log = LogFactory.getLog(MTOMXMLStreamWriterImpl.class);
    private final XMLStreamWriter xmlWriter;
    private final OMOutputFormat format;

    MTOMXMLStreamWriterImpl(XMLStreamWriter xmlWriter, OMOutputFormat format) {
        this.xmlWriter = xmlWriter;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating MTOMXMLStreamWriter");
            log.debug((Object)("OMFormat = " + format.toString()));
        }
        this.format = format;
    }

    private XmlHandler getHandler() {
        XMLStreamWriter xmlWriter = this.xmlWriter;
        if (xmlWriter instanceof PushOMDataSourceStreamWriter) {
            xmlWriter = ((PushOMDataSourceStreamWriter)xmlWriter).getParent();
        }
        if (xmlWriter instanceof XmlHandlerStreamWriter) {
            return ((XmlHandlerStreamWriter)xmlWriter).getHandler();
        }
        return null;
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string);
    }

    @Override
    public void writeStartElement(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string, string1);
    }

    @Override
    public void writeStartElement(String string, String string1, String string2) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string, string1, string2);
    }

    @Override
    public void writeEmptyElement(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeEmptyElement(string, string1);
    }

    @Override
    public void writeEmptyElement(String string, String string1, String string2) throws XMLStreamException {
        this.xmlWriter.writeEmptyElement(string, string1, string2);
    }

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        this.xmlWriter.writeEmptyElement(string);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.xmlWriter.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        log.debug((Object)"writeEndDocument");
        this.xmlWriter.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws XMLStreamException {
        log.debug((Object)"Calling MTOMXMLStreamWriter.flush");
        this.xmlWriter.flush();
    }

    @Override
    public void writeAttribute(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeAttribute(string, string1);
    }

    @Override
    public void writeAttribute(String string, String string1, String string2, String string3) throws XMLStreamException {
        this.xmlWriter.writeAttribute(string, string1, string2, string3);
    }

    @Override
    public void writeAttribute(String string, String string1, String string2) throws XMLStreamException {
        this.xmlWriter.writeAttribute(string, string1, string2);
    }

    @Override
    public void writeNamespace(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeNamespace(string, string1);
    }

    @Override
    public void writeDefaultNamespace(String string) throws XMLStreamException {
        this.xmlWriter.writeDefaultNamespace(string);
    }

    @Override
    public void writeComment(String string) throws XMLStreamException {
        this.xmlWriter.writeComment(string);
    }

    @Override
    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.xmlWriter.writeProcessingInstruction(string);
    }

    @Override
    public void writeProcessingInstruction(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeProcessingInstruction(string, string1);
    }

    @Override
    public void writeCData(String string) throws XMLStreamException {
        this.xmlWriter.writeCData(string);
    }

    @Override
    public void writeDTD(String string) throws XMLStreamException {
        this.xmlWriter.writeDTD(string);
    }

    @Override
    public void writeEntityRef(String string) throws XMLStreamException {
        this.xmlWriter.writeEntityRef(string);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.xmlWriter.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String string) throws XMLStreamException {
        this.xmlWriter.writeStartDocument(string);
    }

    @Override
    public void writeStartDocument(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeStartDocument(string, string1);
    }

    @Override
    public void writeCharacters(String string) throws XMLStreamException {
        this.xmlWriter.writeCharacters(string);
    }

    @Override
    public void writeCharacters(char[] chars, int i, int i1) throws XMLStreamException {
        this.xmlWriter.writeCharacters(chars, i, i1);
    }

    @Override
    public String getPrefix(String string) throws XMLStreamException {
        return this.xmlWriter.getPrefix(string);
    }

    @Override
    public void setPrefix(String string, String string1) throws XMLStreamException {
        this.xmlWriter.setPrefix(string, string1);
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.xmlWriter.setDefaultNamespace(string);
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.xmlWriter.setNamespaceContext(namespaceContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.xmlWriter.getNamespaceContext();
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        return this.xmlWriter.getProperty(string);
    }

    @Override
    public boolean isOptimized() {
        return this.format.isOptimized();
    }

    @Override
    public String prepareDataHandler(DataHandler dataHandler) {
        XmlHandler handler = this.getHandler();
        while (handler instanceof XmlHandlerWrapper) {
            if (handler instanceof XOPHandler) {
                return ((XOPHandler)((Object)handler)).prepareDataHandler(dataHandler);
            }
            handler = ((XmlHandlerWrapper)handler).getParent();
        }
        return this.format.getNextContentId();
    }

    @Override
    public String getCharSetEncoding() {
        return this.format.getCharSetEncoding();
    }

    @Override
    public OMOutputFormat getOutputFormat() {
        return this.format;
    }

    @Override
    public OutputStream getOutputStream() throws XMLStreamException {
        OutputStream outputStream;
        XmlHandler handler = this.getHandler();
        while (handler instanceof DocumentElementExtractingFilterHandler || handler instanceof NamespaceRepairingFilterHandler || handler instanceof XsiTypeFilterHandler || handler instanceof XmlDeclarationRewriterHandler || handler instanceof XOPEncodingFilterHandler) {
            handler = ((XmlHandlerWrapper)handler).getParent();
        }
        if (handler instanceof Serializer) {
            try {
                outputStream = ((Serializer)handler).getOutputStream();
            }
            catch (StreamException ex) {
                throw new XMLStreamException(ex);
            }
        } else {
            outputStream = null;
        }
        if (log.isDebugEnabled()) {
            if (outputStream == null) {
                log.debug((Object)"Direct access to the output stream is not available.");
            } else {
                log.debug((Object)("Returning access to the output stream: " + outputStream));
            }
        }
        return outputStream;
    }
}

