/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.factory.meta;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.common.builder.Detachable;

final class DetachableReader
extends Reader
implements Detachable {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private Reader target;

    DetachableReader(Reader target) {
        this.target = target;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return target.read(target);
    }

    @Override
    public int read() throws IOException {
        return this.target.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.target.read(cbuf);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.target.read(cbuf, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.target.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this.target.ready();
    }

    @Override
    public void close() throws IOException {
        this.target.close();
    }

    @Override
    public void detach() {
        MemoryBlob blob = Blobs.createMemoryBlob();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)blob.getOutputStream(), UTF8);
        char[] buffer = new char[2048];
        try {
            int c;
            while ((c = this.target.read(buffer)) != -1) {
                ((Writer)out).write(buffer, 0, c);
            }
            ((Writer)out).close();
        }
        catch (IOException ex) {
            throw new OMException(ex);
        }
        this.target = new InputStreamReader((InputStream)blob.readOnce(), UTF8);
    }
}

