/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.uri;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;

public final class URIUtil {
    private static final Pattern WINDOWS_FILE_PATTERN = Pattern.compile("(?:\\p{Alpha}:[\\\\/]|\\\\\\\\|//)");
    private static final URI EMPTYURI = URI.create("");

    public static URI resolve(URI baseURI, String reference) throws URISyntaxException {
        URI refURI;
        if (reference.isEmpty()) {
            return new URI(baseURI.getScheme(), baseURI.getSchemeSpecificPart(), null);
        }
        if (WINDOWS_FILE_PATTERN.matcher(reference).lookingAt()) {
            return new File(reference).toURI();
        }
        reference = reference.replace('\\', '/');
        try {
            refURI = new URI(reference);
        }
        catch (URISyntaxException e) {
            refURI = new URI(null, reference, null);
        }
        return baseURI.resolve(refURI);
    }

    public static Optional<Path> pathFromURI(String uriString) {
        if (uriString == null) {
            return Optional.empty();
        }
        try {
            URI uri = URIUtil.resolve(EMPTYURI, uriString);
            return URIUtil.pathFromURI(uriString, uri);
        }
        catch (URISyntaxException e1) {
            return Optional.empty();
        }
    }

    public static Optional<Path> pathFromURI(URI uri) {
        if (uri == null) {
            return Optional.empty();
        }
        return URIUtil.pathFromURI(uri.getSchemeSpecificPart(), uri);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<Path> pathFromURI(String uriString, URI uri) {
        try {
            block16: while (!EMPTYURI.equals(uri)) {
                String scheme = uri.getScheme();
                if (scheme == null) {
                    try {
                        return Optional.of(Paths.get(uriString, new String[0]));
                    }
                    catch (InvalidPathException e) {
                        return Optional.empty();
                    }
                }
                switch (scheme.toLowerCase(Locale.ROOT)) {
                    case "file": {
                        return Optional.of(Paths.get(uri));
                    }
                    case "jar": 
                    case "bundle": 
                    case "zip": {
                        uriString = uri.getSchemeSpecificPart();
                        int index = uriString.indexOf("!/");
                        if (index >= 0) {
                            uriString = uriString.substring(0, index);
                        }
                        uri = URIUtil.resolve(EMPTYURI, uriString);
                        continue block16;
                    }
                    case "reference": {
                        uriString = uri.getSchemeSpecificPart();
                        uri = URIUtil.resolve(EMPTYURI, uriString);
                        continue block16;
                    }
                }
                uriString = uri.getSchemeSpecificPart();
                if ((uri = new URI(uriString)).getScheme() == null) return Optional.empty();
            }
            return Optional.empty();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static boolean isRemote(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            return false;
        }
        switch (scheme.toLowerCase(Locale.ROOT)) {
            case "file": 
            case "jar": 
            case "data": {
                return false;
            }
        }
        return true;
    }

    public static int getDefaultPort(String scheme) {
        switch (scheme) {
            case "http": {
                return 80;
            }
            case "https": {
                return 443;
            }
            case "ftp": {
                return 20;
            }
        }
        return -1;
    }

    public static String encodePath(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        byte[] bytes = path.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        byte[] encoded = new byte[length * 3];
        int i = 0;
        for (byte b : bytes) {
            if (URIUtil.isPathAllowed(b)) {
                encoded[i++] = b;
                continue;
            }
            encoded[i++] = 37;
            encoded[i++] = (byte)Character.forDigit(b >> 4 & 0xF, 16);
            encoded[i++] = (byte)Character.forDigit(b & 0xF, 16);
        }
        if (i > length) {
            return new String(encoded, 0, i, StandardCharsets.UTF_8);
        }
        return path;
    }

    static boolean isPathAllowed(int b) {
        switch (b) {
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 61: 
            case 64: 
            case 95: 
            case 126: {
                return true;
            }
        }
        return URIUtil.isAlphanum(b);
    }

    static boolean isAlphanum(int b) {
        return b >= 48 && b <= 57 || b >= 97 && b <= 122 || b >= 65 && b <= 90;
    }

    public static String decode(String source) {
        if (source == null || source.isEmpty()) {
            return source;
        }
        int length = source.length();
        byte[] decoded = new byte[length];
        int i = 0;
        for (int j = 0; j < length; ++j) {
            char c = source.charAt(j);
            decoded[i++] = c == '%' ? (byte)(Character.digit(source.charAt(++j), 16) << 4 | Character.digit(source.charAt(++j), 16)) : (byte)c;
        }
        if (i < length) {
            return new String(decoded, 0, i, StandardCharsets.UTF_8);
        }
        return source;
    }
}

