/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.transport.BytesTransportRequest;
import org.elasticsearch.transport.CompressibleBytesOutputStream;
import org.elasticsearch.transport.NetworkMessage;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TcpHeader;
import org.elasticsearch.transport.TransportStatus;

abstract class OutboundMessage
extends NetworkMessage
implements Writeable {
    private final Writeable message;

    OutboundMessage(ThreadContext threadContext, Version version, byte status, long requestId, Writeable message) {
        super(threadContext, version, status, requestId);
        this.message = message;
    }

    BytesReference serialize(BytesStreamOutput bytesStream) throws IOException {
        BytesReference reference;
        this.storedContext.restore();
        bytesStream.setVersion(this.version);
        bytesStream.skip(19);
        try (CompressibleBytesOutputStream stream = new CompressibleBytesOutputStream(bytesStream, TransportStatus.isCompress(this.status));){
            stream.setVersion(this.version);
            this.threadContext.writeTo(stream);
            this.writeTo(stream);
            reference = this.writeMessage(stream);
        }
        bytesStream.seek(0L);
        TcpHeader.writeHeader(bytesStream, this.requestId, this.status, this.version, reference.length() - 19);
        return reference;
    }

    private BytesReference writeMessage(CompressibleBytesOutputStream stream) throws IOException {
        BytesReference zeroCopyBuffer;
        if (this.message instanceof BytesTransportRequest) {
            BytesTransportRequest bRequest = (BytesTransportRequest)this.message;
            bRequest.writeThin(stream);
            zeroCopyBuffer = bRequest.bytes;
        } else if (this.message instanceof RemoteTransportException) {
            stream.writeException((RemoteTransportException)this.message);
            zeroCopyBuffer = BytesArray.EMPTY;
        } else {
            this.message.writeTo(stream);
            zeroCopyBuffer = BytesArray.EMPTY;
        }
        BytesReference message = stream.materializeBytes();
        if (zeroCopyBuffer.length() == 0) {
            return message;
        }
        return new CompositeBytesReference(message, zeroCopyBuffer);
    }

    private static boolean canCompress(Writeable message) {
        return !(message instanceof BytesTransportRequest);
    }

    static class Response
    extends OutboundMessage {
        private final Set<String> features;

        Response(ThreadContext threadContext, Set<String> features, Writeable message, Version version, long requestId, boolean isHandshake, boolean compress) {
            super(threadContext, version, Response.setStatus(compress, isHandshake, message), requestId, message);
            this.features = features;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.setFeatures(this.features);
        }

        private static byte setStatus(boolean compress, boolean isHandshake, Writeable message) {
            byte status = 0;
            status = TransportStatus.setResponse(status);
            if (message instanceof RemoteTransportException) {
                status = TransportStatus.setError(status);
            }
            if (compress) {
                status = TransportStatus.setCompress(status);
            }
            if (isHandshake) {
                status = TransportStatus.setHandshake(status);
            }
            return status;
        }
    }

    static class Request
    extends OutboundMessage {
        private final String[] features;
        private final String action;

        Request(ThreadContext threadContext, String[] features, Writeable message, Version version, String action, long requestId, boolean isHandshake, boolean compress) {
            super(threadContext, version, Request.setStatus(compress, isHandshake, message), requestId, message);
            this.features = features;
            this.action = action;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.version.onOrAfter(Version.V_6_3_0)) {
                out.writeStringArray(this.features);
            }
            out.writeString(this.action);
        }

        private static byte setStatus(boolean compress, boolean isHandshake, Writeable message) {
            byte status = 0;
            status = TransportStatus.setRequest(status);
            if (compress && OutboundMessage.canCompress(message)) {
                status = TransportStatus.setCompress(status);
            }
            if (isHandshake) {
                status = TransportStatus.setHandshake(status);
            }
            return status;
        }
    }
}

