/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.metadata;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import shaded.org.eclipse.aether.metadata.DefaultMetadata;
import shaded.org.eclipse.aether.metadata.Metadata;

public abstract class AbstractMetadata
implements Metadata {
    private Metadata newInstance(Map<String, String> properties, File file) {
        return new DefaultMetadata(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getType(), this.getNature(), file, properties);
    }

    @Override
    public Metadata setFile(File file) {
        File current = this.getFile();
        if (current == null ? file == null : current.equals(file)) {
            return this;
        }
        return this.newInstance(this.getProperties(), file);
    }

    @Override
    public Metadata setProperties(Map<String, String> properties) {
        Map<String, String> current = this.getProperties();
        if (current.equals(properties) || properties == null && current.isEmpty()) {
            return this;
        }
        return this.newInstance(AbstractMetadata.copyProperties(properties), this.getFile());
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperties().get(key);
        return value != null ? value : defaultValue;
    }

    protected static Map<String, String> copyProperties(Map<String, String> properties) {
        if (properties != null && !properties.isEmpty()) {
            return Collections.unmodifiableMap(new HashMap<String, String>(properties));
        }
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        if (this.getGroupId().length() > 0) {
            buffer.append(this.getGroupId());
        }
        if (this.getArtifactId().length() > 0) {
            buffer.append(':').append(this.getArtifactId());
        }
        if (this.getVersion().length() > 0) {
            buffer.append(':').append(this.getVersion());
        }
        buffer.append('/').append(this.getType());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)obj;
        return this.getArtifactId().equals(that.getArtifactId()) && this.getGroupId().equals(that.getGroupId()) && this.getVersion().equals(that.getVersion()) && this.getType().equals(that.getType()) && this.getNature().equals((Object)that.getNature()) && AbstractMetadata.eq(this.getFile(), that.getFile()) && AbstractMetadata.eq(this.getProperties(), that.getProperties());
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.getGroupId().hashCode();
        hash = hash * 31 + this.getArtifactId().hashCode();
        hash = hash * 31 + this.getType().hashCode();
        hash = hash * 31 + this.getNature().hashCode();
        hash = hash * 31 + this.getVersion().hashCode();
        hash = hash * 31 + AbstractMetadata.hash(this.getFile());
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

