/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_component.CasProcessor;
import org.apache.uima.analysis_component.CasProcessorAnnotator;
import org.apache.uima.analysis_component.JCasProcessor;
import org.apache.uima.analysis_component.JCasProcessorAnnotator;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.impl.AggregateAnalysisEngine_impl;
import org.apache.uima.analysis_engine.impl.AnalysisEngineDescription_impl;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.analysis_engine.metadata.FlowControllerDeclaration;
import org.apache.uima.analysis_engine.metadata.SofaMapping;
import org.apache.uima.analysis_engine.metadata.impl.FixedFlow_impl;
import org.apache.uima.analysis_engine.metadata.impl.FlowControllerDeclaration_impl;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.CapabilityFactory;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.fit.factory.ExternalResourceFactory;
import org.apache.uima.fit.factory.FsIndexFactory;
import org.apache.uima.fit.factory.ResourceCreationSpecifierFactory;
import org.apache.uima.fit.factory.ResourceMetaDataFactory;
import org.apache.uima.fit.factory.TypePrioritiesFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.internal.ReflectionUtil;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.PearSpecifier;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;

public final class AnalysisEngineFactory {
    private AnalysisEngineFactory() {
    }

    public static AnalysisEngine createEngine(String descriptorName, Object ... configurationData) throws InvalidXMLException, IOException, ResourceInitializationException {
        AnalysisEngineDescription aed = AnalysisEngineFactory.createEngineDescription(descriptorName, configurationData);
        return UIMAFramework.produceAnalysisEngine((ResourceSpecifier)aed, (ResourceManager)ResourceManagerFactory.newResourceManager(), null);
    }

    @Deprecated
    public static AnalysisEngine createAnalysisEngine(String descriptorName, Object ... configurationData) throws InvalidXMLException, IOException, ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(descriptorName, configurationData);
    }

    public static AnalysisEngine createEngine(AnalysisEngineDescription analysisEngineDescription, String viewName) throws ResourceInitializationException {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(analysisEngineDescription, "_InitialView", viewName);
        return builder.createAggregate();
    }

    @Deprecated
    public static AnalysisEngine createAnalysisEngine(AnalysisEngineDescription analysisEngineDescription, String viewName) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(analysisEngineDescription, viewName);
    }

    public static AnalysisEngine createEngine(AnalysisEngineDescription desc, Object ... configurationData) throws ResourceInitializationException {
        if (configurationData == null || configurationData.length == 0) {
            return UIMAFramework.produceAnalysisEngine((ResourceSpecifier)desc, (ResourceManager)ResourceManagerFactory.newResourceManager(), null);
        }
        AnalysisEngineDescription descClone = (AnalysisEngineDescription)desc.clone();
        ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceCreationSpecifier)descClone, configurationData);
        return UIMAFramework.produceAnalysisEngine((ResourceSpecifier)descClone, (ResourceManager)ResourceManagerFactory.newResourceManager(), null);
    }

    @Deprecated
    public static AnalysisEngine createAggregate(AnalysisEngineDescription desc) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(desc, new Object[0]);
    }

    @Deprecated
    public static AnalysisEngine createPrimitive(AnalysisEngineDescription desc, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(desc, configurationData);
    }

    public static AnalysisEngine createEngine(Class<? extends AnalysisComponent> componentClass, Object ... configurationData) throws ResourceInitializationException {
        AnalysisEngineDescription desc = AnalysisEngineFactory.createEngineDescription(componentClass, configurationData);
        return AnalysisEngineFactory.createEngine(desc, new Object[0]);
    }

    @Deprecated
    public static AnalysisEngine createPrimitive(Class<? extends AnalysisComponent> componentClass, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(componentClass, configurationData);
    }

    public static AnalysisEngine createEngine(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(componentClass, typeSystem, (TypePriorities)null, configurationData);
    }

    @Deprecated
    public static AnalysisEngine createPrimitive(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(componentClass, typeSystem, configurationData);
    }

    public static AnalysisEngine createEngine(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, String[] typePriorities, Object ... configurationData) throws ResourceInitializationException {
        TypePriorities tp = null;
        if (typePriorities != null) {
            tp = TypePrioritiesFactory.createTypePriorities(typePriorities);
        }
        return AnalysisEngineFactory.createEngine(componentClass, typeSystem, tp, configurationData);
    }

    @Deprecated
    public static AnalysisEngine createPrimitive(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, String[] typePriorities, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(componentClass, typeSystem, typePriorities, configurationData);
    }

    public static AnalysisEngine createEngine(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, Object ... configurationData) throws ResourceInitializationException {
        AnalysisEngineDescription desc = AnalysisEngineFactory.createEngineDescription(componentClass, typeSystem, typePriorities, configurationData);
        return AnalysisEngineFactory.createEngine(desc, new Object[0]);
    }

    @Deprecated
    public static AnalysisEngine createPrimitive(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(componentClass, typeSystem, typePriorities, configurationData);
    }

    public static AnalysisEngine createEngine(List<Class<? extends AnalysisComponent>> componentClasses, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, Object ... configurationData) throws ResourceInitializationException {
        AnalysisEngineDescription desc = AnalysisEngineFactory.createEngineDescription(componentClasses, typeSystem, typePriorities, sofaMappings, configurationData);
        AggregateAnalysisEngine_impl engine = new AggregateAnalysisEngine_impl();
        engine.initialize((ResourceSpecifier)desc, null);
        return engine;
    }

    @Deprecated
    public static AnalysisEngine createAggregate(List<Class<? extends AnalysisComponent>> componentClasses, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(componentClasses, typeSystem, typePriorities, sofaMappings, configurationData);
    }

    public static AnalysisEngine createEngine(List<Class<? extends AnalysisComponent>> componentClasses, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, FlowControllerDescription flowControllerDescription, Object ... configurationData) throws ResourceInitializationException {
        AnalysisEngineDescription desc = AnalysisEngineFactory.createEngineDescription(componentClasses, typeSystem, typePriorities, sofaMappings, configurationData, flowControllerDescription);
        AggregateAnalysisEngine_impl engine = new AggregateAnalysisEngine_impl();
        engine.initialize((ResourceSpecifier)desc, null);
        return engine;
    }

    @Deprecated
    public static AnalysisEngine createAggregate(List<Class<? extends AnalysisComponent>> componentClasses, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, FlowControllerDescription flowControllerDescription, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(componentClasses, typeSystem, typePriorities, sofaMappings, flowControllerDescription, configurationData);
    }

    public static AnalysisEngine createEngine(List<AnalysisEngineDescription> analysisEngineDescriptions, List<String> componentNames, TypePriorities typePriorities, SofaMapping[] sofaMappings) throws ResourceInitializationException {
        AnalysisEngineDescription desc = AnalysisEngineFactory.createEngineDescription(analysisEngineDescriptions, componentNames, typePriorities, sofaMappings, null);
        AggregateAnalysisEngine_impl engine = new AggregateAnalysisEngine_impl();
        engine.initialize((ResourceSpecifier)desc, null);
        return engine;
    }

    @Deprecated
    public static AnalysisEngine createAggregate(List<AnalysisEngineDescription> analysisEngineDescriptions, List<String> componentNames, TypePriorities typePriorities, SofaMapping[] sofaMappings) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(analysisEngineDescriptions, componentNames, typePriorities, sofaMappings);
    }

    public static AnalysisEngine createEngine(List<AnalysisEngineDescription> analysisEngineDescriptions, List<String> componentNames, TypePriorities typePriorities, SofaMapping[] sofaMappings, FlowControllerDescription flowControllerDescription) throws ResourceInitializationException {
        AnalysisEngineDescription desc = AnalysisEngineFactory.createEngineDescription(analysisEngineDescriptions, componentNames, typePriorities, sofaMappings, flowControllerDescription);
        AggregateAnalysisEngine_impl engine = new AggregateAnalysisEngine_impl();
        engine.initialize((ResourceSpecifier)desc, null);
        return engine;
    }

    @Deprecated
    public static AnalysisEngine createAggregate(List<AnalysisEngineDescription> analysisEngineDescriptions, List<String> componentNames, TypePriorities typePriorities, SofaMapping[] sofaMappings, FlowControllerDescription flowControllerDescription) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(analysisEngineDescriptions, componentNames, typePriorities, sofaMappings, flowControllerDescription);
    }

    public static AnalysisEngine createEngineFromPath(String descriptorPath, Object ... configurationData) throws InvalidXMLException, IOException, ResourceInitializationException {
        AnalysisEngineDescription desc = AnalysisEngineFactory.createEngineDescriptionFromPath(descriptorPath, configurationData);
        return UIMAFramework.produceAnalysisEngine((ResourceSpecifier)desc, (ResourceManager)ResourceManagerFactory.newResourceManager(), null);
    }

    @Deprecated
    public static AnalysisEngine createAnalysisEngineFromPath(String descriptorPath, Object ... configurationData) throws InvalidXMLException, IOException, ResourceInitializationException {
        return AnalysisEngineFactory.createEngineFromPath(descriptorPath, configurationData);
    }

    public static AnalysisEngineDescription createEngineDescriptionFromPath(String descriptorPath, Object ... configurationData) throws InvalidXMLException, IOException {
        ResourceCreationSpecifier specifier = ResourceCreationSpecifierFactory.createResourceCreationSpecifier(descriptorPath, configurationData);
        return (AnalysisEngineDescription)specifier;
    }

    public static AnalysisEngineDescription createEngineDescription(PearSpecifier pearSpecifier, Object ... configurationData) throws InvalidXMLException, IOException {
        ConfigurationParameterFactory.ensureParametersComeInPairs(configurationData);
        if (configurationData != null) {
            for (int i = 0; i < configurationData.length / 2; ++i) {
                String name = (String)configurationData[i * 2];
                String value = (String)configurationData[i * 2 + 1];
                ConfigurationParameterFactory.setParameter((ResourceSpecifier)pearSpecifier, name, value);
            }
        }
        AnalysisEngineDescription_impl desc = new AnalysisEngineDescription_impl();
        desc.setFrameworkImplementation("org.apache.uima.java");
        desc.setPrimitive(false);
        desc.getDelegateAnalysisEngineSpecifiersWithImports().put(pearSpecifier.getPearPath(), pearSpecifier);
        FixedFlow_impl fixedFlow = new FixedFlow_impl();
        fixedFlow.setFixedFlow(new String[]{pearSpecifier.getPearPath()});
        desc.getAnalysisEngineMetaData().setFlowConstraints((FlowConstraints)fixedFlow);
        return desc;
    }

    @Deprecated
    public static AnalysisEngineDescription createAnalysisEngineDescriptionFromPath(String descriptorPath, Object ... configurationData) throws InvalidXMLException, IOException {
        return AnalysisEngineFactory.createEngineDescriptionFromPath(descriptorPath, configurationData);
    }

    public static AnalysisEngineDescription createEngineDescription(String descriptorName, Object ... configurationData) throws InvalidXMLException, IOException {
        URL url;
        Import_impl imprt = new Import_impl();
        imprt.setName(descriptorName);
        try {
            url = imprt.findAbsoluteUrl(ResourceManagerFactory.newResourceManager());
        }
        catch (ResourceInitializationException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        ResourceCreationSpecifier specifier = ResourceCreationSpecifierFactory.createResourceCreationSpecifier(url, configurationData);
        return (AnalysisEngineDescription)specifier;
    }

    @Deprecated
    public static AnalysisEngineDescription createAnalysisEngineDescription(String descriptorName, Object ... configurationData) throws InvalidXMLException, IOException {
        return AnalysisEngineFactory.createEngineDescription(descriptorName, configurationData);
    }

    public static AnalysisEngineDescription createEngineDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(componentClass, typeSystem, (TypePriorities)null, configurationData);
    }

    @Deprecated
    public static AnalysisEngineDescription createPrimitiveDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(componentClass, typeSystem, configurationData);
    }

    public static AnalysisEngineDescription createEngineDescription(Class<? extends AnalysisComponent> componentClass, Object ... configurationData) throws ResourceInitializationException {
        TypeSystemDescription typeSystem = TypeSystemDescriptionFactory.createTypeSystemDescription();
        TypePriorities typePriorities = TypePrioritiesFactory.createTypePriorities();
        FsIndexCollection fsIndexCollection = FsIndexFactory.createFsIndexCollection();
        return AnalysisEngineFactory.createEngineDescription(componentClass, typeSystem, typePriorities, fsIndexCollection, (Capability[])null, configurationData);
    }

    @Deprecated
    public static AnalysisEngineDescription createPrimitiveDescription(Class<? extends AnalysisComponent> componentClass, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(componentClass, configurationData);
    }

    public static AnalysisEngineDescription createEngineDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(componentClass, typeSystem, typePriorities, (FsIndexCollection)null, (Capability[])null, configurationData);
    }

    @Deprecated
    public static AnalysisEngineDescription createPrimitiveDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(componentClass, typeSystem, typePriorities, configurationData);
    }

    public static AnalysisEngineDescription createEngineDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, FsIndexCollection indexes, Capability[] capabilities, Object ... configurationData) throws ResourceInitializationException {
        ConfigurationParameterFactory.ensureParametersComeInPairs(configurationData);
        Map<String, ExternalResourceDescription> externalResources = ExternalResourceFactory.extractResourceParameters(configurationData);
        ConfigurationParameterFactory.ConfigurationData cdata = ConfigurationParameterFactory.createConfigurationData(configurationData);
        return AnalysisEngineFactory.createEngineDescription(componentClass, typeSystem, typePriorities, indexes, capabilities, cdata.configurationParameters, cdata.configurationValues, externalResources);
    }

    @Deprecated
    public static AnalysisEngineDescription createPrimitiveDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, FsIndexCollection indexes, Capability[] capabilities, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(componentClass, typeSystem, typePriorities, indexes, capabilities, configurationData);
    }

    public static AnalysisEngineDescription createEngineDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, FsIndexCollection indexes, Capability[] capabilities, ConfigurationParameter[] configurationParameters, Object[] configurationValues) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(componentClass, typeSystem, typePriorities, indexes, capabilities, configurationParameters, configurationValues, null);
    }

    @Deprecated
    public static AnalysisEngineDescription createPrimitiveDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, FsIndexCollection indexes, Capability[] capabilities, ConfigurationParameter[] configurationParameters, Object[] configurationValues) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(componentClass, typeSystem, typePriorities, indexes, capabilities, configurationParameters, configurationValues);
    }

    public static AnalysisEngineDescription createEngineDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, FsIndexCollection indexes, Capability[] capabilities, ConfigurationParameter[] configurationParameters, Object[] configurationValues, Map<String, ExternalResourceDescription> externalResources) throws ResourceInitializationException {
        AnalysisEngineDescription desc = UIMAFramework.getResourceSpecifierFactory().createAnalysisEngineDescription();
        desc.setFrameworkImplementation("org.apache.uima.java");
        desc.setPrimitive(true);
        desc.setAnnotatorImplementationName(componentClass.getName());
        OperationalProperties componentAnno = ReflectionUtil.getInheritableAnnotation(OperationalProperties.class, componentClass);
        if (componentAnno != null) {
            op = desc.getAnalysisEngineMetaData().getOperationalProperties();
            op.setMultipleDeploymentAllowed(componentAnno.multipleDeploymentAllowed());
            op.setModifiesCas(componentAnno.modifiesCas());
            op.setOutputsNewCASes(componentAnno.outputsNewCases());
        } else {
            op = desc.getAnalysisEngineMetaData().getOperationalProperties();
            op.setMultipleDeploymentAllowed(true);
            op.setModifiesCas(true);
            op.setOutputsNewCASes(false);
        }
        AnalysisEngineMetaData meta = desc.getAnalysisEngineMetaData();
        ResourceMetaDataFactory.configureResourceMetaData((ResourceMetaData)meta, componentClass);
        ConfigurationParameterFactory.setParameters((ResourceCreationSpecifier)desc, componentClass, configurationParameters, configurationValues);
        if (typeSystem != null) {
            desc.getAnalysisEngineMetaData().setTypeSystem(typeSystem);
        }
        if (typePriorities != null) {
            desc.getAnalysisEngineMetaData().setTypePriorities(typePriorities);
        }
        ArrayList<FsIndexCollection> fsIndexes = new ArrayList<FsIndexCollection>();
        if (indexes != null) {
            fsIndexes.add(indexes);
        }
        fsIndexes.add(FsIndexFactory.createFsIndexCollection(componentClass));
        FsIndexCollection aggIndexColl = CasCreationUtils.mergeFsIndexes(fsIndexes, (ResourceManager)ResourceManagerFactory.newResourceManager());
        desc.getAnalysisEngineMetaData().setFsIndexCollection(aggIndexColl);
        if (capabilities != null) {
            desc.getAnalysisEngineMetaData().setCapabilities(capabilities);
        } else {
            Capability capability = CapabilityFactory.createCapability(componentClass);
            if (capability != null) {
                desc.getAnalysisEngineMetaData().setCapabilities(new Capability[]{capability});
            }
        }
        desc.setExternalResourceDependencies(ExternalResourceFactory.createResourceDependencies(componentClass));
        if (externalResources != null) {
            for (Map.Entry<String, ExternalResourceDescription> e : externalResources.entrySet()) {
                ExternalResourceFactory.bindResourceOnce((ResourceCreationSpecifier)desc, e.getKey(), e.getValue());
            }
        }
        return desc;
    }

    @Deprecated
    public static AnalysisEngineDescription createPrimitiveDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, FsIndexCollection indexes, Capability[] capabilities, ConfigurationParameter[] configurationParameters, Object[] configurationValues, Map<String, ExternalResourceDescription> externalResources) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(componentClass, typeSystem, typePriorities, indexes, capabilities, configurationParameters, configurationValues, externalResources);
    }

    public static AnalysisEngineDescription createEngineDescription(List<Class<? extends AnalysisComponent>> componentClasses, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, Object ... configurationData) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> primitiveEngineDescriptions = new ArrayList<AnalysisEngineDescription>();
        ArrayList<String> componentNames = new ArrayList<String>();
        for (Class<? extends AnalysisComponent> componentClass : componentClasses) {
            AnalysisEngineDescription primitiveDescription = AnalysisEngineFactory.createEngineDescription(componentClass, typeSystem, typePriorities, configurationData);
            primitiveEngineDescriptions.add(primitiveDescription);
            componentNames.add(componentClass.getName());
        }
        return AnalysisEngineFactory.createEngineDescription(primitiveEngineDescriptions, componentNames, typePriorities, sofaMappings, null);
    }

    @Deprecated
    public static AnalysisEngineDescription createAggregateDescription(List<Class<? extends AnalysisComponent>> componentClasses, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(componentClasses, typeSystem, typePriorities, sofaMappings, configurationData);
    }

    public static AnalysisEngineDescription createEngineDescription(AnalysisEngineDescription ... analysisEngineDescriptions) throws ResourceInitializationException {
        String[] names = new String[analysisEngineDescriptions.length];
        int i = 0;
        for (AnalysisEngineDescription aed : analysisEngineDescriptions) {
            names[i] = AnalysisEngineFactory.generateDelegateKey(aed, i);
            ++i;
        }
        return AnalysisEngineFactory.createEngineDescription(Arrays.asList(analysisEngineDescriptions), Arrays.asList(names), null, null, null);
    }

    static String generateDelegateKey(AnalysisEngineDescription aAed, int aIndex) {
        String sanitizedName;
        if (aAed.getMetaData() != null && (sanitizedName = AnalysisEngineFactory.sanitizeDelegateKey(aAed.getMetaData().getName())) != null) {
            return sanitizedName + "-" + aIndex;
        }
        if (aAed.isPrimitive()) {
            return aAed.getImplementationName() + "-" + aIndex;
        }
        return "aggregate-" + aIndex;
    }

    static String sanitizeDelegateKey(String name) {
        if (name == null) {
            return null;
        }
        String trimmedName = name.trim();
        if (trimmedName.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < trimmedName.length(); ++i) {
            char c = trimmedName.charAt(i);
            if (Character.isWhitespace(c) || c == '_') {
                if (buf.length() <= 0 || buf.charAt(buf.length() - 1) == '_') continue;
                buf.append('_');
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) {
                return null;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    @Deprecated
    public static AnalysisEngineDescription createAggregateDescription(AnalysisEngineDescription ... analysisEngineDescriptions) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(analysisEngineDescriptions);
    }

    public static AnalysisEngineDescription createEngineDescription(List<Class<? extends AnalysisComponent>> componentClasses, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, FlowControllerDescription flowControllerDescription, Object ... configurationData) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> primitiveEngineDescriptions = new ArrayList<AnalysisEngineDescription>();
        ArrayList<String> componentNames = new ArrayList<String>();
        for (Class<? extends AnalysisComponent> componentClass : componentClasses) {
            AnalysisEngineDescription primitiveDescription = AnalysisEngineFactory.createEngineDescription(componentClass, typeSystem, typePriorities, configurationData);
            primitiveEngineDescriptions.add(primitiveDescription);
            componentNames.add(componentClass.getName());
        }
        return AnalysisEngineFactory.createEngineDescription(primitiveEngineDescriptions, componentNames, typePriorities, sofaMappings, flowControllerDescription);
    }

    @Deprecated
    public static AnalysisEngineDescription createAggregateDescription(List<Class<? extends AnalysisComponent>> componentClasses, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, FlowControllerDescription flowControllerDescription, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(componentClasses, typeSystem, typePriorities, sofaMappings, flowControllerDescription, configurationData);
    }

    public static AnalysisEngineDescription createEngineDescription(FlowControllerDescription flowControllerDescription, AnalysisEngineDescription ... analysisEngineDescriptions) throws ResourceInitializationException {
        String[] names = new String[analysisEngineDescriptions.length];
        int i = 0;
        for (AnalysisEngineDescription aed : analysisEngineDescriptions) {
            names[i] = aed.getImplementationName() + "-" + i;
            ++i;
        }
        return AnalysisEngineFactory.createEngineDescription(Arrays.asList(analysisEngineDescriptions), Arrays.asList(names), null, null, flowControllerDescription);
    }

    @Deprecated
    public static AnalysisEngineDescription createAggregateDescription(FlowControllerDescription flowControllerDescription, AnalysisEngineDescription ... analysisEngineDescriptions) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(flowControllerDescription, analysisEngineDescriptions);
    }

    public static AnalysisEngineDescription createEngineDescription(List<AnalysisEngineDescription> analysisEngineDescriptions, List<String> componentNames, TypePriorities typePriorities, SofaMapping[] sofaMappings, FlowControllerDescription flowControllerDescription) throws ResourceInitializationException {
        if (componentNames == null) {
            throw new IllegalArgumentException("Parameter [componentNames] cannot be null");
        }
        if (analysisEngineDescriptions == null) {
            throw new IllegalArgumentException("Parameter [analysisEngineDescriptions] cannot be null");
        }
        if (analysisEngineDescriptions.size() != componentNames.size()) {
            throw new IllegalArgumentException("Number of descriptions [" + analysisEngineDescriptions.size() + "]does not match number of component names [" + componentNames.size() + "].");
        }
        AnalysisEngineDescription_impl desc = new AnalysisEngineDescription_impl();
        desc.setFrameworkImplementation("org.apache.uima.java");
        desc.setPrimitive(false);
        boolean allowMultipleDeploy = true;
        for (AnalysisEngineDescription d : analysisEngineDescriptions) {
            allowMultipleDeploy &= d.getAnalysisEngineMetaData().getOperationalProperties().isMultipleDeploymentAllowed();
        }
        desc.getAnalysisEngineMetaData().getOperationalProperties().setMultipleDeploymentAllowed(allowMultipleDeploy);
        ArrayList<String> flowNames = new ArrayList<String>();
        for (int i = 0; i < analysisEngineDescriptions.size(); ++i) {
            AnalysisEngineDescription aed = analysisEngineDescriptions.get(i);
            String componentName = componentNames.get(i);
            desc.getDelegateAnalysisEngineSpecifiersWithImports().put(componentName, aed);
            flowNames.add(componentName);
        }
        if (flowControllerDescription != null) {
            FlowControllerDeclaration_impl flowControllerDeclaration = new FlowControllerDeclaration_impl();
            flowControllerDeclaration.setSpecifier((ResourceSpecifier)flowControllerDescription);
            desc.setFlowControllerDeclaration((FlowControllerDeclaration)flowControllerDeclaration);
        }
        FixedFlow_impl fixedFlow = new FixedFlow_impl();
        fixedFlow.setFixedFlow(flowNames.toArray(new String[flowNames.size()]));
        desc.getAnalysisEngineMetaData().setFlowConstraints((FlowConstraints)fixedFlow);
        if (typePriorities != null) {
            desc.getAnalysisEngineMetaData().setTypePriorities(typePriorities);
        }
        if (sofaMappings != null) {
            desc.setSofaMappings(sofaMappings);
        }
        return desc;
    }

    @Deprecated
    public static AnalysisEngineDescription createAggregateDescription(List<AnalysisEngineDescription> analysisEngineDescriptions, List<String> componentNames, TypePriorities typePriorities, SofaMapping[] sofaMappings, FlowControllerDescription flowControllerDescription) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(analysisEngineDescriptions, componentNames, typePriorities, sofaMappings, flowControllerDescription);
    }

    public static AnalysisEngine createEngine(JCasProcessor<? extends Exception> aJCasAnnotator) throws ResourceInitializationException {
        return JCasProcessorAnnotator.of(aJCasAnnotator);
    }

    public static AnalysisEngine createEngine(CasProcessor<? extends Exception> aCasAnnotator) throws ResourceInitializationException {
        return CasProcessorAnnotator.of(aCasAnnotator);
    }
}

