/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.cache;

import org.apache.fulcrum.cache.CachedObject;
import org.apache.fulcrum.cache.Refreshable;

public class RefreshableCachedObject<T extends Refreshable>
extends CachedObject<T> {
    private static final long serialVersionUID = 4072572956381768087L;
    private long timeToLive = -1L;
    private long lastAccess;

    public RefreshableCachedObject(T object) {
        super(object);
        this.setLastAccess(System.currentTimeMillis());
    }

    public RefreshableCachedObject(T object, long expires) {
        super(object, expires);
        this.setLastAccess(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTTL(long timeToLive) {
        RefreshableCachedObject refreshableCachedObject = this;
        synchronized (refreshableCachedObject) {
            this.timeToLive = timeToLive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTTL() {
        RefreshableCachedObject refreshableCachedObject = this;
        synchronized (refreshableCachedObject) {
            return this.timeToLive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        RefreshableCachedObject refreshableCachedObject = this;
        synchronized (refreshableCachedObject) {
            this.lastAccess = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUntouched() {
        boolean untouched = false;
        RefreshableCachedObject refreshableCachedObject = this;
        synchronized (refreshableCachedObject) {
            if (this.lastAccess + this.timeToLive < System.currentTimeMillis()) {
                untouched = true;
            }
            return untouched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Refreshable refreshable = (Refreshable)this.getContents();
        RefreshableCachedObject refreshableCachedObject = this;
        synchronized (refreshableCachedObject) {
            this.created = System.currentTimeMillis();
            refreshable.refresh();
        }
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }
}

