/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.tez.common;

import org.apache.hadoop.classification.InterfaceAudience.Public;
import org.apache.hadoop.classification.InterfaceStability.Unstable;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.serviceplugins.api.ContainerLauncher;
import org.apache.tez.serviceplugins.api.ContainerLauncherContext;

import java.util.Set;

/**
 * Plugin to allow custom container launchers to be written to launch containers that want to
 * support cleanup of DAG level directories upon DAG completion in session mode. The directories are created by
 * the Tez Shuffle Handler (tez_shuffle). A typical implementation of dagComplete() method would contain logic to send
 * http request(s) for dag deletion to the nodes that support this auxiliary service.
 */
@Public
@Unstable
public abstract class DagContainerLauncher extends ContainerLauncher {

  public DagContainerLauncher(ContainerLauncherContext containerLauncherContext) {
    super(containerLauncherContext);
  }

  public abstract void dagComplete(TezDAGID dag, JobTokenSecretManager jobTokenSecretManager);

  public abstract void vertexComplete(TezVertexID vertex, JobTokenSecretManager jobTokenSecretManager,
                                      Set<NodeId> nodeIdList);

  public abstract void taskAttemptFailed(TezTaskAttemptID taskAttemptID,
                                         JobTokenSecretManager jobTokenSecretManager, NodeId nodeId);
}
