/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinator$;
import kafka.coordinator.group.GroupCoordinatorAdapter;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.LeaveGroupResult;
import kafka.coordinator.group.LeaveMemberResponse;
import kafka.coordinator.group.MemberSummary;
import kafka.coordinator.group.SyncGroupResult;
import kafka.server.RequestLocal;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001B\n\u0015\u0001mAQA\t\u0001\u0005\u0002\rBQA\n\u0001\u0005\n\u001dBQA\u0011\u0001\u0005\u0002\rCQA\u0015\u0001\u0005\u0002MCQa\u001b\u0001\u0005\u00021DQa\u001d\u0001\u0005\u0002\rCQ!\u001e\u0001\u0005\u0002\rCQA\u001e\u0001\u0005\u0002\rCQA\u001e\u0001\u0005\u0002aDa!!\r\u0001\t\u0003\u0019\u0005BBA\u001b\u0001\u0011\u00051\t\u0003\u0004\u0002:\u0001!\ta\u0011\u0005\u0007\u0003{\u0001A\u0011A\"\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!1\u0011\u0011\u000b\u0001\u0005\u0002\rCa!!\u0016\u0001\t\u0003\u0019\u0005BBA,\u0001\u0011\u00051\t\u0003\u0004\u0002\\\u0001!\ta\u0011\u0002\u001c\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\fE-\u00199uKJ$Vm\u001d;\u000b\u0005U1\u0012!B4s_V\u0004(BA\f\u0019\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003e\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00019A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\u000b\u0002\u00175\f7.Z\"p]R,\u0007\u0010\u001e\u000b\u0004QUj\u0004CA\u00154\u001b\u0005Q#BA\u0016-\u0003!\u0011X-];fgR\u001c(BA\u0017/\u0003\u0019\u0019w.\\7p]*\u0011\u0011d\f\u0006\u0003aE\na!\u00199bG\",'\"\u0001\u001a\u0002\u0007=\u0014x-\u0003\u00025U\tq!+Z9vKN$8i\u001c8uKb$\b\"\u0002\u001c\u0003\u0001\u00049\u0014AB1qS.+\u0017\u0010\u0005\u00029w5\t\u0011H\u0003\u0002;Y\u0005A\u0001O]8u_\u000e|G.\u0003\u0002=s\t9\u0011\t]5LKf\u001c\b\"\u0002 \u0003\u0001\u0004y\u0014AC1qSZ+'o]5p]B\u0011Q\u0004Q\u0005\u0003\u0003z\u0011Qa\u00155peR\fQ\u0003^3ti*{\u0017N\\\"p]N,X.\u001a:He>,\b\u000fF\u0001E!\tiR)\u0003\u0002G=\t!QK\\5uQ\t\u0019\u0001\n\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u0006\u0019\u0011\r]5\u000b\u00055s\u0015a\u00026va&$XM\u001d\u0006\u0003\u001fF\nQA[;oSRL!!\u0015&\u0003\tQ+7\u000f^\u0001\u000ei\u0016\u001cHOS8j]\u001e\u0013x.\u001e9\u0015\u0005\u0011#\u0006\"B+\u0005\u0001\u0004y\u0014a\u0002<feNLwN\u001c\u0015\u0003\t]\u0003\"\u0001W.\u000e\u0003eS!A\u0017'\u0002\rA\f'/Y7t\u0013\ta\u0016LA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDC\u0001\u000207MB\u0011q\fZ\u0007\u0002A*\u0011\u0011MY\u0001\u000bC:tw\u000e^1uS>t'BA2-\u0003\u0015)H/\u001b7t\u0013\t)\u0007M\u0001\u000bBa&\\U-\u001f,feNLwN\\:T_V\u00148-\u001a\u0013\u0002O&\u0011\u0001.[\u0001\u000b\u0015>KejX$S\u001fV\u0003&B\u00016:\u0003\u001d\t\u0005/[&fsN\fQ\u0002^3tiNKhnY$s_V\u0004HC\u0001#n\u0011\u0015)V\u00011\u0001@Q\t)q\u000b\u000b\u0003\u0006=Z\u0002H%A9\n\u0005IL\u0017AC*Z\u001d\u000e{vIU(V!\u0006iA/Z:u\u0011\u0016\f'\u000f\u001e2fCRD#A\u0002%\u0002\u001dQ,7\u000f\u001e'fCZ,wI]8va\u0006qA/Z:u\u0019&\u001cHo\u0012:pkB\u001c\bF\u0001\u0005I)!!\u00150a\b\u0002$\u00055\u0002\"\u0002>\n\u0001\u0004Y\u0018\u0001D:uCR,7OR5mi\u0016\u0014\b#\u0002?\u0002\n\u0005=abA?\u0002\u00069\u0019a0a\u0001\u000e\u0003}T1!!\u0001\u001b\u0003\u0019a$o\\8u}%\tq$C\u0002\u0002\by\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\f\u00055!\u0001\u0002'jgRT1!a\u0002\u001f!\u0011\t\t\"!\u0007\u000f\t\u0005M\u0011Q\u0003\t\u0003}zI1!a\u0006\u001f\u0003\u0019\u0001&/\u001a3fM&!\u00111DA\u000f\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0003\u0010\t\r\u0005\u0005\u0012\u00021\u0001|\u0003-!\u0018\u0010]3t\r&dG/\u001a:\t\u000f\u0005\u0015\u0012\u00021\u0001\u0002(\u0005!R\r\u001f9fGR,Gm\u0015;bi\u0016\u001ch)\u001b7uKJ\u0004b!!\u0005\u0002*\u0005=\u0011\u0002BA\u0016\u0003;\u00111aU3u\u0011\u001d\ty#\u0003a\u0001\u0003O\t1#\u001a=qK\u000e$X\r\u001a+za\u0016\u001ch)\u001b7uKJ\f\u0011\u0003^3ti\u0012+7o\u0019:jE\u0016<%o\\;qQ\tQ\u0001*\u0001\tuKN$H)\u001a7fi\u0016<%o\\;qg\"\u00121\u0002S\u0001\u0014i\u0016\u001cHOR3uG\"\fE\u000e\\(gMN,Go\u001d\u0015\u0003\u0019!\u000b\u0001\u0003^3ti\u001a+Go\u00195PM\u001a\u001cX\r^:)\u00055A\u0015!\u0005;fgR\u001cu.\\7ji>3gm]3ugR\u0019A)!\u0012\t\u000bUs\u0001\u0019A )\u000599\u0006&\u0002\b_m\u0005-CEAA'\u0013\r\ty%[\u0001\u000e\u001f\u001a35+\u0012+`\u0007>kU*\u0013+\u0002=Q,7\u000f^\"p[6LG\u000f\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001c\bFA\bI\u0003E!Xm\u001d;EK2,G/Z(gMN,Go]\u0001%i\u0016\u001cH\u000fR3mKR,wJ\u001a4tKR\u001cx+\u001b;i\u000fJ|W\u000f\u001d'fm\u0016dWI\u001d:pe\"\u0012\u0011\u0003S\u0001\u001ai\u0016\u001cHoQ8ogVlWM]$s_V\u0004H)Z:de&\u0014W\r\u000b\u0002\u0013\u0011\u0002")
public class GroupCoordinatorAdapterTest {
    private RequestContext makeContext(ApiKeys apiKey, short apiVersion) {
        return new RequestContext(new RequestHeader(apiKey, apiVersion, "client", 0), "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
    }

    @Test
    public void testJoinConsumerGroup() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.CONSUMER_GROUP_HEARTBEAT, ApiKeys.CONSUMER_GROUP_HEARTBEAT.latestVersion());
        ConsumerGroupHeartbeatRequestData request = new ConsumerGroupHeartbeatRequestData().setGroupId("group");
        CompletableFuture future = adapter.consumerGroupHeartbeat(ctx, request);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, UnsupportedVersionException.class);
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.JOIN_GROUP)
    public void testJoinGroup(short version) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.JOIN_GROUP, version);
        JoinGroupRequestData request = new JoinGroupRequestData().setGroupId("group").setMemberId("member").setProtocolType("consumer").setRebalanceTimeoutMs(1000).setSessionTimeoutMs(2000).setReason("reason").setProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("first").setMetadata("first".getBytes()), (List)new .colon.colon((Object)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("second").setMetadata("second".getBytes()), (List)Nil$.MODULE$)).iterator()).asJava()));
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.joinGroup(ctx, request, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedProtocols = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleJoinGroup((String)ArgumentMatchers.eq((Object)request.groupId()), (String)ArgumentMatchers.eq((Object)request.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((version >= 4 ? 1 : 0) != 0), ArgumentMatchers.eq((version >= 9 ? 1 : 0) != 0), (String)ArgumentMatchers.eq((Object)ctx.clientId()), (String)ArgumentMatchers.eq((Object)InetAddress.getLocalHost().toString()), ArgumentMatchers.eq((int)request.rebalanceTimeoutMs()), ArgumentMatchers.eq((int)request.sessionTimeoutMs()), (String)ArgumentMatchers.eq((Object)request.protocolType()), (List)capturedProtocols.capture(), (Function1)capturedCallback.capture(), (Option)ArgumentMatchers.eq((Object)new Some((Object)"reason")), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)));
        Assertions.assertEquals((Object)new .colon.colon((Object)new Tuple2((Object)"first", (Object)"first"), (List)new .colon.colon((Object)new Tuple2((Object)"second", (Object)"second"), (List)Nil$.MODULE$)), (Object)((List)capturedProtocols.getValue()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                byte[] metadata = (byte[])x0$1._2();
                return new Tuple2((Object)name, (Object)new String(metadata));
            }
            throw new MatchError(null);
        }));
        ((Function1)capturedCallback.getValue()).apply((Object)new JoinGroupResult((List)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("member").setMetadata("member".getBytes()).setGroupInstanceId("instance"), (List)Nil$.MODULE$), "member", 10, (Option)new Some((Object)"consumer"), (Option)new Some((Object)"range"), "leader", true, Errors.UNKNOWN_MEMBER_ID));
        JoinGroupResponseData expectedData = new JoinGroupResponseData().setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("member").setMetadata("member".getBytes()).setGroupInstanceId("instance"), (List)Nil$.MODULE$)).asJava()).setMemberId("member").setGenerationId(10).setProtocolType("consumer").setProtocolName("range").setLeader("leader").setSkipAssignment(true).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.SYNC_GROUP)
    public void testSyncGroup(short version) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.SYNC_GROUP, version);
        SyncGroupRequestData data = new SyncGroupRequestData().setGroupId("group").setMemberId("member1").setGroupInstanceId("instance").setProtocolType("consumer").setProtocolName("range").setGenerationId(10).setAssignments(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId("member1").setAssignment("member1".getBytes()), (List)new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId("member2").setAssignment("member2".getBytes()), (List)Nil$.MODULE$))).asJava());
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.syncGroup(ctx, data, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedAssignment = ArgumentCaptor.forClass(scala.collection.immutable.Map.class);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleSyncGroup((String)ArgumentMatchers.eq((Object)data.groupId()), ArgumentMatchers.eq((int)data.generationId()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)new Some((Object)data.protocolType())), (Option)ArgumentMatchers.eq((Object)new Some((Object)data.protocolName())), (Option)ArgumentMatchers.eq((Object)new Some((Object)data.groupInstanceId())), (Map)capturedAssignment.capture(), (Function1)capturedCallback.capture(), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member1"), (Object)"member1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member2"), (Object)"member2")})), (Object)((MapOps)capturedAssignment.getValue()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String member = (String)x0$1._1();
                byte[] metadata = (byte[])x0$1._2();
                return new Tuple2((Object)member, (Object)new String(metadata));
            }
            throw new MatchError(null);
        }));
        Some x$2 = new Some((Object)"consumer");
        Some x$3 = new Some((Object)"range");
        byte[] x$4 = "member1".getBytes();
        ((Function1)capturedCallback.getValue()).apply((Object)new SyncGroupResult((Option)x$2, (Option)x$3, x$4, Errors.NONE));
        SyncGroupResponseData expectedResponseData = new SyncGroupResponseData().setErrorCode(Errors.NONE.code()).setProtocolType("consumer").setProtocolName("range").setAssignment("member1".getBytes());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedResponseData, future.get());
    }

    @Test
    public void testHeartbeat() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.HEARTBEAT, ApiKeys.HEARTBEAT.latestVersion());
        HeartbeatRequestData data = new HeartbeatRequestData().setGroupId("group").setMemberId("member1").setGenerationId(0);
        CompletableFuture future = adapter.heartbeat(ctx, data);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleHeartbeat((String)ArgumentMatchers.eq((Object)data.groupId()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((int)data.generationId()), (Function1)capturedCallback.capture());
        Assertions.assertFalse((boolean)future.isDone());
        ((Function1)capturedCallback.getValue()).apply((Object)Errors.NONE);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)new HeartbeatResponseData(), future.get());
    }

    public void testLeaveGroup() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.LEAVE_GROUP, ApiKeys.LEAVE_GROUP.latestVersion());
        LeaveGroupRequestData data = new LeaveGroupRequestData().setGroupId("group").setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new LeaveGroupRequestData.MemberIdentity().setMemberId("member-1").setGroupInstanceId("instance-1"), (List)new .colon.colon((Object)new LeaveGroupRequestData.MemberIdentity().setMemberId("member-2").setGroupInstanceId("instance-2"), (List)Nil$.MODULE$))).asJava());
        CompletableFuture future = adapter.leaveGroup(ctx, data);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleLeaveGroup((String)ArgumentMatchers.eq((Object)data.groupId()), (List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.ListHasAsScala(data.members()).asScala().toList()), (Function1)capturedCallback.capture());
        Assertions.assertFalse((boolean)future.isDone());
        ((Function1)capturedCallback.getValue()).apply((Object)new LeaveGroupResult(Errors.NONE, (List)new .colon.colon((Object)new LeaveMemberResponse("member-1", (Option)new Some((Object)"instance-1"), Errors.NONE), (List)new .colon.colon((Object)new LeaveMemberResponse("member-2", (Option)new Some((Object)"instance-2"), Errors.NONE), (List)Nil$.MODULE$))));
        LeaveGroupResponseData expectedData = new LeaveGroupResponseData().setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new LeaveGroupResponseData.MemberResponse().setMemberId("member-1").setGroupInstanceId("instance-1"), (List)new .colon.colon((Object)new LeaveGroupResponseData.MemberResponse().setMemberId("member-2").setGroupInstanceId("instance-2"), (List)Nil$.MODULE$))).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    @Test
    public void testListGroups() {
        this.testListGroups(null, null, (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty());
        this.testListGroups((List<String>)Nil$.MODULE$, (List<String>)Nil$.MODULE$, (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty());
        this.testListGroups((List<String>)new .colon.colon((Object)"Stable, Empty", (List)Nil$.MODULE$), (List<String>)Nil$.MODULE$, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Stable, Empty"}))), (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty());
        this.testListGroups((List<String>)Nil$.MODULE$, (List<String>)new .colon.colon((Object)"classic", (List)Nil$.MODULE$), (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"classic"}))));
    }

    public void testListGroups(List<String> statesFilter, List<String> typesFilter, scala.collection.immutable.Set<String> expectedStatesFilter, scala.collection.immutable.Set<String> expectedTypesFilter) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.LIST_GROUPS, ApiKeys.LIST_GROUPS.latestVersion());
        ListGroupsRequestData data = new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava(statesFilter).asJava()).setTypesFilter(CollectionConverters$.MODULE$.SeqHasAsJava(typesFilter).asJava());
        Mockito.when((Object)groupCoordinator.handleListGroups(expectedStatesFilter, expectedTypesFilter)).thenReturn((Object)new Tuple2((Object)Errors.NOT_COORDINATOR, (Object)new .colon.colon((Object)new GroupOverview("group1", "protocol1", "Stable", "classic"), (List)new .colon.colon((Object)new GroupOverview("group2", "qwerty", "Empty", "classic"), (List)Nil$.MODULE$))));
        CompletableFuture future = adapter.listGroups(ctx, data);
        Assertions.assertTrue((boolean)future.isDone());
        ListGroupsResponseData expectedData = new ListGroupsResponseData().setErrorCode(Errors.NOT_COORDINATOR.code()).setGroups(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId("group1").setProtocolType("protocol1").setGroupState("Stable").setGroupType("classic"), (List)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId("group2").setProtocolType("qwerty").setGroupState("Empty").setGroupType("classic"), (List)Nil$.MODULE$))).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    @Test
    public void testDescribeGroup() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        String groupId1 = "group-1";
        String groupId2 = "group-2";
        GroupSummary groupSummary1 = new GroupSummary("Stable", "consumer", "roundrobin", (List)new .colon.colon((Object)new MemberSummary("memberid", (Option)new Some((Object)"instanceid"), "clientid", "clienthost", "metadata".getBytes(), "assignment".getBytes()), (List)Nil$.MODULE$));
        Mockito.when((Object)groupCoordinator.handleDescribeGroup(groupId1)).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)groupSummary1));
        Mockito.when((Object)groupCoordinator.handleDescribeGroup(groupId2)).thenReturn((Object)new Tuple2((Object)Errors.NOT_COORDINATOR, (Object)GroupCoordinator$.MODULE$.EmptyGroup()));
        RequestContext ctx = this.makeContext(ApiKeys.DESCRIBE_GROUPS, ApiKeys.DESCRIBE_GROUPS.latestVersion());
        CompletableFuture future = adapter.describeGroups(ctx, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)groupId1, (List)new .colon.colon((Object)groupId2, (List)Nil$.MODULE$))).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId1).setErrorCode(Errors.NONE.code()).setProtocolType(groupSummary1.protocolType()).setProtocolData(groupSummary1.protocol()).setGroupState(groupSummary1.state()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(((MemberSummary)groupSummary1.members().head()).memberId()).setGroupInstanceId((String)((MemberSummary)groupSummary1.members().head()).groupInstanceId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setClientId(((MemberSummary)groupSummary1.members().head()).clientId()).setClientHost(((MemberSummary)groupSummary1.members().head()).clientHost()).setMemberMetadata(((MemberSummary)groupSummary1.members().head()).metadata()).setMemberAssignment(((MemberSummary)groupSummary1.members().head()).assignment()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId2).setErrorCode(Errors.NOT_COORDINATOR.code()), (List)Nil$.MODULE$))).asJava(), future.get());
    }

    @Test
    public void testDeleteGroups() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.DELETE_GROUPS, ApiKeys.DELETE_GROUPS.latestVersion());
        .colon.colon groupIds = new .colon.colon((Object)"group-1", (List)new .colon.colon((Object)"group-2", (List)new .colon.colon((Object)"group-3", (List)Nil$.MODULE$)));
        BufferSupplier bufferSupplier = BufferSupplier.create();
        Mockito.when((Object)groupCoordinator.handleDeleteGroups((Set)groupIds.toSet(), new RequestLocal(bufferSupplier))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group-1"), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group-2"), (Object)Errors.NOT_COORDINATOR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group-3"), (Object)Errors.INVALID_GROUP_ID)})));
        CompletableFuture future = adapter.deleteGroups(ctx, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)groupIds).asJava(), bufferSupplier);
        Assertions.assertTrue((boolean)future.isDone());
        DeleteGroupsResponseData.DeletableGroupResultCollection expectedResults = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        expectedResults.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-1").setErrorCode(Errors.NONE.code()));
        expectedResults.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-2").setErrorCode(Errors.NOT_COORDINATOR.code()));
        expectedResults.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-3").setErrorCode(Errors.INVALID_GROUP_ID.code()));
        Assertions.assertEquals((Object)expectedResults, future.get());
    }

    @Test
    public void testFetchAllOffsets() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        Mockito.when((Object)groupCoordinator.handleFetchOffsets("group", true, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)new OffsetFetchResponse.PartitionData(100L, Optional.of(Predef$.MODULE$.int2Integer(1)), "foo", Errors.NONE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), (Object)new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.UNKNOWN_TOPIC_OR_PARTITION)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)new OffsetFetchResponse.PartitionData(200L, Optional.empty(), "", Errors.NONE))}))));
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_FETCH, ApiKeys.OFFSET_FETCH.latestVersion());
        CompletableFuture future = adapter.fetchAllOffsets(ctx, new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("group"), true);
        Assertions.assertTrue((boolean)future.isDone());
        .colon.colon expectedResponse = new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(foo0.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(foo0.partition()).setCommittedOffset(100L).setCommittedLeaderEpoch(1).setMetadata("foo").setErrorCode(Errors.NONE.code()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(foo1.partition()).setCommittedOffset(200L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(bar1.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(bar1.partition()).setCommittedOffset(-1L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)"group", (Object)((OffsetFetchResponseData.OffsetFetchResponseGroup)future.get()).groupId());
        Assertions.assertEquals((Object)expectedResponse.sortWith((Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$greater$extension(Predef$.MODULE$.augmentString(x$1.name()), x$2.name()))), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((OffsetFetchResponseData.OffsetFetchResponseGroup)future.get()).topics()).asScala().toList().sortWith((Function2 & Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$greater$extension(Predef$.MODULE$.augmentString(x$3.name()), x$4.name()))));
    }

    @Test
    public void testFetchOffsets() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        Mockito.when((Object)groupCoordinator.handleFetchOffsets("group", true, (Option)new Some((Object)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar1, (List)Nil$.MODULE$)))))).thenReturn((Object)new Tuple2((Object)Errors.NONE, Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)new OffsetFetchResponse.PartitionData(100L, Optional.of(Predef$.MODULE$.int2Integer(1)), "foo", Errors.NONE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), (Object)new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.UNKNOWN_TOPIC_OR_PARTITION)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)new OffsetFetchResponse.PartitionData(200L, Optional.empty(), "", Errors.NONE))}))));
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_FETCH, ApiKeys.OFFSET_FETCH.latestVersion());
        CompletableFuture future = adapter.fetchOffsets(ctx, new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("group").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(foo0.topic()).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(foo0.partition()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(foo1.partition()), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(bar1.topic()).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(bar1.partition()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$))).asJava()), true);
        Assertions.assertTrue((boolean)future.isDone());
        .colon.colon expectedResponse = new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(foo0.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(foo0.partition()).setCommittedOffset(100L).setCommittedLeaderEpoch(1).setMetadata("foo").setErrorCode(Errors.NONE.code()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(foo1.partition()).setCommittedOffset(200L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(bar1.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(bar1.partition()).setCommittedOffset(-1L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)"group", (Object)((OffsetFetchResponseData.OffsetFetchResponseGroup)future.get()).groupId());
        Assertions.assertEquals((Object)expectedResponse.sortWith((Function2 & Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$greater$extension(Predef$.MODULE$.augmentString(x$5.name()), x$6.name()))), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((OffsetFetchResponseData.OffsetFetchResponseGroup)future.get()).topics()).asScala().toList().sortWith((Function2 & Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$greater$extension(Predef$.MODULE$.augmentString(x$7.name()), x$8.name()))));
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_COMMIT)
    public void testCommitOffsets(short version) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        MockTime time = new MockTime();
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, (Time)time);
        long now = time.milliseconds();
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_COMMIT, version);
        OffsetCommitRequestData data = new OffsetCommitRequestData().setGroupId("group").setMemberId("member").setGenerationIdOrMemberEpoch(10).setRetentionTimeMs(1000L).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetCommitRequestData.OffsetCommitRequestTopic().setName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L).setCommitTimestamp(now).setCommittedLeaderEpoch(1), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.commitOffsets(ctx, data, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleCommitOffsets((String)ArgumentMatchers.eq((Object)data.groupId()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((int)data.generationIdOrMemberEpoch()), (scala.collection.immutable.Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo")), (Object)new OffsetAndMetadata(100L, Optional.of(Predef$.MODULE$.int2Integer(1)), "", now, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(now + 1000L)))))}))), (Function1)capturedCallback.capture(), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)));
        ((Function1)capturedCallback.getValue()).apply(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo")), (Object)Errors.NONE)})));
        OffsetCommitResponseData expectedResponseData = new OffsetCommitResponseData().setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetCommitResponseData.OffsetCommitResponseTopic().setName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedResponseData, future.get());
    }

    @Test
    public void testCommitTransactionalOffsets() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        MockTime time = new MockTime();
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, (Time)time);
        long now = time.milliseconds();
        RequestContext ctx = this.makeContext(ApiKeys.TXN_OFFSET_COMMIT, ApiKeys.TXN_OFFSET_COMMIT.latestVersion());
        TxnOffsetCommitRequestData data = new TxnOffsetCommitRequestData().setGroupId("group").setMemberId("member").setGenerationId(10).setProducerEpoch((short)1).setProducerId(2L).setTransactionalId("transaction-id").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L).setCommittedLeaderEpoch(1), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.commitTransactionalOffsets(ctx, data, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleTxnCommitOffsets((String)ArgumentMatchers.eq((Object)data.groupId()), (String)ArgumentMatchers.eq((Object)data.transactionalId()), ArgumentMatchers.eq((long)data.producerId()), ArgumentMatchers.eq((short)data.producerEpoch()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((int)data.generationId()), (scala.collection.immutable.Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo")), (Object)new OffsetAndMetadata(100L, Optional.of(Predef$.MODULE$.int2Integer(1)), "", now, (Option)None$.MODULE$))}))), (Function1)capturedCallback.capture(), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()));
        ((Function1)capturedCallback.getValue()).apply(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo")), (Object)Errors.NONE)})));
        TxnOffsetCommitResponseData expectedData = new TxnOffsetCommitResponseData().setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    public void testDeleteOffsets() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar0 = new TopicPartition("bar", 0);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_DELETE, ApiKeys.OFFSET_DELETE.latestVersion());
        OffsetDeleteRequestData data = new OffsetDeleteRequestData().setGroupId("group").setTopics(new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0), (List)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(1), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("bar").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0), (List)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(1), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$))).asJava().iterator()));
        BufferSupplier bufferSupplier = BufferSupplier.create();
        Mockito.when((Object)groupCoordinator.handleDeleteOffsets(data.groupId(), (Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar0, (List)new .colon.colon((Object)bar1, (List)Nil$.MODULE$)))), new RequestLocal(bufferSupplier))).thenReturn((Object)new Tuple2((Object)Errors.NONE, Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar0), (Object)Errors.GROUP_SUBSCRIBED_TO_TOPIC), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), (Object)Errors.GROUP_SUBSCRIBED_TO_TOPIC)}))));
        CompletableFuture future = adapter.deleteOffsets(ctx, data, bufferSupplier);
        OffsetDeleteResponseData expectedData = new OffsetDeleteResponseData().setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("foo").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code()), (List)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(1).setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$))).asJava().iterator())), (List)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("bar").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.GROUP_SUBSCRIBED_TO_TOPIC.code()), (List)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(1).setErrorCode(Errors.GROUP_SUBSCRIBED_TO_TOPIC.code()), (List)Nil$.MODULE$))).asJava().iterator())), (List)Nil$.MODULE$))).asJava().iterator()));
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    @Test
    public void testDeleteOffsetsWithGroupLevelError() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_DELETE, ApiKeys.OFFSET_DELETE.latestVersion());
        OffsetDeleteRequestData data = new OffsetDeleteRequestData().setGroupId("group").setTopics(new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0), (List)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(1), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$)).asJava().iterator()));
        BufferSupplier bufferSupplier = BufferSupplier.create();
        Mockito.when((Object)groupCoordinator.handleDeleteOffsets(data.groupId(), (Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)Nil$.MODULE$)), new RequestLocal(bufferSupplier))).thenReturn((Object)new Tuple2((Object)Errors.INVALID_GROUP_ID, (Object)Predef$.MODULE$.Map().empty()));
        CompletableFuture future = adapter.deleteOffsets(ctx, data, bufferSupplier);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, InvalidGroupIdException.class);
    }

    @Test
    public void testConsumerGroupDescribe() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext context = this.makeContext(ApiKeys.CONSUMER_GROUP_DESCRIBE, ApiKeys.CONSUMER_GROUP_DESCRIBE.latestVersion());
        java.util.List groupIds = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"group-id-1", (List)new .colon.colon((Object)"group-id-2", (List)Nil$.MODULE$))).asJava();
        CompletableFuture future = adapter.consumerGroupDescribe(context, groupIds);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, UnsupportedVersionException.class);
    }
}

