/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.ticket;

import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequest;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.validator.authorization.BaseOAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;

public class OidcPushedAuthorizationRequestValidator
extends BaseOAuth20AuthorizationRequestValidator {
    private final TicketRegistry ticketRegistry;
    private final TicketFactory ticketFactory;

    public OidcPushedAuthorizationRequestValidator(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, AuditableExecution registeredServiceAccessStrategyEnforcer, TicketRegistry ticketRegistry, TicketFactory ticketFactory, OAuth20RequestParameterResolver requestParameterResolver) {
        super(servicesManager, webApplicationServiceServiceFactory, registeredServiceAccessStrategyEnforcer, requestParameterResolver);
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
    }

    public boolean validate(WebContext context) {
        return (Boolean)FunctionUtils.doAndHandle(() -> {
            String requestUri = (String)context.getRequestParameter("request_uri").orElseThrow();
            OidcPushedAuthorizationRequest uriToken = (OidcPushedAuthorizationRequest)this.ticketRegistry.getTicket(requestUri, OidcPushedAuthorizationRequest.class);
            OidcPushedAuthorizationRequestFactory uriFactory = (OidcPushedAuthorizationRequestFactory)this.ticketFactory.get(OidcPushedAuthorizationRequest.class);
            AccessTokenRequestContext holder = uriFactory.toAccessTokenRequest(uriToken);
            context.setRequestAttribute(OidcPushedAuthorizationRequest.class.getName(), (Object)holder);
            String givenClientId = this.getClientIdFromRequest(context);
            return givenClientId.equals(holder.getClientId()) && this.verifyRegisteredServiceByClientId(context, holder.getClientId()) != null;
        }, throwable -> false).get();
    }

    public boolean supports(WebContext context) {
        return context.getRequestParameter("client_id").isPresent() && context.getRequestParameter("request_uri").isPresent();
    }

    public int getOrder() {
        return 0;
    }
}

