/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.keymaster.internal;

import java.util.List;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.KeymasterProperties;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.core.logic.NetworkServiceLogic;
import org.apache.syncope.core.spring.security.AuthContextUtils;

public class SelfKeymasterInternalServiceOps
implements ServiceOps {
    protected final NetworkServiceLogic logic;
    protected final KeymasterProperties props;

    public SelfKeymasterInternalServiceOps(NetworkServiceLogic logic, KeymasterProperties props) {
        this.logic = logic;
        this.props = props;
    }

    public List<NetworkService> list(NetworkService.Type serviceType) {
        return (List)AuthContextUtils.callAs((String)"Master", (String)this.props.getUsername(), List.of(), () -> this.logic.list(serviceType));
    }

    public NetworkService get(NetworkService.Type serviceType) {
        try {
            return (NetworkService)AuthContextUtils.callAs((String)"Master", (String)this.props.getUsername(), List.of(), () -> this.logic.get(serviceType));
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }

    public void register(NetworkService service) {
        AuthContextUtils.callAs((String)"Master", (String)this.props.getUsername(), List.of(), () -> {
            this.logic.register(service);
            return null;
        });
    }

    public void unregister(NetworkService service) {
        AuthContextUtils.callAs((String)"Master", (String)this.props.getUsername(), List.of(), () -> {
            this.logic.unregister(service);
            return null;
        });
    }
}

