/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldup.search;

import java.util.List;
import net.tirasa.connid.bundles.ldup.LdUpUtils;
import net.tirasa.connid.bundles.ldup.search.LdUpFilter;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.AttributeFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsAllValuesFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.SingleValueAttributeFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;

public class LdUpFilterTranslator
extends AbstractFilterTranslator<LdUpFilter> {
    protected final LdUpUtils ldUpUtils;
    protected final ObjectClass objectClass;

    protected static StringBuilder createBuilder(boolean not) {
        return new StringBuilder(not ? "(!(" : "(");
    }

    protected static LdUpFilter finishBuilder(StringBuilder builder) {
        boolean not = builder.charAt(0) == '(' && builder.charAt(1) == '!';
        builder.append(not ? "))" : ")");
        return LdUpFilter.forNativeFilter(builder.toString());
    }

    private static boolean escapeByteArrayAttrValue(byte[] value, StringBuilder builder) {
        if (value.length == 0) {
            return false;
        }
        for (byte b : value) {
            builder.append('\\');
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() < 2) {
                builder.append('0');
            }
            builder.append(hex);
        }
        return true;
    }

    private static boolean escapeStringAttrValue(String value, StringBuilder builder) {
        if (StringUtil.isEmpty((String)value)) {
            return false;
        }
        block7: for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '*': {
                    builder.append("\\2a");
                    continue block7;
                }
                case '(': {
                    builder.append("\\28");
                    continue block7;
                }
                case ')': {
                    builder.append("\\29");
                    continue block7;
                }
                case '\\': {
                    builder.append("\\5c");
                    continue block7;
                }
                case '\u0000': {
                    builder.append("\\00");
                    continue block7;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        return true;
    }

    protected static boolean escapeAttrValue(Object value, StringBuilder toBuilder) {
        if (value == null) {
            return false;
        }
        if (value instanceof byte[]) {
            return LdUpFilterTranslator.escapeByteArrayAttrValue((byte[])value, toBuilder);
        }
        return LdUpFilterTranslator.escapeStringAttrValue(value.toString(), toBuilder);
    }

    public LdUpFilterTranslator(LdUpUtils ldUpUtils, ObjectClass objectClass) {
        this.ldUpUtils = ldUpUtils;
        this.objectClass = objectClass;
    }

    public LdUpFilter createAndExpression(LdUpFilter leftExpression, LdUpFilter rightExpression) {
        return leftExpression.and(rightExpression);
    }

    public LdUpFilter createOrExpression(LdUpFilter leftExpression, LdUpFilter rightExpression) {
        return leftExpression.or(rightExpression);
    }

    public LdUpFilter createContainsExpression(ContainsFilter filter, boolean not) {
        String attrName = this.ldUpUtils.getLdapAttribute(this.objectClass, filter.getAttribute().getName()).orElse(null);
        if (attrName == null) {
            return null;
        }
        if (LdUpUtils.isDNAttribute(attrName)) {
            return LdUpFilter.forEntryDN(filter.getValue());
        }
        StringBuilder builder = LdUpFilterTranslator.createBuilder(not).append(attrName).append('=').append('*');
        if (LdUpFilterTranslator.escapeAttrValue(filter.getValue(), builder)) {
            builder.append('*');
        }
        return LdUpFilterTranslator.finishBuilder(builder);
    }

    public LdUpFilter createEndsWithExpression(EndsWithFilter filter, boolean not) {
        String attrName = this.ldUpUtils.getLdapAttribute(this.objectClass, filter.getAttribute().getName()).orElse(null);
        if (attrName == null) {
            return null;
        }
        if (LdUpUtils.isDNAttribute(attrName)) {
            return LdUpFilter.forEntryDN(filter.getValue());
        }
        StringBuilder builder = LdUpFilterTranslator.createBuilder(not).append(attrName).append('=').append('*');
        LdUpFilterTranslator.escapeAttrValue(filter.getValue(), builder);
        return LdUpFilterTranslator.finishBuilder(builder);
    }

    protected LdUpFilter createContainsAllValuesFilter(AttributeFilter filter, boolean not) {
        String attrName = this.ldUpUtils.getLdapAttribute(this.objectClass, filter.getAttribute().getName()).orElse(null);
        if (attrName == null) {
            return null;
        }
        List values = filter.getAttribute().getValue();
        if (values == null) {
            return null;
        }
        switch (values.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Object single = values.get(0);
                if (single == null) {
                    return null;
                }
                if (LdUpUtils.isDNAttribute(attrName)) {
                    return LdUpFilter.forEntryDN(single.toString());
                }
                StringBuilder builder = LdUpFilterTranslator.createBuilder(not);
                LdUpFilterTranslator.addSimpleFilter(attrName, "=", values.get(0), builder);
                return LdUpFilterTranslator.finishBuilder(builder);
            }
        }
        if (LdUpUtils.isDNAttribute(attrName)) {
            return null;
        }
        StringBuilder builder = LdUpFilterTranslator.createBuilder(not);
        boolean hasValue = false;
        builder.append('&');
        for (Object value : values) {
            if (value == null) continue;
            hasValue = true;
            builder.append('(');
            LdUpFilterTranslator.addSimpleFilter(attrName, "=", value, builder);
            builder.append(')');
        }
        if (!hasValue) {
            return null;
        }
        return LdUpFilterTranslator.finishBuilder(builder);
    }

    public LdUpFilter createEqualsExpression(EqualsFilter filter, boolean not) {
        return this.createContainsAllValuesFilter((AttributeFilter)filter, not);
    }

    protected LdUpFilter createEqualsIgnoreCaseExpression(EqualsIgnoreCaseFilter filter, boolean not) {
        Attribute attr = filter.getValue() == null ? AttributeBuilder.build((String)filter.getName()) : AttributeBuilder.build((String)filter.getName(), (Object[])new Object[]{filter.getValue()});
        return this.createEqualsExpression(new EqualsFilter(attr), not);
    }

    protected static void addSimpleFilter(String ldapAttr, String type, Object value, StringBuilder toBuilder) {
        toBuilder.append(ldapAttr).append(type);
        if (!LdUpFilterTranslator.escapeAttrValue(value, toBuilder)) {
            toBuilder.append('*');
        }
    }

    protected LdUpFilter createSingleValueFilter(String type, SingleValueAttributeFilter filter, boolean not) {
        String attrName = this.ldUpUtils.getLdapAttribute(this.objectClass, filter.getAttribute().getName()).orElse(null);
        if (attrName == null) {
            return null;
        }
        if (LdUpUtils.isDNAttribute(attrName)) {
            return LdUpFilter.forEntryDN(filter.getValue().toString());
        }
        StringBuilder builder = LdUpFilterTranslator.createBuilder(not);
        LdUpFilterTranslator.addSimpleFilter(attrName, type, filter.getValue(), builder);
        return LdUpFilterTranslator.finishBuilder(builder);
    }

    public LdUpFilter createGreaterThanExpression(GreaterThanFilter filter, boolean not) {
        return this.createSingleValueFilter("<=", (SingleValueAttributeFilter)filter, !not);
    }

    public LdUpFilter createGreaterThanOrEqualExpression(GreaterThanOrEqualFilter filter, boolean not) {
        return this.createSingleValueFilter(">=", (SingleValueAttributeFilter)filter, not);
    }

    public LdUpFilter createLessThanExpression(LessThanFilter filter, boolean not) {
        return this.createSingleValueFilter(">=", (SingleValueAttributeFilter)filter, !not);
    }

    public LdUpFilter createLessThanOrEqualExpression(LessThanOrEqualFilter filter, boolean not) {
        return this.createSingleValueFilter("<=", (SingleValueAttributeFilter)filter, not);
    }

    public LdUpFilter createStartsWithExpression(StartsWithFilter filter, boolean not) {
        String attrName = this.ldUpUtils.getLdapAttribute(this.objectClass, filter.getAttribute().getName()).orElse(null);
        if (attrName == null) {
            return null;
        }
        if (LdUpUtils.isDNAttribute(attrName)) {
            return LdUpFilter.forEntryDN(filter.getValue());
        }
        StringBuilder builder = LdUpFilterTranslator.createBuilder(not).append(attrName).append('=');
        LdUpFilterTranslator.escapeAttrValue(filter.getValue(), builder);
        builder.append('*');
        return LdUpFilterTranslator.finishBuilder(builder);
    }

    public LdUpFilter createContainsAllValuesExpression(ContainsAllValuesFilter filter, boolean not) {
        return this.createContainsAllValuesFilter((AttributeFilter)filter, not);
    }
}

