/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.io.File;
import java.io.IOException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.VfsResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.config.FlowDefinitionResource;
import org.springframework.webflow.core.collection.AttributeMap;

public class FlowDefinitionResourceFactory {
    private static final String CLASSPATH_SCHEME = "classpath:";
    private static final String CLASSPATH_STAR_SCHEME = "classpath*:";
    private static final String FILESYSTEM_SCHEME = "file:";
    private static final String SLASH = "/";
    private ResourceLoader resourceLoader;
    private String basePath;

    public FlowDefinitionResourceFactory() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public FlowDefinitionResourceFactory(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"The resource loader cannot be null");
        this.resourceLoader = resourceLoader;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public FlowDefinitionResource createResource(String path) {
        return this.createResource(path, null, null);
    }

    public FlowDefinitionResource createResource(String path, AttributeMap<Object> attributes) {
        return this.createResource(path, attributes, null);
    }

    public FlowDefinitionResource createResource(String path, AttributeMap<Object> attributes, String flowId) {
        Resource resource;
        if (this.basePath == null) {
            resource = this.resourceLoader.getResource(path);
        } else {
            try {
                Object basePath = this.basePath;
                if (!((String)basePath).endsWith(SLASH)) {
                    basePath = (String)basePath + SLASH;
                }
                resource = this.resourceLoader.getResource((String)basePath).createRelative(path);
            }
            catch (IOException e) {
                throw new IllegalStateException("The base path cannot be resolved from '" + this.basePath + "': " + e.getMessage());
            }
        }
        if (flowId == null || flowId.length() == 0) {
            flowId = this.getFlowId(resource);
        }
        return new FlowDefinitionResource(flowId, resource, attributes);
    }

    public FlowDefinitionResource[] createResources(String pattern, AttributeMap<Object> attributes) throws IOException {
        if (this.resourceLoader instanceof ResourcePatternResolver) {
            ResourcePatternResolver resolver = (ResourcePatternResolver)this.resourceLoader;
            Resource[] resources = this.basePath == null ? resolver.getResources(pattern) : (this.basePath.endsWith(SLASH) || pattern.startsWith(SLASH) ? resolver.getResources(this.basePath + pattern) : resolver.getResources(this.basePath + SLASH + pattern));
            FlowDefinitionResource[] flowResources = new FlowDefinitionResource[resources.length];
            for (int i = 0; i < resources.length; ++i) {
                Resource resource = resources[i];
                flowResources[i] = new FlowDefinitionResource(this.getFlowId(resource), resource, attributes);
            }
            return flowResources;
        }
        throw new IllegalStateException("Cannot create flow definition resources from patterns without a ResourceLoader configured that is a ResourcePatternResolver");
    }

    public FlowDefinitionResource createFileResource(String path) {
        FileSystemResource resource = new FileSystemResource(new File(path));
        return new FlowDefinitionResource(this.getFlowId((Resource)resource), (Resource)resource, null);
    }

    public FlowDefinitionResource createClassPathResource(String path, Class<?> clazz) {
        ClassPathResource resource = new ClassPathResource(path, clazz);
        return new FlowDefinitionResource(this.getFlowId((Resource)resource), (Resource)resource, null);
    }

    protected String getFlowId(Resource flowResource) {
        String filePath;
        if (this.basePath == null) {
            return this.getFlowIdFromFileName(flowResource);
        }
        String basePath = this.removeScheme(this.basePath);
        if (flowResource instanceof ContextResource) {
            filePath = ((ContextResource)flowResource).getPathWithinContext();
        } else if (flowResource instanceof ClassPathResource) {
            filePath = ((ClassPathResource)flowResource).getPath();
        } else if (flowResource instanceof FileSystemResource) {
            filePath = this.truncateFilePath(((FileSystemResource)flowResource).getPath(), basePath);
        } else if (flowResource instanceof UrlResource || flowResource instanceof VfsResource) {
            try {
                filePath = this.truncateFilePath(flowResource.getURL().getPath(), basePath);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to obtain path: " + e.getMessage());
            }
        } else {
            return this.getFlowIdFromFileName(flowResource);
        }
        int beginIndex = 0;
        int endIndex = filePath.length();
        if (filePath.startsWith(basePath)) {
            beginIndex = basePath.length();
        } else if (filePath.startsWith(SLASH + basePath)) {
            beginIndex = basePath.length() + 1;
        }
        if (filePath.startsWith(SLASH, beginIndex)) {
            ++beginIndex;
        }
        if (filePath.lastIndexOf(SLASH) < beginIndex) {
            return this.getFlowIdFromFileName(flowResource);
        }
        endIndex = filePath.lastIndexOf(SLASH);
        return filePath.substring(beginIndex, endIndex);
    }

    private String getFlowIdFromFileName(Resource flowResource) {
        return StringUtils.stripFilenameExtension((String)flowResource.getFilename());
    }

    private String truncateFilePath(String filePath, String basePath) {
        int basePathIndex = filePath.lastIndexOf(basePath);
        if (basePathIndex != -1) {
            return filePath.substring(basePathIndex);
        }
        return filePath;
    }

    private String removeScheme(String basePath) {
        if (basePath.startsWith(CLASSPATH_SCHEME)) {
            return basePath.substring(CLASSPATH_SCHEME.length());
        }
        if (basePath.startsWith(FILESYSTEM_SCHEME)) {
            return basePath.substring(FILESYSTEM_SCHEME.length());
        }
        if (basePath.startsWith(CLASSPATH_STAR_SCHEME)) {
            return basePath.substring(CLASSPATH_STAR_SCHEME.length());
        }
        return basePath;
    }
}

