/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.common.proto;

import java.io.ByteArrayOutputStream;

public final class PeekableByteArrayOutputStream
extends ByteArrayOutputStream {
    private int position = 0;

    public PeekableByteArrayOutputStream(int size) {
        super(size);
    }

    public int available() {
        return this.size() - this.position;
    }

    public int read() {
        if (this.available() == 0) {
            return -1;
        }
        byte to_return = this.buf[this.position++];
        if (this.available() == 0) {
            this.reset();
        }
        return to_return;
    }

    public int read(byte[] readInput, int off, int len) {
        if (this.count == this.position) {
            return -1;
        }
        int limit_to_read = Math.min(len, this.count - this.position);
        System.arraycopy(this.buf, this.position, readInput, off, limit_to_read);
        this.position += limit_to_read;
        if (this.available() == 0) {
            this.reset();
        }
        return limit_to_read;
    }

    @Override
    public void reset() {
        super.reset();
        this.position = 0;
    }
}

