/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.transport;

import com.google.common.collect.HashMultimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.XMLParserException;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URLEncodedUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.AbstractMessageDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.pac4j.core.context.CallContext;
import org.pac4j.saml.context.SAML2MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPac4jDecoder
extends AbstractMessageDecoder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPac4jDecoder.class);
    static final String[] SAML_PARAMETERS = new String[]{"SAMLRequest", "SAMLResponse", "logoutRequest"};
    protected ParserPool parserPool;
    protected final CallContext callContext;

    protected byte[] getBase64DecodedMessage() throws MessageDecodingException {
        Optional<String> encodedMessage = Optional.empty();
        for (String parameter : SAML_PARAMETERS) {
            encodedMessage = this.callContext.webContext().getRequestParameter(parameter);
            if (encodedMessage.isPresent()) break;
        }
        if (encodedMessage.isEmpty() && (encodedMessage = Optional.ofNullable(this.callContext.webContext().getRequestContent())).isPresent()) {
            List a = URLEncodedUtils.parse((CharSequence)((CharSequence)encodedMessage.get()), (Charset)StandardCharsets.UTF_8);
            HashMultimap paramMap = HashMultimap.create();
            for (NameValuePair p : a) {
                paramMap.put((Object)p.getName(), (Object)p.getValue());
            }
            for (String parameter : SAML_PARAMETERS) {
                Collection newEncodedMessageCollection = paramMap.get((Object)parameter);
                if (newEncodedMessageCollection == null || newEncodedMessageCollection.isEmpty()) continue;
                encodedMessage = Optional.of((String)newEncodedMessageCollection.iterator().next());
                break;
            }
        }
        if (encodedMessage.isEmpty()) {
            throw new MessageDecodingException("Request did not contain either a SAMLRequest parameter, a SAMLResponse parameter, a logoutRequest parameter or a body content");
        }
        if (((String)encodedMessage.get()).contains("<")) {
            LOGGER.trace("Raw SAML message:\n{}", (Object)encodedMessage);
            return ((String)encodedMessage.get()).getBytes(StandardCharsets.UTF_8);
        }
        try {
            byte[] decodedBytes = Base64Support.decode((String)((String)encodedMessage.get()));
            LOGGER.trace("Decoded SAML message:\n{}", (Object)new String(decodedBytes, StandardCharsets.UTF_8));
            return decodedBytes;
        }
        catch (Exception e) {
            throw new MessageDecodingException(e);
        }
    }

    protected void doDestroy() {
        this.parserPool = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        LOGGER.debug("Initialized {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        if (this.parserPool == null) {
            throw new ComponentInitializationException("Parser pool cannot be null");
        }
    }

    protected void populateBindingContext(SAML2MessageContext messageContext) {
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.getMessageContext().getSubcontext(SAMLBindingContext.class, true);
        bindingContext.setBindingUri(this.getBindingURI(messageContext));
        bindingContext.setHasBindingSignature(false);
        bindingContext.setRelayState(bindingContext.getRelayState());
        bindingContext.setIntendedDestinationEndpointURIRequired(SAMLBindingSupport.isMessageSigned((MessageContext)messageContext.getMessageContext()));
    }

    public abstract String getBindingURI(SAML2MessageContext var1);

    protected XMLObject unmarshallMessage(InputStream messageStream) throws MessageDecodingException {
        try {
            XMLObject message = XMLObjectSupport.unmarshallFromInputStream((ParserPool)this.getParserPool(), (InputStream)messageStream);
            return message;
        }
        catch (XMLParserException e) {
            throw new MessageDecodingException("Error unmarshalling message from input stream", (Exception)((Object)e));
        }
        catch (UnmarshallingException e) {
            throw new MessageDecodingException("Error unmarshalling message from input stream", (Exception)((Object)e));
        }
    }

    public void setParserPool(ParserPool pool) {
        Constraint.isNotNull((Object)pool, (String)"ParserPool cannot be null");
        this.parserPool = pool;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbstractPac4jDecoder(CallContext callContext) {
        this.callContext = callContext;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ParserPool getParserPool() {
        return this.parserPool;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CallContext getCallContext() {
        return this.callContext;
    }
}

