/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import org.eclipse.jetty.util.VirtualThreads;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.embedded.JettyThreadPool;
import org.springframework.boot.web.embedded.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class JettyVirtualThreadsWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableJettyWebServerFactory>,
Ordered {
    private final ServerProperties serverProperties;

    public JettyVirtualThreadsWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void customize(ConfigurableJettyWebServerFactory factory) {
        Assert.state((boolean)VirtualThreads.areSupported(), (String)"Virtual threads are not supported");
        QueuedThreadPool threadPool = JettyThreadPool.create(this.serverProperties.getJetty().getThreads());
        threadPool.setVirtualThreadsExecutor(VirtualThreads.getNamedVirtualThreadsExecutor((String)"jetty-"));
        factory.setThreadPool((ThreadPool)threadPool);
    }

    public int getOrder() {
        return 1;
    }
}

